/**
 * 
 */
package testing;

import static org.junit.Assert.*;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

import org.openqa.selenium.remote.DesiredCapabilities;

/**
 * @author DNS   PEREZF
 *
 */
public class DisapproveClaimsPageTest {
	private WebDriver driver;
	private String baseUrl;
	private String disapproveClaimsPageUrl;
	private String agedClaimsPageUrl;
	private String searchClaimsPageUrl;
	
	public static void main(String args[]) {
		JUnitCore junit = new JUnitCore();
		junit.addListener(new TextListener(System.out));
		Result result = junit.run(DisapproveClaimsPageTest.class); // Replace "SampleTest" with the name of your class
		if (result.getFailureCount() > 0) {
		    System.out.println("Test failed.\n" + result);
		    System.exit(1);
		} else {
		    System.out.println("Test finished successfully.");
		    System.exit(0);
		}
	}

	/**
	 * @throws java.lang.Exception
	 */
	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin setUpBeforeClass()");
		System.out.println("DisapproveClaimsPageTest: End setUpBeforeClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@AfterClass
	public static void tearDownAfterClass() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin tearDownAfterClass()");
		System.out.println("DisapproveClaimsPageTest: End tearDownAfterClass()");
	}

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin setUp()");
		
		File file = new File("drivers/IEDriverServer.exe");
		System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		driver = new InternetExplorerDriver();
		
		baseUrl = "http://localhost:4200/";
		driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
		System.out.println("End Executing 'setUp' method");
		
		disapproveClaimsPageUrl = baseUrl + "disapprove";
		agedClaimsPageUrl = baseUrl + "agedClaims";
		searchClaimsPageUrl = baseUrl + "search";

		goToLoginPageAndClickLoginButton();
		Thread.sleep(2000);
		
		clickSetActiveButton();
		Thread.sleep(2000);
		
		System.out.println("DisapproveClaimsPageTest: End setUp()");
	}
	
	// Assumes that there will be Claims in the Table and that there will be an "errorMessage".
	private void goToDisapproveClaimsPageViaAgedClaimsPageSelectingAllClaims() throws Exception {
		driver.get(agedClaimsPageUrl);
		Thread.sleep(3000);
		
		WebElement pageTitleElement = driver.findElement(By.className("page-title"));
		WebElement pageTitle_h1_Element = pageTitleElement.findElement(By.tagName("h1"));
		assertEquals("Aged Claims Page not reached!", "Aged Claims", pageTitle_h1_Element.getText());
		
		// Selected all the Claims in the Aged Claims Table.
		WebElement tableComponentElement = driver.findElement(By.id("table"));	
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("select"));
		WebElement selectColumnCheckBoxElement = selectedColumnElement.findElement(By.name("colcheckbox"));
		selectColumnCheckBoxElement.click();
		Thread.sleep(2000);
		
		// Click on the Disapprove Button of the Aged Claims Page.
		WebElement disapproveButtonElement = driver.findElement(By.id("upperDisapproveButton"));
		disapproveButtonElement.click();
		Thread.sleep(2000);
		
		// Test to see that it is the Disapprove Claims Page that has been reached.
		pageTitleElement = driver.findElement(By.className("page-title"));
		pageTitle_h1_Element = pageTitleElement.findElement(By.tagName("h1"));
		assertEquals("Disapprove Claims Page not reached! Incorrect Title!", "Disapprove Claims", pageTitle_h1_Element.getText());
		assertEquals("Inorrect URL reached for Disapprove Claims Page!", disapproveClaimsPageUrl, driver.getCurrentUrl());
		
		Thread.sleep(2000);
	}
	
	private void goToDisapproveClaimsPageViaSearchClaimsPageAndSelectingOnlyRejectedClaims() throws Exception {
		driver.get(searchClaimsPageUrl);
		Thread.sleep(3000);
		
		// Verify it's the Search Claims Page.
		WebElement pageTitleElement = driver.findElement(By.className("page-title"));
		WebElement pageTitle_h1_Element = pageTitleElement.findElement(By.tagName("h1"));
		assertEquals("Search Claims Page not reached!", "Claims Search", pageTitle_h1_Element.getText());
		
		// Select the "All" Claim Type.
		Select claimTypeSelectBox = new Select(driver.findElement(By.name("claimType")));
		claimTypeSelectBox.selectByVisibleText("All");
		Thread.sleep(1000);
		
		// Select the "Rejected" Claim Status.
		Select claimStatusSelectBox = new Select(driver.findElement(By.name("claimStatus")));
		claimStatusSelectBox.selectByVisibleText("Rejected");
		Thread.sleep(1000);
		
		// Click on the Search Button to bring uo all the "Rejected" Claims.
		WebElement searchButtonElement = driver.findElement(By.id("search"));
		searchButtonElement.click();
		Thread.sleep(4000);
		
		// Select all the Rejected Claims for Disapproval.
		WebElement tableComponentElement = driver.findElement(By.id("table"));
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("select"));
		WebElement columnCheckBoxElement = selectedColumnElement.findElement(By.name("colcheckbox"));
		columnCheckBoxElement.click();
		Thread.sleep(2000);	
		
		// Click on the Disapprove Button.
		WebElement disapproveButtonElement = driver.findElement(By.id("upperDisapprove"));
		disapproveButtonElement.click();
		
		Thread.sleep(4000);
	}
	
	private void goToDisapproveClaimsPageViaSearchClaimsPageAndSelectingOnlyCompletedClaims() throws Exception {
		driver.get(searchClaimsPageUrl);
		Thread.sleep(3000);
		
		// Verify it's the Search Claims Page.
		WebElement pageTitleElement = driver.findElement(By.className("page-title"));
		WebElement pageTitle_h1_Element = pageTitleElement.findElement(By.tagName("h1"));
		assertEquals("Search Claims Page not reached!", "Claims Search", pageTitle_h1_Element.getText());
		
		// Select the "All" Claim Type.
		Select claimTypeSelectBox = new Select(driver.findElement(By.name("claimType")));
		claimTypeSelectBox.selectByVisibleText("All");
		Thread.sleep(1000);
		
		// Select the "Complete" Claim Status.
		Select claimStatusSelectBox = new Select(driver.findElement(By.name("claimStatus")));
		claimStatusSelectBox.selectByVisibleText("Complete");
		Thread.sleep(1000);
		
		// Click on the Search Button to bring uo all the "Rejected" Claims.
		WebElement searchButtonElement = driver.findElement(By.id("search"));
		searchButtonElement.click();
		Thread.sleep(4000);
		
		// Select all the Rejected Claims for Disapproval.
		WebElement tableComponentElement = driver.findElement(By.id("table"));
		WebElement dataTableElement = tableComponentElement.findElement(By.id("datatable"));
		WebElement selectedColumnElement = dataTableElement.findElement(By.id("select"));
		WebElement columnCheckBoxElement = selectedColumnElement.findElement(By.name("colcheckbox"));
		columnCheckBoxElement.click();
		Thread.sleep(2000);	
		
		// Click on the Disapprove Button.
		WebElement disapproveButtonElement = driver.findElement(By.id("upperDisapprove"));
		disapproveButtonElement.click();
		
		Thread.sleep(4000);		
	}
	
	private void clickSetActiveButton() throws Exception {
		WebElement setActiveButton = driver.findElement(By.id("setActive"));
		assertNotNull(setActiveButton);
		setActiveButton.click();
		// setActiveButton.submit(); // Not inside of a "form" element.
		setActiveButton.sendKeys(Keys.ENTER);
	}

	private void goToLoginPageAndClickLoginButton() throws Exception {
		driver.get(baseUrl);
		WebElement loginButton = driver.findElement(By.id("loginBtn"));
		assertNotNull(loginButton);
		
		// Click the Login Button. Had to do this as advised by Joshua Lone
		// to get this to work to forward to next page.
		loginButton.click();
		loginButton.submit();
		loginButton.sendKeys(Keys.ENTER);
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin tearDown()");
		
		Thread.sleep(5000);
		driver.close();
		driver.quit();
		
		System.out.println("DisapproveClaimsPageTest: End tearDown()");
	}

	@Test
	public void test_1_cancelButton() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin test_1_cancelButton()");
		
		goToDisapproveClaimsPageViaAgedClaimsPageSelectingAllClaims();
		
		WebElement cancelButton = driver.findElement(By.id("cancelButton"));
		
		cancelButton.click();
		Thread.sleep(3000);
		
		// Had to comment out the below due to getting a StateElementReferenceException 
		//   stating that the Element is no longer valid.
		// cancelButton.submit();
		// cancelButton.sendKeys(Keys.ENTER);
		
		WebElement pageTitleElement = driver.findElement(By.id("pageTitle"));
		assertNotNull(pageTitleElement);
		
		assertEquals("Incorrect Page Title for page forwarded after clicking 'Cancel' button!", 
			"Claims", pageTitleElement.getText());
		
		assertEquals("Inorrect URL reached for Claims Home Page!", "http://localhost:4200/claimsHomePage", driver.getCurrentUrl());
		
		System.out.println("DisapproveClaimsPageTest: End test_1_cancelButton()");
	}
	
	@Test
	public void test_2_failureMessageWhenClaimsInTable() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin test_2_failureMessageWhenClaimsInTable()");
		
		goToDisapproveClaimsPageViaAgedClaimsPageSelectingAllClaims();
		
		// Exception thrown if not present.
		WebElement alertErrorMessageElement = driver.findElement(By.id("errorMessageWhenClaimsPresentInTable"));
		
		String partOfExpectedErrorMessage_1 = "The following claims cannot be disapproved because they are ";
		assertTrue("Expected First part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_1));
		
		String partOfExpectedErrorMessage_2 = "completed, partially reconciled, or rejected: ";
		assertTrue("Expected Second part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_2));
		
		System.out.println("DisapproveClaimsPageTest: End test_2_failureMessageWhenClaimsInTable()");
	}
	
	@Test
	public void test_3_failureMessageWhenClaimsAllRejected() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin test_3_failureMessageWhenClaimsAllRejected()");
		
		goToDisapproveClaimsPageViaSearchClaimsPageAndSelectingOnlyRejectedClaims();
		
		// Exception thrown if not present.
		WebElement alertErrorMessageElement = driver.findElement(By.id("errorMessageWhenNoClaimsPresentInTable"));
		
		String partOfExpectedErrorMessage_1 = "The following claims cannot be disapproved because they are ";
		assertTrue("Expected First part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_1));
		
		String partOfExpectedErrorMessage_2 = "completed, partially reconciled, or rejected: ";
		assertTrue("Expected Second part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_2));
		
		System.out.println("DisapproveClaimsPageTest: End test_3_failureMessageWhenClaimsAllRejected()");
	}
	
	@Test
	public void test_4_failureMessageWhenClaimsAllCompleted() throws Exception {
		System.out.println("DisapproveClaimsPageTest: Begin test_4_failureMessageWhenClaimsAllCompleted()");
		
		goToDisapproveClaimsPageViaSearchClaimsPageAndSelectingOnlyCompletedClaims();
		
		// Exception thrown if not present.
		WebElement alertErrorMessageElement = driver.findElement(By.id("errorMessageWhenNoClaimsPresentInTable"));
		
		String partOfExpectedErrorMessage_1 = "The following claims cannot be disapproved because they are ";
		assertTrue("Expected First part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_1));
		
		String partOfExpectedErrorMessage_2 = "completed, partially reconciled, or rejected: ";
		assertTrue("Expected Second part of Failure Message not present!", alertErrorMessageElement.getText().contains(partOfExpectedErrorMessage_2));
		
		System.out.println("DisapproveClaimsPageTest: End test_4_failureMessageWhenClaimsAllCompleted()");
	}

}
