package testing;

import java.io.File;
import java.util.Random;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runners.MethodSorters;
import org.openqa.selenium.By;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.CreateUserRequestPage;
import Pages.HeaderMenu;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)

public class CreateUserRequestTest {

  public static void main(String[] args) {
    JUnitCore junit = new JUnitCore();
    junit.addListener(new TextListener(System.out));
    Result result = junit.run(CreateUserRequestTest.class); // Replace "SampleTest" with the name of your class
    if (result.getFailureCount() > 0) {
      System.out.println("Test failed.\n" + result);
      System.exit(1);
    } else {
      System.out.println("Test finished successfully.");
      System.exit(0);
    }
  }

  static InternetExplorerDriver driver;
  static String baseURL;
  static Acceptance acceptance;
  static HeaderMenu headerMenu;
  static CreateUserRequestPage page;

  CreateUserRequestTest() {
  }

  @BeforeClass
  public static void setUpBeforeClass() throws Exception {
    System.out.println("CreateUserRequestTest: Begin setUpBeforeClass()");

    File file = new File("drivers/IEDriverServer.exe");
    System.setProperty("webdriver.ie.driver", file.getAbsolutePath());

    driver = new InternetExplorerDriver();
    acceptance = new Acceptance(driver);
    headerMenu = new HeaderMenu(driver);
    page = new CreateUserRequestPage(driver);
    baseURL = "http://localhost:4200/";
    driver.get(baseURL);
    Thread.sleep(1000);
    acceptance.ButtonAcceptClick();
    driver.get(baseURL + "createUserRequest");
    // driver.get("http://localhost:4200/createUserRequest");
    // Thread.sleep(1000);

    System.out.println("CreateUserRequestTest: End setUpBeforeClass()");
  }

  @AfterClass
  public static void tearDownAfterClass() throws Exception {
    System.out.println("CreateUserRequestTest: Begin tearDownAfterClass()");

    Thread.sleep(1000);
    driver.quit();

    System.out.println("CreateUserRequestTest: End tearDownAfterClass()");
  }

  @Test
  /** Test Case Verify that user is able to open a Create User Request Page ****/
  public void test001_1() {
    System.out.println("CreateUserRequestTest: Begin test001_1()");

    Assert.assertEquals("Test Case FAILED", "User Administration - Create User Request", page.getPageTitle());

    System.out.println("CreateUserRequestTest: End test001_1()");
  }

  @Test
  /** Test Case #1 Verify a style of the page ****/
  public void styleTest() throws InterruptedException {
    System.out.println("CreateUserRequestTest: Begin styleTest()");

    Thread.sleep(3000);

    Assert.assertTrue("Test Case # 1 FAILED *****Test Case #1 Verify a style of the page****", page.getFormName().equals("User Details"));
    Assert.assertTrue("Test Case # 1 FAILED *****Test Case #1 Verify a style of the page****", page.isFooterDisplayed());
    Assert.assertTrue("Test Case # 1 FAILED *****Test Case #1 Verify a style of the page*****", page.areInputFieldsDisplayed());
    Assert.assertTrue("Test Case # 1 FAILED *****Test Case #1 Verify a style of the page*****", page.isSubmitButtonDisplayed());
    Assert.assertTrue("Test Case # 1 FAILED *****Test Case #1 Verify a style of the page*****", page.getUserDetailsFieldsNames().equals("Windows NT Name Required, First Name Required, Middle Name, Last Name Required"));

    System.out.println("CreateUserRequestTest: End styleTest()");
  }

  @Test
  /** Test Case #2 Verify that user is able to create a new user request ****/
  public void testForm() {
    System.out.println("CreateUserRequestTest: Begin testForm()");

    Random rand = new Random();
    String n = String.valueOf(rand.nextInt(Integer.MAX_VALUE));

    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") != null);
    Assert.assertTrue(page.labelWinNT.getAttribute("innerText").contains("Required"));
    page.inputWinNTName.sendKeys("TestUser1" + n);
    Assert.assertTrue(!page.labelWinNT.getAttribute("innerText").contains("Required"));
    page.inputWinNTName.sendKeys(";");
    Assert.assertTrue(page.labelWinNT.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(page.labelFirstName.getAttribute("innerText").contains("Required"));
    page.inputFirstName.sendKeys("TestUser");
    Assert.assertTrue(!page.labelFirstName.getAttribute("innerText").contains("Required"));
    page.inputFirstName.sendKeys(";");
    Assert.assertTrue(page.labelFirstName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelMiddleName.getAttribute("innerText").contains("Required"));
    page.inputMiddleName.sendKeys("TestUser");
    Assert.assertTrue(!page.labelMiddleName.getAttribute("innerText").contains("Required"));
    page.inputMiddleName.sendKeys(";");
    Assert.assertTrue(page.labelMiddleName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(page.labelLastName.getAttribute("innerText").contains("Required"));
    page.inputLastName.sendKeys("TestUser" + n);
    Assert.assertTrue(!page.labelLastName.getAttribute("innerText").contains("Required"));
    page.inputLastName.sendKeys(";");
    Assert.assertTrue(page.labelLastName.getAttribute("innerText").contains("Alphanumeric Only"));

    Assert.assertTrue(!page.labelPhone.getAttribute("innerText").contains("Required"));
    Assert.assertTrue(!page.labelPhone.getAttribute("innerText").contains("Numbers Only"));
    page.inputPhone.sendKeys("TestUser" + n);
    Assert.assertTrue(page.labelPhone.getAttribute("innerText").contains("Incorrect characters"));

    Assert.assertTrue(!page.labelEmail.getAttribute("innerText").contains("Required"));
    Assert.assertTrue(!page.labelEmail.getAttribute("innerText").contains("Please enter valid email"));
    page.inputEmail.sendKeys("TestUser" + n);
    Assert.assertTrue(page.labelEmail.getAttribute("innerText").contains("Please enter valid email"));

    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") != null);

    Assert.assertTrue(!page.assignedRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    Assert.assertTrue(page.availableRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    driver.findElement(By.id("assignAllRoles")).click();
    Assert.assertTrue(page.assignedRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    Assert.assertTrue(!page.availableRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    driver.findElement(By.id("removeAllRoles")).click();
    Assert.assertTrue(!page.assignedRoles.getAttribute("innerHTML").contains("FEE CLERK"));
    Assert.assertTrue(page.availableRoles.getAttribute("innerHTML").contains("FEE CLERK"));

    Assert.assertTrue(!page.assignedFacilities.getAttribute("innerHTML").contains("563"));
    Assert.assertTrue(page.availableFacilities.getAttribute("innerHTML").contains("563"));
    driver.findElement(By.id("assignAllFacilities")).click();
    Assert.assertTrue(page.assignedFacilities.getAttribute("innerHTML").contains("563"));
    Assert.assertTrue(!page.availableFacilities.getAttribute("innerHTML").contains("563"));
    driver.findElement(By.id("removeAllFacilities")).click();
    Assert.assertTrue(!page.assignedFacilities.getAttribute("innerHTML").contains("563"));
    Assert.assertTrue(page.availableFacilities.getAttribute("innerHTML").contains("563"));

    page.inputWinNTName.clear();
    page.inputWinNTName.sendKeys("TestUser1" + n);
    page.inputFirstName.clear();
    page.inputFirstName.sendKeys("TestFirst");
    page.inputMiddleName.clear();
    page.inputMiddleName.sendKeys("TestMiddle");
    page.inputLastName.clear();
    page.inputLastName.sendKeys("TestLast");
    page.inputPhone.clear();
    page.inputPhone.sendKeys("(123)-123-1234+123");
    page.inputEmail.clear();
    page.inputEmail.sendKeys("dre@dhawk.com");
    Assert.assertTrue(page.buttonSubmit.getAttribute("disabled") == null);

    page.buttonSubmit.click();

    // Test submission and successful response message
    try {
      Thread.sleep(2000);
    } catch (InterruptedException e) {
      e.printStackTrace();
    }
    System.out.print(driver.switchTo().alert().getText());
    Assert.assertTrue(driver.switchTo().alert().getText().contains("{\"result\":1}"));
    driver.switchTo().alert().accept();

    // submit same info, check for duplicate error
    page.buttonSubmit.click();
    try {
      Thread.sleep(2000);
    } catch (InterruptedException e) {
      e.printStackTrace();
    }
    Assert.assertTrue(!driver.switchTo().alert().getText().contains("{\"result\":1}"));
    Assert.assertTrue(driver.switchTo().alert().getText().contains("{\"error_code\":\"Duplicate AppUserRequest\",\"error_description\":\"Duplicate Window_Nt_Name\"}"));

    System.out.println("CreateUserRequestTest: End testForm()");
  }
}
