package testing;

import java.io.File;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.By;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.CreateUserRequestPage;
import Pages.HeaderMenu;

/**
 * 
 * @author Muneshwar Baiah
 * Claim Home Page Tests
 *
 */
public class ClaimHomePageTest {
	static InternetExplorerDriver driver;
	  static String baseURL;
	  static Acceptance acceptance;
	  static HeaderMenu headerMenu;
	  static CreateUserRequestPage page;
	  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(ClaimHomePageTest.class); 
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.\n" + result);
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
	  }

  @Before
  public void setUp() throws Exception {
	  System.out.println("ClaimHomePageTest: Begin setUp()");
	  
	  File file = new File("drivers/IEDriverServer.exe");
	  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
	  driver = new InternetExplorerDriver();
	  acceptance = new Acceptance(driver);
	  headerMenu = new HeaderMenu(driver);
	  page = new CreateUserRequestPage(driver);
	  baseURL = "http://localhost:4200/";
	  driver.get(baseURL);
	  driver.manage().window().maximize();
	  Thread.sleep(1040);
	  acceptance.ButtonAcceptClick();
	  
	  System.out.println("ClaimHomePageTest: End setUp()");
  }

  @Test
  public void testManualReconciliation() throws Exception {
	  System.out.println("ClaimHomePageTest: Begin ClaimHomePageTest()");
	  
	  // Getting into awaiting claims page
	  Thread.sleep(1040);
	  driver.get(baseURL+"claimsHomePage");
	  testPageTitle();
	  testLinks();
	  System.out.println("ClaimHomePageTest: End testClientDetails()");
    }

  // Test if the page title is available for the claims page
  public void testPageTitle() throws Exception {
	  Thread.sleep(5000);
	  if( driver.findElement(By.className("page-title")).getAttribute("innerHTML").contains("Claims")){
		  System.out.println("Page title Claims found "); 
	  } else {
		  System.out.println("Page title Claims not found ");   
	  }
  }
  
  // Test if all the links are available to navigate to various other pages
  public void testLinks() throws Exception {
	  Thread.sleep(1040);
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Search Claims"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Awaiting Processing"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("In Process"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Aged"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Payment Errors"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Reject Claims"));
	 Assert.assertTrue( driver.findElement(By.id("navigationLinks")).getAttribute("innerHTML").contains("Unmatched Payments"));
  }
  
  @After
  public void tearDown() throws Exception {
    driver.quit();
    System.out.println("Exited testing the claims home page!"); 
  }

}
