package testing;

import java.io.File;
import java.util.concurrent.TimeUnit;
import static org.junit.Assert.*;
import org.openqa.selenium.*;
import org.openqa.selenium.ie.InternetExplorerDriver;

import Pages.Acceptance;
import Pages.CreateUserRequestPage;
import Pages.HeaderMenu;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;


public class ClaimDetailStatus {
	static InternetExplorerDriver driver;
	  static String baseURL;
	  static Acceptance acceptance;
	  static HeaderMenu headerMenu;
	  static CreateUserRequestPage page;
	  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(ClaimDetailStatus.class); // Replace "SampleTest" with the name of your class
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.\n" + result);
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
	  }

  @Before
  public void setUp() throws Exception {
	  System.out.println("ClaimDetailStatus: Begin setUp()");
	  
	  File file = new File("drivers/IEDriverServer.exe");
	  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
	  driver = new InternetExplorerDriver();
	  acceptance = new Acceptance(driver);
	  headerMenu = new HeaderMenu(driver);
	  page = new CreateUserRequestPage(driver);
	  baseURL = "http://localhost:4200/";
	  driver.get(baseURL);
	  driver.manage().window().maximize();
	  Thread.sleep(1000);
	  acceptance.ButtonAcceptClick();
	  
	  System.out.println("ClaimDetailStatus: End setUp()");
  }

  @Test
  public void testClientDetails() throws Exception {
	  System.out.println("ClaimDetailStatus: Begin testClientDetails()");
	  
	  Thread.sleep(1000);
	  driver.get(baseURL+"awaitingProcessing");
	  Thread.sleep(1000);
//	  driver.findElement(By.linkText("118")).sendKeys(Keys.ENTER);
//	  Thread.sleep(5000);
//	  driver.findElement(By.xpath("//*[text()[contains(.,'Establish')]]"))

	  System.out.println("ClaimDetailStatus: End testClientDetails()");
    }

  public void establish() throws Exception {
	  driver.findElement(By.linkText("118")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tableHeaderClaimStatusContent")).getAttribute("innerHTML").contains("ESTABLISH")){
		  System.out.println("found Establish");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't file Establish");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }
  
//  public void inProcess() throws Exception {
//	  driver.findElement(By.linkText("101")).sendKeys(Keys.ENTER);
//	  if( driver.findElement(By.id("tableHeaderClaimStatusContent")).getAttribute("innerHTML").contains("INPROCESS")){
//		  System.out.println("found INPROCESS");
//		  
//	  }else{
//		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
//		  System.out.println("Didn't file INPROCESS");
//	  }
//  }
  
  public void complete() throws Exception {
	  driver.findElement(By.linkText("124")).sendKeys(Keys.ENTER);
	  if( driver.findElement(By.id("tableHeaderClaimStatusContent")).getAttribute("innerHTML").contains("COMPLETE")){
		  System.out.println("found COMPLETE");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't file COMPLETE");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }
  
  public void payError() throws Exception {
	  driver.findElement(By.linkText("127")).sendKeys(Keys.ENTER);
	  if( driver.findElement(By.id("tableHeaderClaimStatusContent")).getAttribute("innerHTML").contains("PAYERROR")){
		  System.out.println("found PAYERROR");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't file PAYERROR");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }

  public void aged()throws Exception {
	  driver.findElement(By.linkText("122")).sendKeys(Keys.ENTER);
	  if( driver.findElement(By.id("tableHeaderClaimStatusContent")).getAttribute("innerHTML").contains("AGED")){
		  System.out.println("found AGED");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't file AGED");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }




  @After
  public void tearDown() throws Exception {
	System.out.println("ClaimDetailStatus: Begin tearDown()");
	
    driver.quit();
    Object verificationErrors = null;
	String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
    
    System.out.println("ClaimDetailStatus: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }


}
