package testing;

import static org.junit.Assert.fail;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class AwaitingClaimsTest {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();

  public static void main(String args[]) {
    JUnitCore junit = new JUnitCore();
    junit.addListener(new TextListener(System.out));
    Result result = junit.run(AwaitingClaimsTest.class); // Replace "SampleTest" with the name of your class
    if (result.getFailureCount() > 0) {
      System.out.println("Test failed.");
      System.exit(1);
    } else {
      System.out.println("Test finished successfully.");
      System.exit(0);
    }
  }

  @Before
  public void setUp() throws Exception {
	System.out.println("AwaitingClaimsTest: Begin setUp()");
	  
    File file = new File("./drivers/IEDriverServer.exe");
    System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
    driver = new InternetExplorerDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    
    System.out.println("AwaitingClaimsTest: End setUp()");
  }

  @Test
  public void testAwaitingClaims() throws Exception {
	System.out.println("AwaitingClaimsTest: Begin testAwaitingClaims()");
	
    driver.get(baseUrl + "/awaitingProcessing");
    for (int second = 0;; second++) {
      if (second >= 60)
        fail("timeout");
      try {
        if (isElementPresent(By.id("checkBox0")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }
    Thread.sleep(3000);
    driver.findElement(By.id("checkBox0")).click();
    Assert.assertTrue((driver.findElement(By.className("page-title")).getAttribute("innerHTML")).contains("Awaiting Processing"));
    Assert.assertTrue(Boolean.parseBoolean(driver.findElement(By.id("checkBox0")).getAttribute("ng-reflect-model")));
    Assert.assertTrue((driver.findElement(By.id("numResultsTop")).getAttribute("innerText")).contains("Number of results:"));
    Assert.assertTrue((driver.findElement(By.id("numResultsBottom")).getAttribute("innerText")).contains("Number of results:"));
    Assert.assertTrue((driver.findElement(By.id("claimId")).getAttribute("innerText")).contains("Claim ID"));
    Assert.assertTrue((driver.findElement(By.id("claimStatus")).getAttribute("innerText")).contains("Claims Status"));
    Assert.assertTrue((driver.findElement(By.id("claimType")).getAttribute("innerText")).contains("Claims Type"));
    Assert.assertTrue((driver.findElement(By.id("hero")).getAttribute("innerText")).contains("HERO"));
    Assert.assertTrue((driver.findElement(By.id("veteranName")).getAttribute("innerText")).contains("Veteran Name"));
    Assert.assertTrue((driver.findElement(By.id("ssn")).getAttribute("innerText")).contains("SSN"));
    Assert.assertTrue((driver.findElement(By.id("claimDate")).getAttribute("innerText")).contains("Claim Date"));
    Assert.assertTrue((driver.findElement(By.id("claimAmount")).getAttribute("innerText")).contains("Claims Amount"));
    Assert.assertTrue((driver.findElement(By.id("providerName")).getAttribute("innerText")).contains("Provider Name"));
    Assert.assertTrue((driver.findElement(By.id("lines")).getAttribute("innerText")).contains("Lines"));
    Assert.assertTrue((driver.findElement(By.id("facility")).getAttribute("innerText")).contains("Facility"));
    Assert.assertTrue(isElementPresent(By.id("paginateFirst")));
    Assert.assertTrue(driver.findElement(By.id("0")).getAttribute("href").contains("/institutionalClaim/"));
    System.out.println(driver.getWindowHandles());
    driver.findElement(By.id("upperPrintWithoutProcessing")).click();
    Thread.sleep(3000);
    String mwh = driver.getWindowHandle();
    Set s = driver.getWindowHandles(); // this method will gives you the handles of all opened windows
    Iterator ite = s.iterator();
    while (ite.hasNext()) {
      String popupHandle = ite.next().toString();
      System.out.println(popupHandle);
      if (!popupHandle.contains(mwh)) {
        driver.switchTo().window(popupHandle);
        driver.switchTo().window(mwh);
      }
    }
    System.out.println(driver.getWindowHandles());
    String id = (driver.findElement(By.xpath("//td[@id='claimId0']/div[1]")).getAttribute("innerText"));
    System.out.println(id);
    driver.findElement(By.id("upperProcessAndPrint")).click();
    Thread.sleep(10000);
    Assert.assertTrue(driver.findElement(By.xpath("//td[@id='claimId0']/div[1]")).getAttribute("innerText") != id);
    driver.get(baseUrl + "inProcessClaims");
    Thread.sleep(5000);
    for (int i = 0; i < 100; i++) {
      System.out.println(driver.findElement(By.xpath("//td[@id='claimId" + i + "']/div[1]")).getAttribute("innerText"));
      if ((driver.findElement(By.xpath("//td[@id='claimId" + i + "']/div[1]")).getAttribute("innerText")).contains(id)) {
        Assert.assertTrue((driver.findElement(By.xpath("//td[@id='claimStatus" + i + "']/div[1]")).getAttribute("innerText")).contains("INPROCESS"));
        break;
      }
      if (i == 100)
        Assert.fail();
    }

    /*
     * Output with IE11: [5994f136-4367-403f-b2f4-582a3bebd382] 5994f136-4367-403f-b2f4-582a3bebd382 [5994f136-4367-403f-b2f4-582a3bebd382] Output with Firefox: [13] 13 19 [13, 19]
     */
    System.out.println("AwaitingClaimsTest: End testAwaitingClaims()");
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("AwaitingClaimsTest: Begin tearDown()");
	
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      System.out.println(verificationErrorString);
      fail(verificationErrorString);
    }
    
    System.out.println("AwaitingClaimsTest: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    String parentWindowHandle = driver.getWindowHandle();
    ArrayList<String> browserTabs = new ArrayList<String>(driver.getWindowHandles());
    try {
      driver.switchTo().alert();
      driver.switchTo().window(browserTabs.get(1));

      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private boolean isOpenWindowCount() {
    String parentWindowHandle = driver.getWindowHandle();
    Set<String> allWindowHandles = driver.getWindowHandles();
    System.out.println("Parent window's handle -> " + parentWindowHandle);
    for (String handle : allWindowHandles) {
      System.out.println("Window handle - > " + handle);
    }

    return true;
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
