package testing;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.Select;

public class AgedClaimsTest {
  private WebDriver driver;
  private String baseUrl;
  private boolean acceptNextAlert = true;
  private StringBuffer verificationErrors = new StringBuffer();
  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(AgedClaimsTest.class); // Replace "SampleTest" with the name of your class
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.");
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
  }

  @Before
  public void setUp() throws Exception {
	System.out.println("AgedClaimsTest: Begin setUp()");
	
	File file = new File("drivers/IEDriverServer.exe");
	System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
    driver = new InternetExplorerDriver();
    baseUrl = "http://localhost:4200/";
    driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    
    System.out.println("AgedClaimsTest: End setUp()");
  }

  @Test
  public void testAgedClaims() throws Exception {
	System.out.println("AgedClaimsTest: Begin testAgedClaims()");
	
    driver.get(baseUrl + "/agedClaims");
    for (int second = 0;; second++) {
      if (second >= 60)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("(//select[@name='example_length'])[2]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.id("tableHeaderClaimId")).click();
    assertEquals("1394769", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimId")).click();
    assertEquals("8567772", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimStatus")).click();
    assertEquals("AGED", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimStatus")).click();
    assertEquals("AGED", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimType")).click();
    assertEquals("DENT", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimType")).click();
    assertEquals("PROF", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderHero")).click();
    assertEquals("N", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderHero")).click();
    assertEquals("Y", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderVeteranName")).click();
    assertEquals("Angie Johnston", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderVeteranName")).click();
    assertEquals("Willie Byrd", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimDate")).click();
    assertEquals("01/04/2017", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderClaimDate")).click();
    assertEquals("06/20/2017", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderdaysInProcess")).click();
    assertEquals("01/28/2017", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderdaysInProcess")).click();
    assertEquals("06/18/2017", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderProviderName")).click();
    assertEquals("AJS Hospital", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderProviderName")).click();
    assertEquals("Mercy Hospital", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderLines")).click();
    assertEquals("168", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderLines")).click();
    assertEquals("988", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderLinesClosed")).click();
    assertEquals("1211", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderLinesClosed")).click();
    assertEquals("9964", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderFacility")).click();
    assertEquals("120", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderFacility")).click();
    assertEquals("785", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderAssignedTo")).click();
    assertEquals("David", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.id("tableHeaderAssignedTo")).click();
    assertEquals("Robin", driver.findElement(By.cssSelector("td.sorting_1")).getText());
    driver.findElement(By.linkText("2")).click();
    assertEquals("3700608", driver.findElement(By.xpath("//table[@id='example']/tbody/tr/td[2]")).getText());
    new Select(driver.findElement(By.name("example_length"))).selectByVisibleText("25");
    assertEquals("3700608", driver.findElement(By.xpath("//table[@id='example']/tbody/tr[11]/td[2]")).getText());
    driver.findElement(By.id("6481144")).click();

    // IE uses different values for storing checkbox booleans
    String checked = "value";
    String on = "on";
    String off = "off";
    if (driver instanceof InternetExplorerDriver) {
      checked = "checked";
      on = "true";
      off = null;
    }
    try {
      assertEquals(on, driver.findElement(By.id("6481144")).getAttribute(checked));
    } catch (Error e) {
      verificationErrors.append(e.toString());
    }
    try {
      assertEquals(off, driver.findElement(By.id("1521751")).getAttribute(checked));
    } catch (Error e) {
      verificationErrors.append(e.toString());
    }
    driver.findElement(By.id("tableHeaderCheckBox")).click();
    try {
      assertEquals(on, driver.findElement(By.id("1521751")).getAttribute(checked));
    } catch (Error e) {
      verificationErrors.append(e.toString());
    }
    driver.findElement(By.id("upperPrintButton")).click();
    assertEquals("Below are the selected claims that would have been printed:", driver.findElement(By.cssSelector("div.modal-body > h4")).getText());
    assertEquals(
        "{ \"id\": \"594aca3c97616b1971ba2286\", \"user\": 3, \"claimId\": 2458050, \"claimStatus\": \"AGED\", \"claimType\": \"DENT\", \"hero\": \"N\", \"veteranName\": \"Shaw Vang\", \"ssn\": 671387096, \"claimDate\": \"01/21/2017\", \"claimAmount\": \"$381353.2332\", \"providerName\": \"General Hospital\", \"lines\": 732, \"facility\": 782, \"assignedTo\": \"David\", \"daysInProcess\": \"06/18/2017\", \"linesClosed\": 9154, \"reconcile\": \"Y\", \"patientId\": 3529478, \"disapprovedBy\": \"Joseph\", \"disapprovedDate\": \"04/24/2017\", \"reason\": 3743, \"explanation\": \"Rejected Claim\", \"comments\": \"updated recently\", \"history\": \"completed\", \"patientControlNumber\": 68048972, \"serviceDate\": \"05/31/2017\", \"prTin\": 49590545, \"prNpi\": 16633950, \"selected\": true }",
        driver.findElement(By.cssSelector("h6")).getText());
    assertEquals("Print", driver.findElement(By.id("myModalLabel")).getText());
    driver.findElement(By.cssSelector("button.close")).click();
    driver.findElement(By.id("upperRerouteButton")).click();
    assertEquals("Reroute", driver.findElement(By.cssSelector("h1")).getText());
    assertEquals(
        "{ \"id\": \"594aca3c97616b1971ba2286\", \"user\": 3, \"claimId\": 2458050, \"claimStatus\": \"AGED\", \"claimType\": \"DENT\", \"hero\": \"N\", \"veteranName\": \"Shaw Vang\", \"ssn\": 671387096, \"claimDate\": \"01/21/2017\", \"claimAmount\": \"$381353.2332\", \"providerName\": \"General Hospital\", \"lines\": 732, \"facility\": 782, \"assignedTo\": \"David\", \"daysInProcess\": \"06/18/2017\", \"linesClosed\": 9154, \"reconcile\": \"Y\", \"patientId\": 3529478, \"disapprovedBy\": \"Joseph\", \"disapprovedDate\": \"04/24/2017\", \"reason\": 3743, \"explanation\": \"Rejected Claim\", \"comments\": \"updated recently\", \"history\": \"completed\", \"patientControlNumber\": 68048972, \"serviceDate\": \"05/31/2017\", \"prTin\": 49590545, \"prNpi\": 16633950, \"selected\": true }",
        driver.findElement(By.cssSelector("h6")).getText());
    driver.navigate().back();
    for (int second = 0;; second++) {
      if (second >= 60)
        fail("timeout");
      try {
        if (isElementPresent(By.xpath("(//select[@name='example_length'])[2]")))
          break;
      } catch (Exception e) {
      }
      Thread.sleep(1000);
    }

    driver.findElement(By.id("tableHeaderCheckBox")).click();
    driver.findElement(By.id("upperDisapproveButton")).click();
    assertEquals("Disapprove", driver.findElement(By.cssSelector("h1")).getText());
    assertEquals(
        "{ \"id\": \"594aca3c97616b1971ba2286\", \"user\": 3, \"claimId\": 2458050, \"claimStatus\": \"AGED\", \"claimType\": \"DENT\", \"hero\": \"N\", \"veteranName\": \"Shaw Vang\", \"ssn\": 671387096, \"claimDate\": \"01/21/2017\", \"claimAmount\": \"$381353.2332\", \"providerName\": \"General Hospital\", \"lines\": 732, \"facility\": 782, \"assignedTo\": \"David\", \"daysInProcess\": \"06/18/2017\", \"linesClosed\": 9154, \"reconcile\": \"Y\", \"patientId\": 3529478, \"disapprovedBy\": \"Joseph\", \"disapprovedDate\": \"04/24/2017\", \"reason\": 3743, \"explanation\": \"Rejected Claim\", \"comments\": \"updated recently\", \"history\": \"completed\", \"patientControlNumber\": 68048972, \"serviceDate\": \"05/31/2017\", \"prTin\": 49590545, \"prNpi\": 16633950, \"selected\": true }",
        driver.findElement(By.cssSelector("h6")).getText());
    
    System.out.println("AgedClaimsTest: End testAgedClaims()");
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("AgedClaimsTest: Begin tearDown()");  
	
    driver.quit();
    String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      System.out.println(verificationErrorString);
      fail(verificationErrorString);
    }
    
    System.out.println("AgedClaimsTest: End tearDown()"); 
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
