package Pages;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

public class ModifyUserRequestPage {
  WebDriver driver;

  public ModifyUserRequestPage(WebDriver driver) {
    this.driver = driver;
    PageFactory f = new PageFactory();
    f.initElements(driver, this);
  }

  @FindBy(xpath = "//div[@class='page-title']/div/h1")
  public WebElement title;

  @FindBy(xpath = "//div[@class='section-header']/h2")
  public WebElement formName;

  @FindBy(xpath = "//label[@for ='window_nt_name']")
  public WebElement labelWinNT;

  @FindBy(xpath = "//label[@for ='first_name']")
  public WebElement labelFirstName;

  @FindBy(xpath = "//label[@for ='first_name']/span")
  public WebElement labelFirstNameRequired;

  @FindBy(xpath = "//label[@for ='first_name']/span")
  public WebElement labelFirstNameLettersOnly;

  @FindBy(xpath = "//label[@for ='middle_name']")
  public WebElement labelMiddleName;

  @FindBy(xpath = "//label[@for ='middle_name']/span")
  public WebElement labelMiddleNameLettersOnly;

  @FindBy(xpath = "//label[@for ='last_name']")
  public WebElement labelLastName;

  @FindBy(xpath = "//label[@for ='last_name']/span")
  public WebElement labelLastNameRequired;

  @FindBy(xpath = "//label[@for ='last_name']/span")
  public WebElement labelLastNameLettersOnly;

  @FindBy(xpath = "//label[@for ='phone']")
  public WebElement labelPhone;

  @FindBy(xpath = "//label[@for ='email']")
  public WebElement labelEmail;

  @FindBy(xpath = "//label[@for ='enabled']")
  public WebElement labelEnabled;

  @FindBy(xpath = "//label[@for ='comments']")
  public WebElement labelComment;

  @FindBy(name = "window_nt_name")
  public WebElement inputWinNTName;

  @FindBy(name = "first_name")
  public WebElement inputFirstName;

  @FindBy(name = "middle_name")
  public WebElement inputMiddleName;

  @FindBy(name = "last_name")
  public WebElement inputLastName;

  @FindBy(name = "phone")
  public WebElement inputPhone;

  @FindBy(name = "email")
  public WebElement inputEmail;

  @FindBy(id = "comments")
  public WebElement inputComment;

  @FindBy(name = "enabled")
  public WebElement inputEnabled;

  @FindBy(id = "leftSelectRoles")
  public WebElement availableRoles;

  @FindBy(id = "rightSelectRoles")
  public WebElement assignedRoles;

  @FindBy(id = "leftSelectFacilities")
  public WebElement availableFacilities;

  @FindBy(id = "rightSelectFacilities")
  public WebElement assignedFacilities;

  @FindBy(css = ".button.primary ")
  public WebElement buttonSubmit;

  @FindBy(className = "footer")
  public WebElement footer;

  /* Get a title of the page ********************************/
  public String getPageTitle() {
    return title.getText();
  }

  /* Get a Form Name ********************************/
  public String getFormName() {
    return formName.getText();
  }

  /* Is footer displayed? *************************************/
  public boolean isFooterDisplayed() {
    if (footer.isDisplayed())
      return true;
    else
      return false;
  }

  /* Get input fields labels ***********************************/
  public String getUserDetailsFieldsNames() {
    String names = labelWinNT.getText() + ", " + labelFirstName.getText() + ", " + labelMiddleName.getText() + ", " + labelLastName.getText();
    return names;
  }

  /* Are input fields displayed? *******************************/
  public boolean areInputFieldsDisplayed() {
    if (inputWinNTName.isDisplayed() && inputFirstName.isDisplayed() && inputMiddleName.isDisplayed() && inputLastName.isDisplayed())
      return true;
    else
      return false;
  }

  /* Is Submit button displayed? *****************************/
  public boolean isSubmitButtonDisplayed() {
    if (buttonSubmit.isDisplayed())
      return true;
    else
      return false;
  }
}