package Pages;

import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

public class Home {
		WebDriver driver;
		public Home(WebDriver driver) {
			this.driver = driver;
			PageFactory.initElements(driver, this);
		}
		
/***Home page Title***********************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div[1]/div/div/div/h1/span")
		WebElement homeTitle;
		
/***User Name in navbar menu****************************************************************/
		@FindBy(xpath = "//*[@id='username']/span")
		WebElement userNameInNavBar;
		
/***User Name in Welcome Title ***************************************************************/
		@FindBy(xpath = "//div[@class='pageID']/h2")
		WebElement userNameInWelcomeTitle;
		
/***User Name*****************************************************************/
		@FindBy(xpath = "//*[@id='uppertable']/tbody/tr/td[1]/span")
		WebElement userName;
		
		
/***Active Stations************************************************************/
		@FindBy(xpath = ".//*[@id='lowertable']/tbody/tr/td[1]/span")
		WebElement userActiveStations;
		
/***Last Login*****************************************************************/
		@FindBy(xpath = ".//*[@id='uppertable']/tbody/tr/td[2]/span")
		WebElement userLastLogin;	
		
/***Roles*****************************************************************/
		@FindBy(xpath = "//*[@id='lowertable']/tbody/tr/td[2]/span")
		WebElement userRoles;
		
/***Assign Stations*****************************************************/
		@FindBy(xpath = "//*[@class='assign']/h3")
		WebElement tblName;
		
/**Table Column Headers*****************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/thead/th[position()>1]")
		List<WebElement> tblHeaders;
		
/**Table First Checkbox*****************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[1]/td[1]/label/input")
		WebElement cbxFirst;
		
/**Table Second Checkbox*****************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[2]/td[1]/label/input")
		WebElement cbxSecond;
		
/**Table Third Checkbox*****************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[3]/td[1]/label/input")
		WebElement cbxThird;
		
		
		
/**Table Select All Checkbox*****************************************************/
		@FindBy(xpath = ".//*[@id='selectAllCheckBox']")
		WebElement cbxSelectAll;

/** StationNamberAtRow#1********************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[1]/td[2]")
		WebElement statNumb1;
	
/** StationNamberAtRow#2********************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[2]/td[2]")
		WebElement statNumb2;
		
/** StationNamberAtRow#3********************************************************/
		@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr[3]/td[2]")
		WebElement statNumb3;
		
/**VISN*********************************************************************************/
		@FindBy(xpath = "//*[@id='secondaryHeaders']/tr/td[1]")
		WebElement visn;
		
/** Set Active Button********************************************************/
		@FindBy(xpath="html/body/app-root/app-home/div/div[2]/div[2]/button[1]")
		WebElement btnSetActive;
	
/***Refresh Button*******************************************************************/		
	@FindBy(xpath = "html/body/app-root/app-home/div/div[2]/div[2]/button[2]")	
     WebElement btnRefresh;
	
		
public boolean isTitleExist() {
	try {
		
	if(homeTitle.isDisplayed())
	     return true; 
	    	 else
	    		 return false;
	    }
	catch (Exception NoSuchElementException) {
		return false;
	}
  }
 
	public String getUsrNameInNavBar() {
		return userNameInNavBar.getText();
	}
	
	public String getUsrNameInWelcome() {
		return userNameInWelcomeTitle.getText();
	}
	
	public String getUsrNameInCard() {
		return userName.getText();
	}
 
 public String getActiveStations() {
	 return userActiveStations.getText();
    }
 
 public String getLastLogin() {
	 return userLastLogin.getText();
    }
 
 public String getUserRoles() {
	 return userRoles.getText();
    }
 
 public String getTableName() {
	 return tblName.getText();
 }
 
 public List<String> getTableColHeaders() {
	 List<String> list = new ArrayList<String>();
	 for(WebElement item: tblHeaders) {
		 list.add(item.getText());
 	 }
	return list;
 }
 
 
 public int getVisnColumnSum(int colNum) {
	    //Integer.valueOf
	    		// get value of VISN fields 
	    		//driver.findElements(By.xpath("//*[@id='secondaryHeaders']/tr/td[" + (columnNumber + 1)+ "]"))).getText();
	    
	    int sum = Integer.valueOf(driver.findElement(By.xpath("//*[@id='secondaryHeaders']/tr/td[" + (colNum+1) + "]")).getText());
	    		
	    
       
/**     List<WebElement> numrows = new ArrayList<WebElement>(); // Define a number of rows												
		List<Integer> list = new ArrayList<Integer>();
		numrows = driver.findElements(By.xpath
				(".//table[@class='mdl-data-table mdl-js-data-table']//tbody[2]//tr"));

		for (int i = 1; i <= numrows.size(); i++) { // Put a value of column in  array					
			WebElement element = driver.findElement(
					By.xpath("//table[@class='mdl-data-table mdl-js-data-table']//tbody[2]//tr[" + i + "]/td[" + columnNumber + "]"));
			list.add(Integer.valueOf(element.getText()));
		}

		for (int i : list) { 
			sum = sum + i;

		} 
***/
		return sum;
	}
 
      public int getColumnSum(int colNumber) { 
    	  int sum = 0;
    	List<WebElement> values = new ArrayList<WebElement>(); // put column's value into array
    	values = driver.findElements(By.xpath
  				("html/body/app-root/app-home/div/div[2]/table/tbody[2]/tr/td[" + (colNumber + 2)+ "]"));
    	for(WebElement item : values){
    		 sum = sum + Integer.valueOf(item.getText());
    	  }
    	 
    	  return sum + getVisnColumnSum(colNumber);
      }
 
 
 
       public void clearCheckboxes() throws InterruptedException{
    	   if(cbxFirst.isSelected()) {
       		cbxFirst.click();
    	     Thread.sleep(500); }
    	   if(cbxSecond.isSelected()){ 
            cbxSecond.click();
    	     Thread.sleep(500); }
    	   if(cbxThird.isSelected()) {
    		 cbxThird.click();
    	     Thread.sleep(500); }
       }
    	   
       public void selectCheckbox1 () throws InterruptedException {     //Select checkbox at row 1
    	if(!cbxFirst.isSelected()) {
    		cbxFirst.click();
    	    Thread.sleep(500); }
       }
    	
    	public void selectCheckbox2 () throws InterruptedException {     //Select checkbox at row 1
        	if(!cbxSecond.isSelected()){ 
        		cbxSecond.click();
        	    Thread.sleep(500); }
       }
       
       public void selectCheckbox3 () throws InterruptedException{     //Select checkbox at row 3
       	if(!cbxThird.isSelected()) {
       		cbxThird.click();
          	Thread.sleep(500); }
          }
       
       public void selectAllCheckboxes () throws InterruptedException{     //Select All checkboxes
          	if(!cbxSelectAll.isSelected()) {
          		cbxSelectAll.click();
             	Thread.sleep(500); }
          		
             }
       
       public void btnClcSetActive() { //Click Set Active Button
    	  btnSetActive.click();	   
       }
       
       public String getStation1(){
    	   return statNumb1.getText();
       }
    
       public String getStation2(){
    	   return statNumb2.getText();
       }
       
       public String getStation3(){
    	   return statNumb3.getText();
       }
       
       public String getListOfActiveStations(){
		return userActiveStations.getText();
    	   
       }
       
       public String getVISN() {
    	   return visn.getText();
       }
       public void btnClcRefresh() {
    	   btnRefresh.click();
       }
       
}
