package Pages;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

public class CreateUserRequestPage {
  WebDriver driver;

  public CreateUserRequestPage(WebDriver driver) {
    this.driver = driver;
    PageFactory f = new PageFactory();
    f.initElements(driver, this);
  }

  /** Page Title ******************************/
  @FindBy(xpath = "//div[@class='page-title']/div/h1")
  public WebElement title;

  /** Form name ******************************/
  @FindBy(xpath = "//div[@class='section-header']/h2")
  public WebElement formName;

  /** WindowsNT label ***********************/
  @FindBy(xpath = "//label[@for ='window_nt_name']")
  public WebElement labelWinNT;

  /** First Name label ***********************/
  @FindBy(xpath = "//label[@for ='first_name']")
  public WebElement labelFirstName;

  /** Required label First Name field ***********************/
  @FindBy(xpath = "//label[@for ='first_name']/span")
  public WebElement labelFirstNameRequired;

  /** Letters Only label First Name field ***********************/
  @FindBy(xpath = "//label[@for ='first_name']/span")
  public WebElement labelFirstNameLettersOnly;

  /** Middle Name label ***********************/
  @FindBy(xpath = "//label[@for ='middle_name']")
  public WebElement labelMiddleName;

  /** Letters Only label Middle Name field ***********************/
  @FindBy(xpath = "//label[@for ='middle_name']/span")
  public WebElement labelMiddleNameLettersOnly;

  /** Last Name label ***********************/
  @FindBy(xpath = "//label[@for ='last_name']")
  public WebElement labelLastName;

  /** Required label Last Name field ***********************/
  @FindBy(xpath = "//label[@for ='last_name']/span")
  public WebElement labelLastNameRequired;

  /** Letters Only label Last Name field ***********************/
  @FindBy(xpath = "//label[@for ='last_name']/span")
  public WebElement labelLastNameLettersOnly;

  /** Numbers Only label Phone field ***********************/
  @FindBy(xpath = "//label[@for ='phone']")
  public WebElement labelPhone;

  /** label Email field ***********************/
  @FindBy(xpath = "//label[@for ='email']")
  public WebElement labelEmail;

  /** label Enabled field ***********************/
  @FindBy(xpath = "//label[@for ='enabled']")
  public WebElement labelEnabled;

  /** WindowsNTInput ********************************************/
  @FindBy(name = "window_nt_name")
  public WebElement inputWinNTName;

  /** First Name Input ********************************************/
  @FindBy(name = "first_name")
  public WebElement inputFirstName;

  // Middle Name Input 
  @FindBy(name = "middle_name")
  public WebElement inputMiddleName;

  /** Last Name Input ********************************************/
  @FindBy(name = "last_name")
  public WebElement inputLastName;

  /** Last Name Input ********************************************/
  @FindBy(name = "phone")
  public WebElement inputPhone;

  /** Last Name Input ********************************************/
  @FindBy(name = "email")
  public WebElement inputEmail;

  /** Last Name Input ********************************************/
  @FindBy(name = "enabled")
  public WebElement inputEnabled;

  /** Available Roles Input ********************************************/
  @FindBy(id = "leftSelectRoles")
  public WebElement availableRoles;

  /** Assigned Roles Input ********************************************/
  @FindBy(id = "rightSelectRoles")
  public WebElement assignedRoles;

  /** Available Facilities Input ********************************************/
  @FindBy(id = "leftSelectFacilities")
  public WebElement availableFacilities;

  /** Assigned Facilities Input ********************************************/
  @FindBy(id = "rightSelectFacilities")
  public WebElement assignedFacilities;

  /** Submit Request ACTIVE button ***********************/
  @FindBy(css = ".button.primary ")
  public WebElement buttonSubmit;

  /** Footer *****************************************************/
  @FindBy(className = "footer")
  public WebElement footer;

  /* Get a title of the page ********************************/
  public String getPageTitle() {
    return title.getText();
  }

  /* Get a Form Name ********************************/
  public String getFormName() {
    return formName.getText();
  }

  /* Is footer displayed? *************************************/
  public boolean isFooterDisplayed() {
    if (footer.isDisplayed())
      return true;
    else
      return false;
  }

  /* Get input fields labels ***********************************/
  public String getUserDetailsFieldsNames() {
    String names = labelWinNT.getText() + ", " + labelFirstName.getText() + ", " + labelMiddleName.getText() + ", " + labelLastName.getText();
    return names;
  }

  /* Are input fields displayed? *******************************/
  public boolean areInputFieldsDisplayed() {
    if (inputWinNTName.isDisplayed() && inputFirstName.isDisplayed() && inputMiddleName.isDisplayed() && inputLastName.isDisplayed())
      return true;
    else
      return false;
  }

  /* Is Submit button displayed? *****************************/
  public boolean isSubmitButtonDisplayed() {
    if (buttonSubmit.isDisplayed())
      return true;
    else
      return false;
  }
}