package Pages;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Awaiting {
	WebDriver driver;
	public Awaiting(WebDriver driver) {
		this.driver = driver;
		PageFactory.initElements(driver, this);
	}
	
	@FindBy(id = "upperPrintWithoutProcessing")
	WebElement btnPrintWithoutProcessing;
	
	@FindBy(xpath="//table[@id='datatable']/tbody/tr[1]/td[1]/div")
	WebElement chbox1;
	
	@FindBy(xpath="//table[@id='datatable']/tbody/tr[1]/td[2]/div/a")
	WebElement clmID;




	
	public void btnPrintWithootProcessingClick(){
		 WebDriverWait button = new WebDriverWait(driver,60);      
 		 button.until(ExpectedConditions.elementToBeClickable(btnPrintWithoutProcessing)).click();
		
	}
	
	public void chboxClick() {
		 WebDriverWait button = new WebDriverWait(driver,60);      
 		 button.until(ExpectedConditions.elementToBeClickable(chbox1)).click();
		}
	
	public void findAndClickClaimIDWithSpecificClaimType(String claimType){
	   WebElement claimTypeDisplayed = null;
       while(!claimTypeDisplayed.equals(claimType)) {
    	   claimTypeDisplayed = driver.findElement(By.xpath("//table[@id='datatable']/tbody/tr[1]/td[2]/div/a"));
       }
	
	}
}