package Pages;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Acceptance {
	WebDriver driver;

	public Acceptance(WebDriver driver) {
		this.driver = driver;
		PageFactory.initElements(driver, this);
	}

	@FindBy(id = "VAlogo")
	WebElement lblDepartOfVA;

	@FindBy(xpath = "//h2[contains(text(), 'Fee Payment')]")
	WebElement lblFPPS;

	@FindBy(xpath = "//button[@type='submit']")
	WebElement btnAccept;

	@FindBy(xpath = "//button[@class='button secondary']")
	WebElement btnDecline;

	public void ButtonAcceptClick() {
		WebDriverWait button = new WebDriverWait(driver, 60);
		button.until(ExpectedConditions.elementToBeClickable(btnAccept)).click();
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// btnAccept.click();
	}

	public void ButtonDeclineClick() {
		btnDecline.click();
	}

	public boolean isVATitlesExist() {
		if (lblDepartOfVA.isDisplayed() && lblFPPS.isDisplayed())
			return true;
		else
			return false;
	}

	public void AuthentivationValid() {
		try {

			Class.forName("oracle.jdbc.driver.OracleDriver");
		} catch (ClassNotFoundException e) {
			System.out.println("Setup the Oracle JDBC Driver?");
			e.printStackTrace();
			return;
		}
		System.out.println("Oracle JDBC Driver Registered!");
		Connection connection = null;
		PreparedStatement preparedStmt = null;
		try {
			connection = DriverManager.getConnection("jdbc:oracle:thin:@IP                 /CAET1.aac.DNS   ",
					"FPPS_OWNER", "REDACTED");
			if (connection != null) {
				System.out.println("Connected to database and executing the query");
				// Query to update the sso_authentication table
				String query = "update sso_authentication set guid = ? where guid=?";
				preparedStmt = connection.prepareStatement(query);
				preparedStmt.setString(1, "23456");
				preparedStmt.setString(2, "PORT");
				// execute the preparedstatement
				preparedStmt.executeUpdate();
				System.out.println("SSO_AUTHENTICATION table has been updated successfully!!!");
				preparedStmt.close();
				connection.close();
			} else {
				System.out.println("Failed to make connection!");
			}
		} catch (SQLException e) {

			System.out.println("Connection Failed! Check output console");
			e.printStackTrace();
			return;
		}
	}

	public void AuthentivationInValid() {
		try {

			Class.forName("oracle.jdbc.driver.OracleDriver");
		} catch (ClassNotFoundException e) {
			System.out.println("Setup the Oracle JDBC Driver?");
			e.printStackTrace();
			return;
		}
		System.out.println("Oracle JDBC Driver Registered!");
		Connection connection = null;
		PreparedStatement preparedStmt = null;
		try {
			connection = DriverManager.getConnection("jdbc:oracle:thin:@IP                 /CAET1.aac.DNS   ",
					"FPPS_OWNER", "REDACTED");
			if (connection != null) {
				System.out.println("Connected to database and executing the query");
				// Query to update the sso_authentication table
				String query = "update sso_authentication set guid =?  where guid=?";
				preparedStmt = connection.prepareStatement(query);
				preparedStmt.setString(1, "9999");// invalid guid
				preparedStmt.setString(2, "23456");
				// execute the preparedstatement
				preparedStmt.executeUpdate();
				System.out.println("SSO_AUTHENTICATION table has been updated successfully!!!");
				preparedStmt.close();
				connection.close();
			} else {
				System.out.println("Failed to make connection!");
			}
		} catch (SQLException e) {

			System.out.println("Connection Failed! Check output console");
			e.printStackTrace();
			return;
		}
	}

}
