package essentialComponents;


import java.util.ArrayList;
import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.PageFactory;

public class HeaderMenu {
  static WebDriver driver;

  public HeaderMenu(WebDriver driver) {
    this.driver = driver;
    PageFactory.initElements(driver, this);
  }

  /* Home Button */
  @FindBy(linkText = "Home")
  WebElement btnHome;

  /* Claims Button */
  @FindBy(xpath = "html/body/app-root/app-home/app-menu-low/app-menu-high/div/ul/li[3]/a")
  WebElement btnClaims;

  /** Claims/Search Claims ***/
  @FindBy(xpath = "//*[@class='dropdown-item'][@alt='Claim Lookup']")
  WebElement mnuSearchClaim;

  /* Reports Button */
  @FindBy(xpath = "html/body/app-root/app-home/app-menu-low/app-menu-high/div/ul/li[4]/a")
  WebElement btnReports;

  /* Help Button */
  @FindBy(linkText = "Help")
  WebElement btnHelp;

  /* User Name */
  @FindBy(partialLinkText = "User")
  WebElement infUser;

  /* Logout Button */
  @FindBy(linkText = "Logout")
  WebElement btnLogout;

  /* List of dropdown Claims */
  @FindBy(xpath = "html/body/app-root/app-home/app-menu-low/app-menu-high/div/ul/li[3]/div/a")
  List<WebElement> drpClaims;

  /* List of dropdown Reports menu */
  @FindBy(xpath = "html/body/app-root/app-home/app-menu-low/app-menu-high/div/ul/li[4]/div/a")
  List<WebElement> drpReports;

  /* List of dropdown Tools menu */
  @FindBy(xpath = "html/body/app-root/app-home/app-menu-low/app-menu-high/div/ul/li[5]/div/*[@alt]")
  List<WebElement> drpTools;

  /* Is Header Menu present on the screen? */
  public boolean isMenuBarPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.xpath("//*[@class='nav justify-content-left']/li"));
    if (list.size() != 8)
      return false;
    else
      return true;
  }

  /* Verify that Home button is presented on the screen */
  public boolean isHomeBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.linkText("Home"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that Claims button is presented on the screen */
  public boolean isClaimsBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.linkText("Claims"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that Reports button is presented on the screen */
  public boolean isReportsBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.linkText("Reports"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that Tools button is presented on the screen */
  public boolean isToolsBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.linkText("Tools"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that Help button is presented on the screen */
  public boolean isHelpBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.linkText("Help"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that User Info is presented on the screen */
  public boolean isUserInfoPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.id("username"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Verify that Logout button is presented on the screen */
  public boolean isLogoutBtnPresentOnScreen() {
    List<WebElement> list = new ArrayList<WebElement>();
    list = driver.findElements(By.id("logout"));
    if (list.size() == 0)
      return false;
    else
      return true;
  }

  /* Click Claim menu ******************************/
  public void clcClaim() {
    btnClaims.click();
  }

  /* Click Claim/Search Claim *********************/
  public void clcSearchClaim() {
    mnuSearchClaim.click();
  }

  public List<String> ListMenuClaims() {
    List<String> list = new ArrayList<String>();
    for (WebElement item : drpClaims) {
      list.add(item.getText());
    }
    return list;
  }

  /* Click Reports menu ******************************/
  public void clcReports() {
    btnReports.click();
  }

  public List<String> ListMenuReports() {
    List<String> list = new ArrayList<String>();
    for (WebElement item : drpReports) {
      list.add(item.getText());
    }
    return list;
  }

  public List<String> ListMenuTools() {
    List<String> list = new ArrayList<String>();
    for (WebElement item : drpTools) {
      list.add(item.getText());
    }
    return list;
  }

}
