package automationFramework;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

public class InstitutionalClaimsTest extends FppsCodeLauncher {
  
	 public void test() throws Exception {
		  System.out.println("MedicalCodeLookup Test: Begin");
		  
		  Thread.sleep(5000);
		  if ( driver.findElement(By.className("page-title")).getAttribute("innerHTML").contains("Medical Code Lookup")) {
			  System.out.println("found Medical Code Lookup");
			  testInstitutionalClaim();
		  } else {
			  System.out.println("Didn't find Medical Code Lookup");
		  }
		  
	  }
	

  @Test
  public void testInstitutionalClaim() throws Exception {
	System.out.println("InstitutionalClaimsTest: Begin testInstitutionalClaim()");
	driver.get(baseURL+"institutionalClaim");
    assertEquals("Claim ID", driver.findElement(By.cssSelector("th")).getText());
    assertEquals("Claim Status", driver.findElement(By.xpath("//th[2]")).getText());
    assertEquals("Patient Control #", driver.findElement(By.xpath("//th[3]")).getText());
    assertEquals("Pre-Authorization #", driver.findElement(By.xpath("//th[4]")).getText());
    assertEquals("Veterain Information", driver.findElement(By.cssSelector("h6")).getText());
    assertEquals("First Name:", driver.findElement(By.xpath("//div[3]/div")).getText());
    assertEquals("Dominique", driver.findElement(By.xpath("//div[3]/div[2]")).getText());
    assertEquals("Service Provider Information", driver.findElement(By.xpath("//div[2]/div/div/h6")).getText());
    assertEquals("Phone:", driver.findElement(By.xpath("//div[2]/div/div[9]/div")).getText());
    assertEquals("123456789", driver.findElement(By.xpath("//div[2]/div/div[9]/div[2]")).getText());
    assertEquals("Billing Provider Information", driver.findElement(By.xpath("//div[3]/div/div/h6")).getText());
    assertEquals("City:", driver.findElement(By.xpath("//div[3]/div/div[6]/div")).getText());
    assertEquals("New York", driver.findElement(By.xpath("//div[3]/div/div[6]/div[2]")).getText());
    assertEquals("Pay-to Provider Information", driver.findElement(By.xpath("//div[4]/div/div/h6")).getText());
    assertEquals("NPI:", driver.findElement(By.xpath("//div[4]/div/div[11]/div")).getText());
    assertEquals("123456", driver.findElement(By.xpath("//div[4]/div/div[11]/div[2]")).getText());
    assertEquals("Other Insurance #(Secondary Payer):", driver.findElement(By.cssSelector("additional > div.container > div.row > div.col-4")).getText());
    assertEquals("987654321", driver.findElement(By.cssSelector("additional > div.container > div.row > div.col-6")).getText());
    assertEquals("Check/EFT/TRN:", driver.findElement(By.xpath("//div[@id='home']/additional/div/div[14]/div")).getText());
    assertEquals("123456", driver.findElement(By.xpath("//div[@id='home']/additional/div/div[14]/div[2]")).getText());
    driver.findElement(By.linkText("Diagnosis Codes")).click();
    assertEquals("Diagnosis Code", driver.findElement(By.xpath("//table[@id='style2']/thead/tr/th[2]")).getText());
    assertEquals("POA Indicator", driver.findElement(By.xpath("//table[@id='style2']/thead/tr/th[3]")).getText());
    assertEquals("Description", driver.findElement(By.xpath("//table[@id='style2']/thead/tr/th[4]")).getText());
    assertEquals("DX Type", driver.findElement(By.xpath("//table[@id='style2']/thead/tr/th[5]")).getText());
    assertEquals("ABC123", driver.findElement(By.xpath("//table[@id='style2']/tbody/tr[5]/td[2]")).getText());
    driver.findElement(By.linkText("Line Items")).click();
    assertEquals("ABC123", driver.findElement(By.xpath("//div[@id='line']/line/table/tbody/tr/td[2]")).getText());
    assertEquals("Revenue Code", driver.findElement(By.id("revcode-head")).getText());
    assertEquals("$999,999.00", driver.findElement(By.xpath("//div[@id='line']/line/table/tbody/tr[7]/td[6]")).getText());
    driver.findElement(By.linkText("Rerouting History")).click();
    assertEquals("Service Authorized by another VA facility in another state", driver.findElement(By.xpath("//div[@id='rerouting']/rerouting/table/tbody/tr/td[2]")).getText());
    assertEquals("Reason", driver.findElement(By.xpath("//div[@id='rerouting']/rerouting/table/thead/tr/th[2]")).getText());
    driver.findElement(By.linkText("Rejection History")).click();
    assertEquals("Reviewed By", driver.findElement(By.xpath("//div[@id='rejection']/rejection/table/thead/tr/th[5]")).getText());
    assertEquals("Service Authorized by another VA facility in another state", driver.findElement(By.xpath("//div[@id='rejection']/rejection/table/tbody/tr/td[3]")).getText());
    
    System.out.println("InstitutionalClaimsTest: End testInstitutionalClaim()");
  }

  @After
  public void tearDown() throws Exception {
	System.out.println("InstitutionalClaimsTest: Begin tearDown()");
	  
    driver.quit();
    Object verificationErrors = null;
	String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
    
    System.out.println("InstitutionalClaimsTest: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private String closeAlertAndGetItsText() {
    boolean acceptNextAlert = false;
	try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
