package automationFramework;

import java.io.File;
import static org.junit.Assert.*;
import org.openqa.selenium.*;
import org.openqa.selenium.ie.InternetExplorerDriver;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

import essentialComponents.Acceptance;
import essentialComponents.CreateUserRequestPage;
import essentialComponents.HeaderMenu;

// Import Selenium Pages

public class FppsCodeLauncher  {

	static InternetExplorerDriver driver;
	static String baseURL;
	static Acceptance acceptance;
	static HeaderMenu headerMenu;
	static CreateUserRequestPage page;
	
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		 JUnitCore junit = new JUnitCore();
		 junit.addListener(new TextListener(System.out));
		 Result result = junit.run(FppsCodeLauncher.class); // Replace "SampleTest" with the name of your class
	     if (result.getFailureCount() > 0) {
	    	 System.out.println("Test failed.\n" + result);
	    	 System.exit(1);
	     } else {
	    	 System.out.println("Test finished successfully.");
	    	 System.exit(0);
		}
	}
	
	@Before 
	  public void setUp() throws Exception { 
		// Login Page execution this is where it goes into login page and runs the necessary drivers
		  System.out.println("Fpps Launcher: Begin setUp()");
		  
		  File file = new File("drivers/IEDriverServer.exe");
		  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
		  
		  driver = new InternetExplorerDriver();
		  acceptance = new Acceptance(driver);
		  headerMenu = new HeaderMenu(driver);
		  page = new CreateUserRequestPage(driver);
		  baseURL = "http://localhost:4200/";
		  driver.get(baseURL);
		  driver.manage().window().maximize();
	      Thread.sleep(1000);
	      acceptance.ButtonAcceptClick();
	  }
	
	@Test
	  public void fppsTest() throws Exception { // Test Pages execution this is where you will place your pages to run
//		// Aged Claims Page
		// Claims
//		AgedClaimsTest agedClaims = new AgedClaimsTest(); 
//		agedClaims.test2();
//		
//		// Awaiting Claims Page
//		AwaitingClaimsTest awaitingCliams = new AwaitingClaimsTest(); 
//		awaitingCliams.test();
//		
//		// Claim Detail Status
//		ClaimDetailStatus claimStatus = new ClaimDetailStatus(); 
//		claimStatus.test();
//		 
//		// Claim Detail Tabs
//		ClaimDetailTabs claimTabs = new ClaimDetailTabs(); 
//		claimTabs.test();
//		
//		// Create User Request Page
//		CreateUserRequestTest createUser = new CreateUserRequestTest(); 
//		createUser.test();
//		
//		// Disapprove Button Page
//		DisapproveButtonTest disapproveButton = new DisapproveButtonTest(); 
//		disapproveButton.test();
//		
		// Disapprove Claims Page
//		DisapproveClaimsPageTest disapproveClaims = new DisapproveClaimsPageTest(); 
//		disapproveClaims.test();
//		
//		// Disapprove Execute Page
//		DisapproveExecuteTest disapproveExecute = new DisapproveExecuteTest(); 
//		disapproveExecute.test();
//		
//		// Disapprove Test Page: don't know if a page but it is a test
//		DisapproveTest disapproveTest = new DisapproveTest(); 
//		disapproveTest.test();
//		
//		// Disapprove Test Page: don't know if a page but it is a test
//		InProcessingTest inProcessing = new InProcessingTest(); 
//		inProcessing.test();
// OHI Tab
		OhiTabTest ohiInfo = new OhiTabTest();
		ohiInfo.test();
//		
		// Medical Code LookUp Page
//		MedicalCodeLookUp medicalCode = new MedicalCodeLookUp(); 
//		medicalCode.test();
		
//		// Out of System Payments Page 
//		OutOfSystemPayments outOfSystem = new OutOfSystemPayments(); 
//		outOfSystem.test();
	
//		// ReadOnly Access 
//		ReadOnly readOnlyAccess = new ReadOnly(); 
//		readOnlyAccess.test();
		
		// Edit Station & Add Station 
//		EditStationPage editStation = new EditStationPage(); 
//		editStation.test();
	  }

}
