package automationFramework;

import java.io.File;
import static org.junit.Assert.*;
import org.openqa.selenium.*;
import org.openqa.selenium.ie.InternetExplorerDriver;

import essentialComponents.Acceptance;
import essentialComponents.CreateUserRequestPage;
import essentialComponents.HeaderMenu;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;


public class ExampleCode {
	static InternetExplorerDriver driver;
	  static String baseURL;
	  static Acceptance acceptance;
	  static HeaderMenu headerMenu;
	  static CreateUserRequestPage page;
	  
  public static void main(String args[]) {
	    JUnitCore junit = new JUnitCore();
	    junit.addListener(new TextListener(System.out));
	    Result result = junit.run(ExampleCode.class); // Replace "SampleTest" with the name of your class
	    if (result.getFailureCount() > 0) {
	      System.out.println("Test failed.\n" + result);
	      System.exit(1);
	    } else {
	      System.out.println("Test finished successfully.");
	      System.exit(0);
	    }
	  }

  @Before
  public void setUp() throws Exception {
	  System.out.println("ClaimDetailTabs: Begin setUp()");
	  
	  File file = new File("drivers/IEDriverServer.exe");
	  System.setProperty("webdriver.ie.driver", file.getAbsolutePath());
	  
	  driver = new InternetExplorerDriver();
	  acceptance = new Acceptance(driver);
	  headerMenu = new HeaderMenu(driver);
	  page = new CreateUserRequestPage(driver);
	  baseURL = "http://localhost:4200/";
	  driver.get(baseURL);
	  driver.manage().window().maximize();
      Thread.sleep(1000);
      acceptance.ButtonAcceptClick();
      
      System.out.println("ClaimDetailTabs: End setUp()");
  }

  @Test
  public void testClientDetails() throws Exception {
	  System.out.println("ClaimDetailTabs: Begin testClientDetails()");
	  
	  Thread.sleep(1000);
	  driver.get(baseURL+"awaitingProcessing");
	  Thread.sleep(1000);
//	  driver.findElement(By.linkText("118")).sendKeys(Keys.ENTER);
//	  Thread.sleep(5000);
//	  driver.findElement(By.xpath("//*[text()[contains(.,'Establish')]]"))
	  additionalInfo();
	  diagnosisCodes();
	  lineItems();
	  reroutingHistory();
	  rejectionHistory();
	 
	  System.out.println("ClaimDetailTabs: End testClientDetails()");
    }

  public void additionalInfo() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab1-content")).getAttribute("innerHTML").contains("Additional Info")){
		  System.out.println("found Additional Info");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find Additional Info");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }

  public void diagnosisCodes() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab2-content")).getAttribute("innerHTML").contains("Diagnosis Codes")){
		  System.out.println("found Diagnosis Codes");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find Diagnosis Codes");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }

  
  public void lineItems() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab3-content")).getAttribute("innerHTML").contains("Line Items")){
		  System.out.println("found Line Items");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find Line Items");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }
  
  public void reroutingHistory() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab4-content")).getAttribute("innerHTML").contains("Rerouting History")){
		  System.out.println("found Rerouting History");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find Rerouting History");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }
  
  public void rejectionHistory() throws Exception {
	  Thread.sleep(5000);
	  driver.findElement(By.linkText("100")).sendKeys(Keys.ENTER);
	  Thread.sleep(5000);
	  if( driver.findElement(By.id("tab5-content")).getAttribute("innerHTML").contains("Rejection History")){
		  System.out.println("found Rejection History");
		  driver.get(baseURL+"awaitingProcessing");
		  
	  }else{
		  System.out.println(driver.findElement(By.id("tableHeaderClaimStatus")).getAttribute("innerHTML"));
		  System.out.println("Didn't find  Rejection History");
		  driver.get(baseURL+"awaitingProcessing");
	  }
  }
  
  @After
  public void tearDown() throws Exception {
    driver.quit();
    Object verificationErrors = null;
	String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      fail(verificationErrorString);
    }
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    try {
      driver.switchTo().alert();
      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

}
