package automationFramework;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import org.openqa.selenium.By;

import org.openqa.selenium.support.ui.Select;

public class DisapproveExecuteTest extends FppsCodeLauncher {

	  public void test() throws Exception {
		  System.out.println("MedicalCodeLookup Test: Begin");
		  driver.get(baseURL+"awaitingProcessing");
		  Thread.sleep(5000);
		  if ( driver.findElement(By.className("page-title")).getAttribute("innerHTML").contains("Medical Code Lookup")) {
			  System.out.println("found Medical Code Lookup");
			  Thread.sleep(2000);
			  driver.findElement(By.id("select0")).click();
			  Thread.sleep(2000);
			  driver.findElement(By.id("lowerDisapprove")).click();
			  Thread.sleep(3000);
			  testDisapprovePage();
			  testButtonDisabled();
			  testReasonCodesExist();
			  testIsDisapproveEnabled();
			  testPageSummaryExists();
			  testConfirmationMessage();
			  enterForm();
		  } else {
			  System.out.println("Didn't find Medical Code Lookup");
		  }
		  
	  }
	  

	@Test
	public void testDisapprovePage() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testDisapprovePage()");

		assertTrue(driver.findElement(By.id("header")).getAttribute("innerHTML").contains("Claims to Disapprove"));
		Thread.sleep(2000);
		
		System.out.println("DisapproveExecuteTest: End testDisapprovePage()");
	}
	
	@Test
	public void testButtonDisabled() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testButtonDisabled()");
		
		assertFalse(driver.findElement(By.id("disapproveButton")).isEnabled());
		
		System.out.println("DisapproveExecuteTest: End testButtonDisabled()");
	}
	
	@Test
	public void testReasonCodesExist() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testReasonCodesExist()");
		
		assertTrue(driver.findElements(By.id("reason")).size() > 0);
		
		System.out.println("DisapproveExecuteTest: End testReasonCodesExist()");
	}
	
	@Test
	public void testIsDisapproveEnabled() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testIsDisapproveEnabled()");
		
		enterForm();
		assertTrue(driver.findElement(By.id("disapproveButton")).isEnabled());
		
		System.out.println("DisapproveExecuteTest: End testIsDisapproveEnabled()");
	}
	
	@Test
	public void testPageSummaryExists() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testPageSummaryExists()");
		
		assertTrue(driver.findElements(By.id("pageSummary")).size() > 0);
		
		System.out.println("DisapproveExecuteTest: End testPageSummaryExists()");
	}
	
	@Test
	public void testConfirmationMessage() throws Exception {
		System.out.println("DisapproveExecuteTest: Begin testConfirmationMessage()");
		
		enterForm();
		driver.findElement(By.id("disapproveButton")).click();
		Thread.sleep(2000);
		assertTrue(driver.findElementById("successfulClaimsDisapprovalMessage").getAttribute("innerHTML").contains("Success: Disapproval Completed"));
		
		System.out.println("DisapproveExecuteTest: End testConfirmationMessage()");
	}
	
	void enterForm() {
		Select dropdown = new Select(driver.findElement(By.id("reason")));
		dropdown.selectByIndex(1);
		try {
			Thread.sleep(2000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		driver.findElement(By.id("comments")).sendKeys("Test Comment");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
