package automationFramework;

import static org.junit.Assert.fail;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

import org.junit.After;
import org.junit.Assert;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;


public class AwaitingClaimsTest extends FppsCodeLauncher {

  public void test() throws Exception {
	  System.out.println("AwaitingClaims Test: Begin");
	  driver.get(baseURL+"awaitingProcessing");
	  driver.findElement(By.id("checkBox0")).click();
	    Assert.assertTrue((driver.findElement(By.className("page-title")).getAttribute("innerHTML")).contains("Awaiting Processing"));
	    Assert.assertTrue(Boolean.parseBoolean(driver.findElement(By.id("checkBox0")).getAttribute("ng-reflect-model")));
	    Assert.assertTrue((driver.findElement(By.id("numResultsTop")).getAttribute("innerText")).contains("Number of results:"));
	    Assert.assertTrue((driver.findElement(By.id("numResultsBottom")).getAttribute("innerText")).contains("Number of results:"));
	    Assert.assertTrue((driver.findElement(By.id("claimId")).getAttribute("innerText")).contains("Claim ID"));
	    Assert.assertTrue((driver.findElement(By.id("claimStatus")).getAttribute("innerText")).contains("Claims Status"));
	    Assert.assertTrue((driver.findElement(By.id("claimType")).getAttribute("innerText")).contains("Claims Type"));
	    Assert.assertTrue((driver.findElement(By.id("hero")).getAttribute("innerText")).contains("HERO"));
	    Assert.assertTrue((driver.findElement(By.id("veteranName")).getAttribute("innerText")).contains("Veteran Name"));
	    Assert.assertTrue((driver.findElement(By.id("ssn")).getAttribute("innerText")).contains("SSN"));
	    Assert.assertTrue((driver.findElement(By.id("claimDate")).getAttribute("innerText")).contains("Claim Date"));
	    Assert.assertTrue((driver.findElement(By.id("claimAmount")).getAttribute("innerText")).contains("Claims Amount"));
	    Assert.assertTrue((driver.findElement(By.id("providerName")).getAttribute("innerText")).contains("Provider Name"));
	    Assert.assertTrue((driver.findElement(By.id("lines")).getAttribute("innerText")).contains("Lines"));
	    Assert.assertTrue((driver.findElement(By.id("facility")).getAttribute("innerText")).contains("Facility"));
	    Assert.assertTrue((driver.findElement(By.id("assignedTo")).getAttribute("innerText")).contains("Assigned To"));
	    Assert.assertTrue(isElementPresent(By.id("paginateFirst")));
	    Assert.assertTrue(driver.findElement(By.id("0")).getAttribute("href").contains("/institutionalClaim/"));
	    System.out.println(driver.getWindowHandles());
	    driver.findElement(By.id("upperPrintWithoutProcessing")).click();
	    Thread.sleep(3000);
	    String mwh = driver.getWindowHandle();
	    Set s = driver.getWindowHandles(); // this method will gives you the handles of all opened windows
	    Iterator ite = s.iterator();
	    while (ite.hasNext()) {
	      String popupHandle = ite.next().toString();
	      System.out.println(popupHandle);
	      if (!popupHandle.contains(mwh)) {
	        driver.switchTo().window(popupHandle);
	        driver.switchTo().window(mwh);
	      }
	    }
	    System.out.println(driver.getWindowHandles());
	    String id = (driver.findElement(By.xpath("//td[@id='claimId0']/div[1]")).getAttribute("innerText"));
	    System.out.println(id);
	    driver.findElement(By.id("upperProcessAndPrint")).click();
	    Thread.sleep(10000);
	    Assert.assertTrue(driver.findElement(By.xpath("//td[@id='claimId0']/div[1]")).getAttribute("innerText") != id);
	    driver.get(baseURL + "inProcessClaims");
	    Thread.sleep(5000);
	    for (int i = 0; i < 100; i++) {
	      System.out.println(driver.findElement(By.xpath("//td[@id='claimId" + i + "']/div[1]")).getAttribute("innerText"));
	      if ((driver.findElement(By.xpath("//td[@id='claimId" + i + "']/div[1]")).getAttribute("innerText")).contains(id)) {
	        Assert.assertTrue((driver.findElement(By.xpath("//td[@id='claimStatus" + i + "']/div[1]")).getAttribute("innerText")).contains("INPROCESS"));
	        break;
	      }
	      if (i == 100)
	        Assert.fail();
	    }

	    /*
	     * Output with IE11: [5994f136-4367-403f-b2f4-582a3bebd382] 5994f136-4367-403f-b2f4-582a3bebd382 [5994f136-4367-403f-b2f4-582a3bebd382] Output with Firefox: [13] 13 19 [13, 19]
	     */
	    System.out.println("AwaitingClaimsTest: End testAwaitingClaims()");
	  
  }


  @After
  public void tearDown() throws Exception {
	System.out.println("AwaitingClaimsTest: Begin tearDown()");
	
    driver.quit();
    Object verificationErrors = null;
	String verificationErrorString = verificationErrors.toString();
    if (!"".equals(verificationErrorString)) {
      System.out.println(verificationErrorString);
      fail(verificationErrorString);
    }
    
    System.out.println("AwaitingClaimsTest: End tearDown()");
  }

  private boolean isElementPresent(By by) {
    try {
      driver.findElement(by);
      return true;
    } catch (NoSuchElementException e) {
      return false;
    }
  }

  private boolean isAlertPresent() {
    String parentWindowHandle = driver.getWindowHandle();
    ArrayList<String> browserTabs = new ArrayList<String>(driver.getWindowHandles());
    try {
      driver.switchTo().alert();
      driver.switchTo().window(browserTabs.get(1));

      return true;
    } catch (NoAlertPresentException e) {
      return false;
    }
  }

  private boolean isOpenWindowCount() {
    String parentWindowHandle = driver.getWindowHandle();
    Set<String> allWindowHandles = driver.getWindowHandles();
    System.out.println("Parent window's handle -> " + parentWindowHandle);
    for (String handle : allWindowHandles) {
      System.out.println("Window handle - > " + handle);
    }

    return true;
  }

  private String closeAlertAndGetItsText() {
    boolean acceptNextAlert = false;
	try {
      Alert alert = driver.switchTo().alert();
      String alertText = alert.getText();
      if (acceptNextAlert) {
        alert.accept();
      } else {
        alert.dismiss();
      }
      return alertText;
    } finally {
      acceptNextAlert = true;
    }
  }
}
