# FppsApp

The DEV web server in EDE is running Node in clustered mode to utilize all 4 processor cores and load balance requests. For zero-second down time we are using PM2 to keep the Node instances running at all times throughout the cluster. After Jenkins runs a build, PM2 reloads all of the Node instances via the `pm2 reload all` command.

### Local development setup - Running NodeJS with PM2

PM2 is a process manager which can be installed locally via the `npm install -g pm2` command. To start up NodeJS, navigate to the *fpps-app* directory and run `pm2 start server.js`. Any changes to *typescript* files will require a manual rebuild using the `ng build` command. Any changes to *javascript* files, or files that provide Node services, will require a *reload* of NodeJS using the `pm2 reload all` command. 

Using this setup in place of `ng serve` matches how the app runs in DEV (EDE), QA (EDE) and SQA (HAC). There should be no hard-coded references to `http://localhost:4200` anywhere in the code base. 

### Building Angular

Run `ng build --verbose` to build the project. The build artifacts will be stored in the `dist/` directory. Use the --verbose flag for more insight into build failures if they happen. 

### Code scaffolding

Run `ng generate component component-name` to generate a new component. You can also use `ng generate directive|pipe|service|class|module`.

### Running unit tests

Run `ng test` to execute the unit tests via [Karma](https://karma-runner.github.io). Add the `--watch=false` flag to close the browser automatically once the tests finish.

### <span style="color:red">Before</span> committing code to Rational

Comment out any debug statements like `console.log()`. Also, make a habit of running `ng test --watch=false` <span style="color:red">before</span> you commit your code to RTC so you don't deliver broken code to the entire team :)

### Updates to node_modules

**Local development environment**

Use  these commands to update the package.json dependencies if needed

	#Install npm check updates module (NCU):
	npm i -g npm-check-updates

	#Check for npm updates:
	ncu -u -a

	#Install node modules:
	npm install

**EDE**

Any updates to node_modules <span style="color:red">must be coordinated</span> with the CM/CI group **prior** to committing changes to Rational. The EDE servers are heavily firewalled to prevent access to the public domain, and as such, it is impossible to simply run `npm install`, `npm update` or `ncu` on those servers.
