package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.PersonInfo;
import gov.va.med.domain.fee.PersonType;
import gov.va.med.fee.dao.IVeteranInfoRepository;
import gov.va.med.fee.model.response.VeteranInfoResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class VeteranInfoServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(VeteranInfoServiceImplTest.class);

	@InjectMocks
	private VeteranInfoServiceImpl personInfoServiceImplMock;

	@Mock
	private IVeteranInfoRepository iPersonInfoRepositoryMock;

	
	@Test
	public void testMockIsWorking() {
		assertNotNull("Person Info Service Injection Failed", personInfoServiceImplMock);
		assertNotNull("Person Info Repository Injection Failed", iPersonInfoRepositoryMock);
	}

	@Test
	public void testGetPersonInfo() {
		// Setup
		Long l = new Long("155");
		BigDecimal bg = BigDecimal.valueOf(l);
		Date birthDate = new GregorianCalendar(1945, Calendar.JANUARY, 22).getTime();
		Date deathDate = new GregorianCalendar(2010, Calendar.MARCH, 30).getTime();
		Date createdDate = new GregorianCalendar(2006, Calendar.FEBRUARY, 27).getTime();
		PersonType personType = new PersonType("DENTAL", createdDate, "John Doe");
		
		PersonInfo personInfo = new PersonInfo(1L, claim, personType, "156723", "Doe", "John", "Claire", "jr.",
				"Sarno Plaza", "Sarno Road", "Melbourne", "FL", "32935", "Male", birthDate, deathDate, "123456",
				"Single", "123456", "braintrust", "Dental", "123456", "50", bg, 'N', "John Doe", createdDate);

		VeteranInfoResponse personInfoResponse = new VeteranInfoResponse(1L, "Doe", "John", "Claire", "Sarno Plaza",
				"Sarno Road", "Melbourne", "FL", "32935", "Male", "01/22/1945", null);

		Mockito.when(iPersonInfoRepositoryMock.findOneByClaimId(claim.getClaimIndex())).thenReturn(personInfo);

		try {
			VeteranInfoResponse resultSet = personInfoServiceImplMock.getVeteranInfo(claim);
			assertEquals(personInfoResponse, resultSet);
			logger.info("Test case passed with no exceptions");
		} catch (Exception e) {
			logger.info("Exception is: " + e);
		}
	}
}
