package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.dao.IUserSearchRepository;
import gov.va.med.fee.model.request.UserSearchRequest;
import gov.va.med.fee.model.response.UserSearchResponse;

@RunWith(MockitoJUnitRunner.class)
public class UserSearchServiceImplTest {
	private static final Logger logger = LogManager.getLogger(UserSearchServiceImplTest.class);
	
	@InjectMocks
	UserSearchServiceImpl userSearchServiceImpl;
	
	@Mock
	IUserSearchRepository iUserSearchRepository;
	
	@Test
	public void test_searchUser() {
		UserSearchRequest request = new UserSearchRequest();
		
		List<UserSearchResponse> response= new ArrayList<UserSearchResponse>();
		UserSearchResponse userSearchResponse = new UserSearchResponse();
		
		userSearchResponse.setActive("Y");
		userSearchResponse.setEmail("abc.DNS   ");
		userSearchResponse.setFirstName("Alvin");
		userSearchResponse.setLastName("Stone");
		userSearchResponse.setPhone("6789997896");
		userSearchResponse.setUserName("DNS   BBAA");
		
		response.add(userSearchResponse);
		
		Mockito.when(iUserSearchRepository.searchUsers(request)).thenReturn(response);
		
		List<UserSearchResponse> result = iUserSearchRepository.searchUsers(request);
		assertEquals(result.get(0).getFirstName(), "Alvin");	
	}
}