package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.AppRole;
import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.AppUserRequest;
import gov.va.med.domain.fee.UserRoleUsages;
import gov.va.med.domain.fee.UserRoleUsagesId;
import gov.va.med.domain.fee.VaFacility;
import gov.va.med.fee.dao.IAppUserRepository;
import gov.va.med.fee.dao.IUserRequestRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.StationRequest;
import gov.va.med.fee.model.request.UserReqRequest;
import gov.va.med.fee.model.response.UserReqResponse;
import gov.va.med.fee.model.response.UserRoles;
import gov.va.med.fee.service.IAuthenticatorService;


@RunWith(MockitoJUnitRunner.class)
public class UserRequestServiceImplTest {

	private static final Logger logger = LogManager.getLogger(UserRequestServiceImplTest.class);
	
	@InjectMocks
	private UserRequestServiceImpl userRequestServiceImpl;
	
	@Mock
	IUserRequestRepositoryTemplate userRequestRepositoryTemplate;
	
	@Mock
	IAuthenticatorService authenticatorService;	
	
	@Mock
	IAppUserRepository appUserRepository;
		
	@Test
	public void testRequestAddUser_error() {
		try {
			String current_user_name = "VHAISMBAIAHBBB";
			String window_nt_name = "DNS   AAA";
			String last_name = "Jackson";
			String first_name = "Jacky";
			String phone = "1234567890";
			String email = "PII                ";
			Boolean enabled = Boolean.TRUE;
			
			String [] request_roles = new String[] {"FPPS_HELP_DESK"};		
			String [] request_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
			
			UserReqRequest req = new UserReqRequest(current_user_name, window_nt_name, last_name, first_name, "",
					phone, email, enabled, Arrays.asList(request_roles), Arrays.asList(request_facilities));
			
			AppUserRequest request = new AppUserRequest();
			request.setUserName(window_nt_name);
			request.setLastName(last_name);
			request.setFirstName(first_name);
			request.setPhoneNumber(phone);
			request.setEmailAddress(email);
			request.setRequestRoles("FPPS_HELP_DESK");
			request.setRequestFacilities("Visn: 16 / Facility: 520 (BILOXI MS), Visn: 16 / Facility: 564 (Fayetteville NC VAMC)");
			request.setEnabled(enabled?"Y":"N");
			
			List<AppUserRequest> requests = new ArrayList<>();
			requests.add(request);
			when(userRequestRepositoryTemplate.findRequestByAppUserName("DNS   AAA")).thenReturn(request);
			
			Set<UserRoleUsages> userRoles = new HashSet<>();
			AppUser appUser = new AppUser();
			appUser.setAppUserId(Long.valueOf(100));
			appUser.setUserName("VHAISMBAIAHBBB");
			appUser.setFirstName("Alvin");
			appUser.setLastName("Stone");
			
			// Role Admin
			AppRole appRole1 = new AppRole();
			appRole1.setAppRoleId(Long.valueOf(1));
			appRole1.setRoleName("FEE_VISN_PGM_MANAGER");
			appRole1.setDescription("FEE_VISN_PGM_MANAGER can do everything");
			
			UserRoleUsagesId id1 = new UserRoleUsagesId(Long.valueOf(1), Long.valueOf(1), "VAFAC001", "Y", "", new Date());
			UserRoleUsages userRole1 = new UserRoleUsages(id1, new VaFacility(), appRole1, appUser);
			userRoles.add(userRole1);
			appUser.setUserRoleUsages(userRoles);
						
			List<AppUser> list = new ArrayList<>();
			list.add(appUser);
			when(appUserRepository.findByAppUserName(current_user_name)).thenReturn(list);
			
			when(userRequestRepositoryTemplate.requestCreateUserRequest(req, "VHAISMBAIAHBBB")).thenReturn(0);
						
			int resultSet = userRequestServiceImpl.requestAddUser(req);
			assertEquals(resultSet, 0);
		} catch (GenericException e) {
			assertEquals(e.getMessage(), "Unable to create new user request");
		}
		
	}
	
	@Test
	public void testRequestAddUser_success() {
		try {	
			String current_user_name = "VHAISMBAIAHBBB";
			String window_nt_name = "DNS   AAA";
			String last_name = "Jackson";
			String first_name = "Jacky";
			String phone = "1234567890";
			String email = "PII                ";
			Boolean enabled = Boolean.TRUE;
			
			String [] request_roles = new String[] {"FPPS_HELP_DESK"};		
			String [] request_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
			
			UserReqRequest req = new UserReqRequest(current_user_name, window_nt_name, last_name, first_name, "",
					phone, email, enabled, Arrays.asList(request_roles), Arrays.asList(request_facilities));

			AppUserRequest request = new AppUserRequest();
			request.setUserName("DNS   ABCD");
			request.setLastName(last_name);
			request.setFirstName(first_name);
			request.setPhoneNumber(phone);
			request.setEmailAddress(email);
			request.setRequestRoles("FPPS_HELP_DESK");
			request.setRequestFacilities("Visn: 16 / Facility: 520 (BILOXI MS), Visn: 16 / Facility: 564 (Fayetteville NC VAMC)");
			request.setEnabled(enabled?"Y":"N");
			
			List<AppUserRequest> requests = new ArrayList<>();
			requests.add(request);
			when(userRequestRepositoryTemplate.findRequestByAppUserName("DNS   ABCD")).thenReturn(request);
			
			Set<UserRoleUsages> userRoles = new HashSet<>();
			AppUser appUser = new AppUser();
			appUser.setAppUserId(Long.valueOf(100));
			appUser.setUserName("VHAISMBAIAHBBB");
			appUser.setFirstName("Alvin");
			appUser.setLastName("Stone");
			
			// Role Admin
			AppRole appRole1 = new AppRole();
			appRole1.setAppRoleId(Long.valueOf(1));
			appRole1.setRoleName("FEE_VISN_PGM_MANAGER");
			appRole1.setDescription("FEE_VISN_PGM_MANAGER can do everything");
			
			UserRoleUsagesId id1 = new UserRoleUsagesId(Long.valueOf(1), Long.valueOf(1), "VAFAC001", "Y", "", new Date());
			UserRoleUsages userRole1 = new UserRoleUsages(id1, new VaFacility(), appRole1, appUser);
			userRoles.add(userRole1);
			appUser.setUserRoleUsages(userRoles);
						
			List<AppUser> list = new ArrayList<>();
			list.add(appUser);
			when(appUserRepository.findByAppUserName(current_user_name)).thenReturn(list);
			
			when(userRequestRepositoryTemplate.requestCreateUserRequest(req, "VHAISMBAIAHBBB")).thenReturn(1);
						
			int resultSet = userRequestServiceImpl.requestAddUser(req);
			assertEquals(resultSet, 1);
		} catch (GenericException e) {
			assertEquals(e.getMessage(), "Unable to create new user request");
		}
	}
	
	@Test
	public void testRequestModifyUser_success() {
		
		try {	
			long appUserId = 200L;
			String current_user_name = "VHAISMBAIAHBBB";
			String window_nt_name = "DNS   AAA";
			String last_name = "Jackson";
			String first_name = "Jacky";
			String phone = "1234567890";
			String email = "PII                ";
			Boolean enabled = Boolean.TRUE;
			
			String [] request_roles = new String[] {"FPPS_HELP_DESK"};		
			String [] request_facilities = new String[] {"Visn: 16 / Facility: 520 (BILOXI MS)","Visn: 16 / Facility: 564 (Fayetteville NC VAMC)"};
			
			UserReqRequest req = new UserReqRequest(current_user_name, window_nt_name, last_name, first_name, "",
					phone, email, enabled, Arrays.asList(request_roles), Arrays.asList(request_facilities));
			
			AppUserRequest request = new AppUserRequest();
			request.setUserName("DNS   ABCD");
			request.setLastName(last_name);
			request.setFirstName(first_name);
			request.setPhoneNumber(phone);
			request.setEmailAddress(email);
			request.setRequestRoles("FPPS_HELP_DESK");
			request.setRequestFacilities("Visn: 16 / Facility: 520 (BILOXI MS), Visn: 16 / Facility: 564 (Fayetteville NC VAMC)");
			request.setEnabled(enabled?"Y":"N");
			
			List<AppUserRequest> requests = new ArrayList<>();
			requests.add(request);
			when(userRequestRepositoryTemplate.findRequestByAppUserName("DNS   AAA")).thenReturn(request);
			
			Set<UserRoleUsages> userRoles = new HashSet<>();
			AppUser appUser = new AppUser();
			appUser.setAppUserId(Long.valueOf(100));
			appUser.setUserName("VHAISMBAIAHBBB");
			appUser.setFirstName("Alvin");
			appUser.setLastName("Stone");
			
			// Role Admin
			AppRole appRole1 = new AppRole();
			appRole1.setAppRoleId(Long.valueOf(1));
			appRole1.setRoleName("FEE_VISN_PGM_MANAGER");
			appRole1.setDescription("FEE_VISN_PGM_MANAGER can do everything");
			
			UserRoleUsagesId id1 = new UserRoleUsagesId(Long.valueOf(1), Long.valueOf(1), "VAFAC001", "Y", "", new Date());
			UserRoleUsages userRole1 = new UserRoleUsages(id1, new VaFacility(), appRole1, appUser);
			userRoles.add(userRole1);
			appUser.setUserRoleUsages(userRoles);
						
			List<AppUser> list = new ArrayList<>();
			list.add(appUser);
			when(appUserRepository.findByAppUserName(current_user_name)).thenReturn(list);
			when(userRequestRepositoryTemplate.requestModifyUserRequest(req, "VHAISMBAIAHBBB")).thenReturn(1);
						
			int resultSet = userRequestServiceImpl.requestModifyUser(req);
			assertEquals(resultSet, 1);
		} catch (GenericException e) {
			assertEquals(e.getMessage(), "Unable to create new user request");
		}
	}
	
	@Test
	public void testLoadRequestUser() { 
		try {
			List<UserRoles> roles = new ArrayList<>();
			UserRoles role = new UserRoles();
			//role.setRoleId(100L);
			role.setRoleName("FPPS_HELP_DESK");
			role.setDescription("FPPS HELP DESK");			
			roles.add(role);
			role = new UserRoles();
			//role.setRoleId(200L);
			role.setRoleName("FEE_SUPERVISOR");
			role.setDescription("FPPS SUPERVISOR");			
			roles.add(role);
			
			List<StationRequest> stationRequests = new ArrayList<>();
			stationRequests.add(new StationRequest("520", 16,"BILOXI MS"));
			stationRequests.add(new StationRequest("564", 16,"Fayetteville NC VAMC"));
			
			when(userRequestRepositoryTemplate.getRolesForRequest()).thenReturn(roles);
			when(userRequestRepositoryTemplate.getFacilitiesForRequest()).thenReturn(stationRequests);
			
			String [] available_roles = new String[] {roles.get(0).getRoleName().replaceAll("_", " "),roles.get(1).getRoleName().replaceAll("_", " ")};
			String [] available_facilities = new String[] {stationRequests.get(0).getDisplayFacility(),stationRequests.get(1).getDisplayFacility()};
			
			UserReqResponse response = new UserReqResponse(Arrays.asList(available_roles), Arrays.asList(available_facilities));
			
			UserReqResponse resultSet = userRequestServiceImpl.loadUserRequestForm();
			System.out.println("ResultSet is: " + resultSet.getAvailable_roles());
			System.out.println("Response is: " + response.getAvailable_roles());
			
			assertEquals(resultSet.getAvailable_roles(), response.getAvailable_roles());
			
			System.out.println("ResultSet is: " + resultSet.getAvailable_facilities());
			System.out.println("Response is: " + response.getAvailable_facilities());
			assertEquals(resultSet.getAvailable_facilities(), response.getAvailable_facilities());
			
			logger.info("Test case passed with no exceptions");
		} catch (GenericException e) {
			assertEquals("Loading Create User Request fail", e.getErrorCode());
		}
	}	
	
}
