package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.FeeClaimPaymentLines;
import gov.va.med.domain.fee.FeeClaimPayments;
import gov.va.med.fee.dao.IClaimPaymentRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IFeeClaimPaymentLines;
import gov.va.med.fee.dao.IFeeClaimPayments;
import gov.va.med.fee.dao.IPaymentLineItemsRepository;
import gov.va.med.fee.dao.IUnmatchedReconciliationRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.UnmatchedClaimPaymentRequest;
import gov.va.med.fee.model.request.UnmatchedReconciliationRequest;
import gov.va.med.fee.model.response.PaymentLineItemsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimPaymentsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimReconciliationResponse;


@RunWith(MockitoJUnitRunner.class)
public class UnmatchedReconciliationServiceImplTest extends AbstractClaimServiceImplTest {

	static final Logger logger = LogManager.getLogger(UnmatchedReconciliationServiceImplTest.class);
	
	@InjectMocks
	UnmatchedReconciliationServiceImpl unmatchedReconciliationService;	
	@Mock
	IClaimRepository iClaimRepository;
	@Mock
	IClaimPaymentRepository iClaimPaymentRepository;	
	@Mock
	IUnmatchedReconciliationRepositoryTemplate iUnmatchedReconciliationRepositoryTemplate;
	@Mock
	IPaymentLineItemsRepository iPaymentLineItemsRepository;
	@Mock
	IFeeClaimPaymentLines iFeeClaimPaymentLines;
	@Mock
	IFeeClaimPayments iFeeClaimPayments;
	
	SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
	
	@Test
	public void test_getUnmatchedClaimsInformation() throws GenericException {
		claim.setDateCreated(dateCreated);
		claim.setTotalBilledCharge(new BigDecimal(123456));
		when(iClaimRepository.findClaimStatusByClaimIndex(claim.getClaimIndex())).thenReturn(claim);
		
		UnmatchedClaimPaymentsResponse unmatchedClaimPaymentsResponse = new UnmatchedClaimPaymentsResponse();
		unmatchedClaimPaymentsResponse.setClaimId(claim.getClaimIndex());
		unmatchedClaimPaymentsResponse.setClaimType(claim.getServiceType().getServiceTypeCd());
		unmatchedClaimPaymentsResponse.setClaimDate(dateFormat.format(claim.getDateCreated()));
		unmatchedClaimPaymentsResponse.setClaimAmount(claim.getTotalBilledCharge());		
		
		UnmatchedClaimPaymentsResponse result = unmatchedReconciliationService.getUnmatchedClaimsInformation(claim.getClaimIndex());
		logger.debug("result - "+ result);
		assertEquals(unmatchedClaimPaymentsResponse, result);
		
	}
	
	@Test
	public void test_getUnmatchedClaimPayments() throws GenericException {
		claim.setDateCreated(dateCreated);
		
		UnmatchedReconciliationRequest unmatchedReconciliationRequest = new UnmatchedReconciliationRequest("C", "88", "1234",
				"ERROR", "424828", "0.8878", "830", dateCreated.toString());
		
		List<UnmatchedClaimPaymentsResponse> unmatchedClaimPaymentsList = new ArrayList<UnmatchedClaimPaymentsResponse>();
		UnmatchedClaimPaymentsResponse unmatchedClaimPaymentsResponse = new UnmatchedClaimPaymentsResponse();
		unmatchedClaimPaymentsResponse.setClaimId(claim.getClaimIndex());
		unmatchedClaimPaymentsResponse.setClaimType(claim.getServiceType().getServiceTypeCd());
		unmatchedClaimPaymentsResponse.setClaimDate(claim.getDateCreated().toString());
		unmatchedClaimPaymentsResponse.setClaimAmount(claim.getTotalBilledCharge());
		unmatchedClaimPaymentsList.add(unmatchedClaimPaymentsResponse);
		
		claim = new Claim(1000L, serviceType, visn, "C001", 'T');
		claim.setDateCreated(dateCreated);
		claim.setTotalBilledCharge(new BigDecimal(9876));
		unmatchedClaimPaymentsResponse = new UnmatchedClaimPaymentsResponse();
		unmatchedClaimPaymentsResponse.setClaimId(claim.getClaimIndex());
		unmatchedClaimPaymentsResponse.setClaimType(claim.getServiceType().getServiceTypeCd());
		unmatchedClaimPaymentsResponse.setClaimDate(claim.getDateCreated().toString());
		unmatchedClaimPaymentsResponse.setClaimAmount(claim.getTotalBilledCharge());
		unmatchedClaimPaymentsList.add(unmatchedClaimPaymentsResponse);
		
		when(iUnmatchedReconciliationRepositoryTemplate.getClaimPaymentInformation(unmatchedReconciliationRequest)).thenReturn(unmatchedClaimPaymentsList);
						
		List<UnmatchedClaimPaymentsResponse> result = unmatchedReconciliationService.getUnmatchedClaimPayments(unmatchedReconciliationRequest);
		logger.debug("result - "+ result);
		assertEquals(unmatchedClaimPaymentsList, result);
	}
	
	@Test
	public void test_getclaimPaymentLines() throws Exception {
		
		String feeClaimPaymentId = "25403F0D-B338-2204-E040-BF0A070C5552";
		
		List<FeeClaimPaymentLines> feeClaimPaymentLines = new ArrayList<>();
		FeeClaimPaymentLines f = new FeeClaimPaymentLines();
		f.setFeeClaimPaymentLineId("999");
		f.setLineItemSequence("1");
		f.setBilledAmount(new BigDecimal(123));
		f.setPaidAmount(new BigDecimal(113));
		f.setUnitsPaid(10);
		f.setServiceDate(new Date());
		feeClaimPaymentLines.add(f);
		
		f = new FeeClaimPaymentLines();
		f.setFeeClaimPaymentLineId("1000");
		f.setLineItemSequence("2");
		f.setBilledAmount(new BigDecimal(123));
		f.setPaidAmount(new BigDecimal(113));
		f.setUnitsPaid(10);
		f.setServiceDate(new Date());
		feeClaimPaymentLines.add(f);
		
		Set<PaymentLineItemsResponse> paymentLineItemsResponse = new HashSet<>();	
		PaymentLineItemsResponse item = new PaymentLineItemsResponse("999", "1", "1", new BigDecimal(123), new BigDecimal(113), 10, dateFormat.format(new Date())) ;
		paymentLineItemsResponse.add(item);
		item = new PaymentLineItemsResponse("1000", "2", "2", new BigDecimal(123), new BigDecimal(113), 10, dateFormat.format(new Date())) ;
		paymentLineItemsResponse.add(item);
		
		UnmatchedClaimReconciliationResponse response = new UnmatchedClaimReconciliationResponse();
		response.setPaymentLineItemsResponse(paymentLineItemsResponse);
		
		when(iPaymentLineItemsRepository.getFeeClaimPaymentLines(feeClaimPaymentId)).thenReturn(feeClaimPaymentLines);
		
		UnmatchedClaimReconciliationResponse result = unmatchedReconciliationService.getPaymentLineItems(feeClaimPaymentId);
		logger.debug("result - "+ result);
		logger.debug("result - "+ response);
		
		assertEquals(result, response);
	}
	
	@Test
	public void test_setEditPaymentInformation() throws Exception {
		String feeClaimPaymentLineId = "2E5B4B36-9C62-8674-E040-BF0A070C2C26";
		Long claimId = 351883L;
		String lineNumber = "002";
		BigDecimal adjustment1 = null;
		BigDecimal adjustment2 = null;
		String group1 = "A1"; 
		String reason1= "999";
		
		UnmatchedClaimPaymentRequest request = new UnmatchedClaimPaymentRequest(feeClaimPaymentLineId, claimId, lineNumber,
				adjustment1, adjustment2, group1, null, reason1,null);
		
		FeeClaimPaymentLines f = new FeeClaimPaymentLines();
		f.setFeeClaimPaymentLineId("999");
		f.setLineItemSequence("1");
		f.setBilledAmount(new BigDecimal(123));
		f.setPaidAmount(new BigDecimal(113));
		f.setUnitsPaid(10);
		f.setServiceDate(new Date());
		FeeClaimPayments feeClaimPayments = new FeeClaimPayments();
		feeClaimPayments.setBilledAmount(new BigDecimal(123));
		feeClaimPayments.setClaimIndex(claimId);
		
		f.setFeeClaimPayments(feeClaimPayments);
		
		
		when(iFeeClaimPaymentLines.getFeeClaimPaymentLinesByFeeClaimPaymentLineId(request.getFeeClaimPaymentLineId())).thenReturn(f);
			
		when(iFeeClaimPayments.getFeeClaimPaymentsByFeeClaimPaymentsId(
				f.getFeeClaimPayments().getFeeClaimPaymentId())).thenReturn(feeClaimPayments);
				
		UnmatchedClaimReconciliationResponse response = new UnmatchedClaimReconciliationResponse();
		response.setResponse("Claim Reconciled successfully ");
				
		
		UnmatchedClaimReconciliationResponse result = unmatchedReconciliationService.EditPaymentInformation(request);
		
		logger.debug("result - "+ result);
		logger.debug("result - "+ response);
		assertEquals(result, response);
			
	}
}
