/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.ClaimProcedure;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.fee.dao.IPayToAndServiceProviderRepository;
import gov.va.med.fee.exceptions.GenericException;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class ServiceProviderServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(ServiceProviderServiceImplTest.class);

	@InjectMocks
	private ProviderInfoServiceImpl payToProviderServiceImplMock;

	@Mock
	private IPayToAndServiceProviderRepository iServiceProviderRepositoryMock;

	@Before
	public void setup() throws GenericException {
		// Long claimIndex = 1L;

		payToProviderServiceImplMock = new ProviderInfoServiceImpl();

		iServiceProviderRepositoryMock = Mockito.mock(IPayToAndServiceProviderRepository.class);
		payToProviderServiceImplMock.setPayToAndServiceProvideRepository(iServiceProviderRepositoryMock);
	}

	@Test
	public void testMockIsWorking() {
		assertNotNull("Pay To Provider Service Injection Failed", payToProviderServiceImplMock);
		assertNotNull("IPayToProviderRepository Injection Failed", iServiceProviderRepositoryMock);
	}

	@Test
	public void testGetPayToProviderInfo() {
		// Setup
		
		ProviderType providerType = new ProviderType("SERVICE LOCATION", providerCreatedDate, "VA");
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		ProviderInfo providerInfo = new ProviderInfo(Long.valueOf(1000), claim, claimProcedure, providerType,
				"VA USA", "VA USA", "VA USA", "Doe", "John", "johnny", "jr.", "Sarno Plaza", "Sarno Road", "Melbourne",
				"Florida", "32935", "John Doe", "9999999999", "912345678", "john.doe@DOMAIN", Long.valueOf(1000), dateCreated, "VA USA");

		Mockito.when(iServiceProviderRepositoryMock.findOneByType(claim.getClaimIndex(), "SERVICE LOCATION"))
				.thenReturn(providerInfo);
		
		try {
			//ClaimsProviderResponse resultSet = payToProviderServiceImplMock.getPayToProviderResponseInfo(Long.valueOf(9999));
			ProviderInfo resultSet = payToProviderServiceImplMock.getPayToAndServiceInfo(claim.getClaimIndex(), "SERVICE LOCATION");
					
			assertEquals(providerInfo, resultSet);
			logger.info("Test case passed with no exceptions");
			
		} catch (Exception e) {
			System.out.println("Exception is: " + e);
			logger.info("Exception is: " + e);
		}
	}
}
