package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.AppRole;
import gov.va.med.domain.fee.AppUser;
import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.FeeClaimRoutingsReason;
import gov.va.med.domain.fee.PersonInfo;
import gov.va.med.domain.fee.PersonType;
import gov.va.med.domain.fee.PrintedClaim;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.domain.fee.UserRoleUsages;
import gov.va.med.domain.fee.UserRoleUsagesId;
import gov.va.med.domain.fee.VaFacility;
import gov.va.med.fee.dao.IAppUserRepository;
import gov.va.med.fee.dao.IClaimPaymentRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IFeeClaimRoutingRepository;
import gov.va.med.fee.dao.IFeeClaimRoutingsReasonRepository;
import gov.va.med.fee.dao.IPrintedClaimRepository;
import gov.va.med.fee.dao.IReRoutingHistoryRepositoryTemplate;
import gov.va.med.fee.dao.IRerouteClaimsRepositoryTemplate;
import gov.va.med.fee.dao.IVaFacilityRepository;
import gov.va.med.fee.dao.IVeteranInfoRepository;
import gov.va.med.fee.dao.IVisnRepository;
import gov.va.med.fee.dao.IWsFacStatusRepository;
import gov.va.med.fee.dao.IWsProviderLuRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ReRoutingHistory;
import gov.va.med.fee.model.response.RerouteClaimInfo;
import gov.va.med.fee.model.response.RerouteClaimResponse;


@RunWith(MockitoJUnitRunner.class)
public class RerouteClaimsServiceImplTest {
	private static final Logger logger = LogManager.getLogger(RerouteClaimsServiceImplTest.class);
	
	@InjectMocks
	private RerouteClaimsServiceImpl rerouteClaimsServiceImpl;
	
	@Mock
	IRerouteClaimsRepositoryTemplate rerouteClaimsRepository;
	@Mock
	IClaimPaymentRepository claimPaymentRepository;
	@Mock
	IClaimRepository claimRepository;
	@Mock
	IReRoutingHistoryRepositoryTemplate reRoutingHistoryRepository;
	@Mock
	IPrintedClaimRepository printedClaimRepository;
	@Mock
	IVaFacilityRepository vaFacilityRepository;
	@Mock
	IVisnRepository visnRepository;
	@Mock
	IFeeClaimRoutingsReasonRepository feeClaimRoutingsReasonRepository;
	
	@Mock
	IVeteranInfoRepository veteranInfoRepository;
	@Mock
	IFeeClaimRoutingRepository feeClaimRoutingRepository;
	@Mock
	IWsFacStatusRepository wsFacStatusRepository;
	@Mock
	IWsProviderLuRepository wsProviderLuRepository;
	@Mock
	IAppUserRepository appUserRepository;
	
	private final String DEFAULT_SELECT_VALUE = "-select-";
	
	
	@Test
	public void test_populateReroutes() {
		
		List<Long> claimsToReroute = new ArrayList<>();
		claimsToReroute.add(527L);
		claimsToReroute.add(529L);
		
		PersonType type = new PersonType();
		type.setPersonTypeCd("PATIENT");
		
		List<Claim> claims = new ArrayList<>();
		Claim claim = new Claim();
		claim.setClaimIndex(528L);
		claim.setClaimStatusCd("ESTABLISH");
		claim.setVaImpTypeCd(null);
		Set<PersonInfo> persons = new HashSet<>();
		PersonInfo p = new PersonInfo();
		p.setPersonType(type);
		p.setFirstName("CASSANDRA");
		p.setLastName("ALVARADO");
		persons.add(p);
		claim.setPersonInfos(persons);
		
		ProviderType providerType = new ProviderType();
		providerType.setProviderTypeCd("SERVICE FACILITY");		
		
		Set<ProviderInfo> providers = new HashSet<>();
		ProviderInfo provider = new ProviderInfo();
		provider.setLastName("MYRTICE");
		provider.setProviderType(providerType);
		providers.add(provider);
		claim.setProviderInfos(providers);
		claims.add(claim);
		
		claim = new Claim();
		claim.setClaimIndex(529L);
		claim.setClaimStatusCd("ESTABLISH");
		claim.setVaImpTypeCd(null);
		persons = new HashSet<>();
		p = new PersonInfo();
		p.setPersonType(type);
		p.setFirstName("GLENDA");
		p.setLastName("HILTON");
		persons.add(p);
		claim.setPersonInfos(persons);
		providers = new HashSet<>();
		provider = new ProviderInfo();
		provider.setLastName("ELFRIEDA");
		provider.setProviderType(providerType);
		providers.add(provider);
		claim.setProviderInfos(providers);
		claims.add(claim);
		
		when(claimRepository.findAll(claimsToReroute)).thenReturn(claims);
		
		List<RerouteClaimInfo> claims_to_be_rerouted = new ArrayList<>();
		RerouteClaimInfo c = new RerouteClaimInfo(528, "CASSANDRA ALVARADO", "MYRTICE");
		claims_to_be_rerouted.add(c);
		c = new RerouteClaimInfo(529, "GLENDA HILTON", "ELFRIEDA");
		claims_to_be_rerouted.add(c);				
		
		Long[] visn = new Long[] {7l,8l,9l,10l,11l,12l,13l,14l,15l};
		when(visnRepository.findAllVisnId()).thenReturn(Arrays.asList(visn));
		
		String selectedVisnId = "16";
		String[] facilities = new String[] {DEFAULT_SELECT_VALUE};
		when(vaFacilityRepository.findFacilitiesList(Long.valueOf(selectedVisnId))).thenReturn(Arrays.asList(facilities));
		
		List<FeeClaimRoutingsReason> reasons = new ArrayList<>();
		FeeClaimRoutingsReason fcrr = new FeeClaimRoutingsReason("1", "Services were authorized by another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("1", "Services were authorized by another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("2", "Veterans Fee ID Card from another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("3", "Clinic of Jurisdiction resides elsewhere", null, null);
		reasons.add(fcrr);
		when(feeClaimRoutingsReasonRepository.getRerouteReasons()).thenReturn(reasons);
		
		Map<String, String> rerouteReasonMap = new HashMap<>();
		for(FeeClaimRoutingsReason reason : reasons) {
			rerouteReasonMap.put(reason.getTransferReasonCd(), reason.getDescription());
		}
		
		Map<Long, List<ReRoutingHistory>> reroute_history = new LinkedHashMap<>();
		List<ReRoutingHistory> hList = new ArrayList<>();
		ReRoutingHistory h = new ReRoutingHistory();
		h = new ReRoutingHistory();
		h.setReason("Transfer code 8");
		h.setTransferredBy("1");
		hList.add(h);
		reroute_history.put(528L, hList);
		when(reRoutingHistoryRepository.findReRoutingHistory(claimsToReroute.get(1))).thenReturn(hList);
		
		hList = new ArrayList<>();
		h.setReason("Transfer code 9");
		h.setTransferredBy("1");
		hList.add(h);
		reroute_history.put(529L, hList);
		when(reRoutingHistoryRepository.findReRoutingHistory(claimsToReroute.get(0))).thenReturn(hList);		
				
		RerouteClaimResponse response = new RerouteClaimResponse();
		response.setClaims_to_be_rerouted(claims_to_be_rerouted);	
		response.setVisns(Arrays.asList(visn));
		response.setFacilities(Arrays.asList(facilities));
		//response.setNames(Arrays.asList(names));	
		response.setReasons(rerouteReasonMap);
		response.setReroute_history(reroute_history);
				
		try {
			RerouteClaimResponse result = rerouteClaimsServiceImpl.populateReroutes(claimsToReroute);
			logger.debug("response - "+ response);
			logger.debug("result - "+ result);
			
			//assertEquals(response, result);
		} catch (GenericException e) {
			e.printStackTrace();
		}
		
	}
	
	/*@Test
	public void test_processReroutes() throws GenericException{
		List<RerouteClaimInfo> claims_to_be_rerouted = new ArrayList<>();
		RerouteClaimInfo info = new RerouteClaimInfo(528, "CASSANDRA ALVARADO", "MYRTICE");
		claims_to_be_rerouted.add(info);
				
		String current_user_name = "VHAISMBAIAHBBB";
		String selectedVisnId = "16";
		String selectedFacilityId = "563";
		String selectedReason = "1";
		RerouteClaimRequest request= new RerouteClaimRequest();
		request.setClaims_to_be_rerouted(claims_to_be_rerouted);
		request.setSelectedFacility(selectedFacilityId);
		request.setSelectedVisn(selectedVisnId);
		request.setSelectedReason(selectedReason);
		request.setCurrent_user_name(current_user_name);
		
		Set<UserRoleUsages> userRoles = new HashSet<>();
		AppUser appUser = new AppUser();
		appUser.setAppUserId(Long.valueOf(100));
		appUser.setUserName("VHAISMBAIAHBBB");
		appUser.setFirstName("Alvin");
		appUser.setLastName("Stone");
		
		// Role Admin
		AppRole appRole1 = new AppRole();
		appRole1.setAppRoleId(Long.valueOf(1));
		appRole1.setRoleName("FEE_VISN_PGM_MANAGER");
		appRole1.setDescription("FEE_VISN_PGM_MANAGER can do everything");
		
		UserRoleUsagesId id1 = new UserRoleUsagesId(Long.valueOf(1), Long.valueOf(1), "VAFAC001", "Y", "", new Date());
		UserRoleUsages userRole1 = new UserRoleUsages(id1, new VaFacility(), appRole1, appUser);
		userRoles.add(userRole1);
		appUser.setUserRoleUsages(userRoles);
					
		List<AppUser> list = new ArrayList<>();
		list.add(appUser);
		when(appUserRepository.findByAppUserName(current_user_name)).thenReturn(list);
		
		Visn toVisn = new Visn(Long.valueOf(selectedVisnId), "CCSE", new Date());
		when(visnRepository.findOne(Long.valueOf(selectedVisnId))).thenReturn(toVisn);	
		
		VaFacility facility = new VaFacility(selectedFacilityId, toVisn,
				new VaFacilityType("FAC", "CCSE", new Date()), true,"CCSE", new Date());
		when(vaFacilityRepository.findByVisnIdVaFacilityCd(Long.valueOf(selectedVisnId), selectedFacilityId)).thenReturn(facility);
			
		RerouteClaimResponse response = new RerouteClaimResponse();
		response.setReroutedSuccessful("Claim(s): 528 rerouted successfully.");
		
		FeeClaimRoutingsReason fcrReason = new FeeClaimRoutingsReason();
		fcrReason.setTransferReasonCd("1");
		fcrReason.setDescription("Services were authorized by another VA facility");
		when(feeClaimRoutingsReasonRepository.getFeeClaimRoutingsReason(request.getSelectedReason())).thenReturn(fcrReason);
		
		when(rerouteClaimsRepository.findVaImplementationList(selectedFacilityId)).thenReturn(null);
				
		for(RerouteClaimInfo claim2reroute : claims_to_be_rerouted) {
			Claim claim = new Claim();
			claim.setClaimIndex(528L);
			claim.setClaimStatusCd("ESTABLISH");
			claim.setVaImpTypeCd(null);
			Set<PersonInfo> persons = new HashSet<>();
			PersonInfo p = new PersonInfo();
			PersonType type = new PersonType();
			type.setPersonTypeCd("PATIENT");
			p.setPersonType(type);
			p.setFirstName("CASSANDRA");
			p.setLastName("ALVARADO");
			persons.add(p);
			claim.setPersonInfos(persons);
			
			ProviderType providerType = new ProviderType();
			providerType.setProviderTypeCd("SERVICE FACILITY");		
			
			Set<ProviderInfo> providers = new HashSet<>();
			ProviderInfo provider = new ProviderInfo();
			provider.setLastName("MYRTICE");
			provider.setProviderType(providerType);
			providers.add(provider);
			claim.setProviderInfos(providers);
			when(claimRepository.findClaimByClaimIndex(claim2reroute.getClaim_id())).thenReturn(claim);
			
			when(veteranInfoRepository.findOneByClaimId(claim.getClaimIndex())).thenReturn(p);
			
			FeeClaimRouting fcr = new FeeClaimRouting();
			fcr.setClaim(claim);
			fcr.setTransferFromUser(claim.getUserName());
			VaFacility vf = claim.getVaFacility() == null ? new VaFacility() : claim.getVaFacility();
			String vfc = vf.getVaFacilityCd() == null ? "" : vf.getVaFacilityCd();
			fcr.setTransferFromFacilityCd(vfc);
			fcr.setTransferFromVisnCd("" + claim.getVisn().getVisnIdCd());
			
			claim.setUserName("");
            
			vf = vaFacilityRepository.findVaFacilityByVaFacilityCd(selectedFacilityId);
			claim.setVaFacility(vf);
			claim.setVisn(toVisn);
			claim.setClaimStatusCd("ESTABLISH");
			claim.setModifiedBy(request.getCurrent_user_name());


			// all claim (c) data now set to new owner
			fcr.setTransferToFacilityCd(selectedFacilityId);
			fcr.setTransferToVisnCd(request.getSelectedVisn());
			java.sql.Date sqlDate = new java.sql.Date(new Date().getTime());
			claim.setDateModified(sqlDate);
			fcr.setTransferDate(sqlDate);
			fcr.setDateCreated(sqlDate); // this is the same as the xfer date??
			fcr.setComments(request.getComment());
			fcr.setTransferInitator(request.getCurrent_user_name());
			fcr.setCreatedBy(request.getCurrent_user_name());
			fcr.setFeeClaimRoutingsReason(fcrReason);
			when(feeClaimRoutingRepository.saveAndFlush(fcr)).thenReturn(fcr);
		}
	}
	*/
	@Test
	public void test_routable() {
		Claim claim = new Claim();
		claim.setClaimIndex(128L);
		claim.setClaimStatusCd("ESTABLISH");
		
		List<Long> list = null;
		when(claimPaymentRepository.findClaimPaymentsByClaimIndex(claim.getClaimIndex())).thenReturn(list);
		
		try {
			boolean routable = rerouteClaimsServiceImpl.routable(claim);
			assertEquals(routable, true);
		} catch (GenericException e) {
			e.printStackTrace();
		}
		
	}
	
	@Test
	public void test_isPrintedClaim() {
		
		Claim claim = new Claim();
		claim.setClaimIndex(128L);
		claim.setClaimStatusCd("ESTABLISH");
		
		PrintedClaim result = new PrintedClaim();
		result.setClaim(claim);
		result.setCreatedBy("ABC");
		result.setDateCreated(new Date());
		result.setPrintedClaimId(1L);
		
		when(printedClaimRepository.findPrintedClaim(claim.getClaimIndex())).thenReturn(result);
		
		try {
			boolean isPrinted = rerouteClaimsServiceImpl.isPrintedClaim(claim);
			assertEquals(isPrinted, true);
		} catch (GenericException e) {
			e.printStackTrace();
		}
	}
			
	@Test
	public void test_hasReconciledLine() {
		
	}
	
	@Test
	public void test_getVisnList() {
		Long[] visn = new Long[] {7l,8l,9l,10l,11l,12l,13l,14l,15l};
		
		when(visnRepository.findAllVisnId()).thenReturn(Arrays.asList(visn));
		
		try {
			List<Long> visns = rerouteClaimsServiceImpl.getVisnList();
			logger.debug("visns - "+ visns);
			assertEquals(visns, Arrays.asList(visn));
		} catch (GenericException e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void test_getFacilitiesList() {
		String selectedVisnId = "16";
		String[] facilities = new String[] {"563","564","580","586","598"};
		
		when(vaFacilityRepository.findFacilitiesList(Long.valueOf(selectedVisnId))).thenReturn(Arrays.asList(facilities));
		
		try {
			List<String> facilitiesList  = rerouteClaimsServiceImpl.getFacilitiesList(selectedVisnId);
			logger.debug("facilitiesList - "+ facilitiesList);
			assertEquals(facilitiesList, Arrays.asList(facilities));
		} catch (GenericException e) {
			e.printStackTrace();
		}
	}
		
	@Test
	public void test_getRerouteReasons() {
		List<FeeClaimRoutingsReason> reasons = new ArrayList<>();
		FeeClaimRoutingsReason fcrr = new FeeClaimRoutingsReason("1", "Services were authorized by another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("1", "Services were authorized by another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("2", "Veterans Fee ID Card from another VA facility", null, null);
		reasons.add(fcrr);
		fcrr = new FeeClaimRoutingsReason("3", "Clinic of Jurisdiction resides elsewhere", null, null);
		reasons.add(fcrr);
		when(feeClaimRoutingsReasonRepository.getRerouteReasons()).thenReturn(reasons);
		
		Map<String, String> rerouteReasonMap = new HashMap<>();
		for(FeeClaimRoutingsReason reason : reasons) {
			rerouteReasonMap.put(reason.getTransferReasonCd(), reason.getDescription());
		}
		
		try {
			Map<String, String> rerouteReasons  = rerouteClaimsServiceImpl.getRerouteReasons();
			logger.debug("rerouteReasons - "+ rerouteReasons);
			assertEquals(rerouteReasons, rerouteReasonMap);
		} catch (GenericException e) {
			e.printStackTrace();
		}
	}	
}