package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.RemittanceRemark;
import gov.va.med.fee.dao.IAdjustmentsRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.RemittanceRemarkDTO;
import gov.va.med.fee.model.response.RemittanceRemarkResponse;

@RunWith(MockitoJUnitRunner.class)
public class RemittanceRemarksServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(RemittanceRemarksServiceImplTest.class);
	@InjectMocks
	private RemittanceRemarksServiceImpl remittanceRemarksServiceImplMock;
	
	@Mock
	private IAdjustmentsRepository iDisClaimRepository;
	

	@Test
	public void test_getRemittanceRemarksByReasonCode() {
		logger.info("test_getRemittanceRemarksByReasonCode:");
		List<RemittanceRemark> remittanceRemarkList = new ArrayList<RemittanceRemark>();
		RemittanceRemark remittanceRemark = new RemittanceRemark();
		remittanceRemark.setRemittanceRemarkCd("M10");
		remittanceRemark.setDescription("Equipment purchases are limited to the first or the tenth month of medical necessity.");
		remittanceRemarkList.add(remittanceRemark);
		
		RemittanceRemarkDTO remittanceRemarkDTO = new RemittanceRemarkDTO();
		remittanceRemarkDTO.setCode("M10");
		remittanceRemarkDTO.setDescription("Equipment purchases are limited to the first or the tenth month of medical necessity.");
		
		RemittanceRemarkResponse remittanceRemarkResponse  = null;
		Mockito.when(iDisClaimRepository.findRemittanceRemarksByReasonCode("125")).thenReturn(remittanceRemarkList);
		try {
			remittanceRemarkResponse = remittanceRemarksServiceImplMock.getRemittanceRemarksByReasonCode("125");
		} catch (GenericException e) {
			e.printStackTrace();
		}
		for(RemittanceRemarkDTO remRemarkDTO:remittanceRemarkResponse.getRemittanceRemarks()) {
			if(remRemarkDTO.getCode().equals(remittanceRemarkDTO.getCode())) {
				assertEquals(remRemarkDTO.getCode(), remittanceRemarkDTO.getCode());
				assertEquals(remRemarkDTO.getDescription(), remittanceRemarkDTO.getDescription());
			}
		}
		
	}
}
