/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IRejectionHistoryRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ClaimRejectionHistoryResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class RejectionHistoryServiceImplTest extends AbstractClaimServiceImplTest {
	
	private static final Logger logger = LogManager.getLogger(RejectionHistoryServiceImplTest.class);

	@Mock
	private RejectionHistoryServiceImpl rejectionHistoryServiceImplMock;

	@Mock
	private IRejectionHistoryRepositoryTemplate iRejectionHistoryRepositoryTemplateMock;
	
	@Before
	public void setup() throws GenericException {
		rejectionHistoryServiceImplMock = new RejectionHistoryServiceImpl();
		iRejectionHistoryRepositoryTemplateMock = Mockito.mock(IRejectionHistoryRepositoryTemplate.class);
	}
	
	@Test
	public void testMockIsWorking() {
		assertNotNull("Rejection History Service Injection Failed", rejectionHistoryServiceImplMock);
		assertNotNull("Rejection History Service Repository Injection Failed", iRejectionHistoryRepositoryTemplateMock);
	}
	
	@Test
	public void testGetRejectionHistory_Sucess() {
		String claimQueueTypeCode = ClaimDetailsConstants.REJECTION_HISTORY_TAB; 
		Date dateCreated = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();
		List<ClaimRejectionHistoryResponse> rejectionHistoryResponseList = new ArrayList<ClaimRejectionHistoryResponse>();
		rejectionHistoryResponseList.add(new ClaimRejectionHistoryResponse(dateCreated, "Janiya Howe", "DESCRIPTION", "ZXC", "Janiya Howe", "ZXC", "ZXC"));
		rejectionHistoryResponseList.add(new ClaimRejectionHistoryResponse(dateCreated, "Tom Howe", "DESCRIPTION", "ABZ", "Tom Howe", "ABZ", "ABZ"));
		Mockito.when(iRejectionHistoryRepositoryTemplateMock.findRejectionHistory(claimQueueTypeCode, claim.getClaimIndex()))
		.thenReturn(rejectionHistoryResponseList);
		try {
			List<ClaimRejectionHistoryResponse> RejectionHistoryResponseResultSet = iRejectionHistoryRepositoryTemplateMock
					.findRejectionHistory(claimQueueTypeCode, claim.getClaimIndex());
			for (int i = 0; i < RejectionHistoryResponseResultSet.size(); i++) {
				assertEquals(RejectionHistoryResponseResultSet.get(i).getExplanation(),
						rejectionHistoryResponseList.get(i).getExplanation());
				assertEquals(RejectionHistoryResponseResultSet.get(i).getRejectedBy(),
						rejectionHistoryResponseList.get(i).getRejectedBy());
				assertEquals(RejectionHistoryResponseResultSet.get(i).getOutcome(),
						RejectionHistoryResponseResultSet.get(i).getOutcome());
				assertEquals(RejectionHistoryResponseResultSet.get(i), rejectionHistoryResponseList.get(i));
				assertThat(RejectionHistoryResponseResultSet.get(i), is(RejectionHistoryResponseResultSet.get(i)));
			}
			logger.info("test case passed");
		} catch (Exception e) {
			logger.info("Exception is: " + e);
		}
		
	}
}
