package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.dao.IReRoutingHistoryRepositoryTemplate;
import gov.va.med.fee.model.response.ReRoutingHistory;

/**
 * 
 * @author Muneshwar Baiah
 *
 */

@RunWith(MockitoJUnitRunner.class)
public class ReRoutingHistoryServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(ReRoutingHistoryServiceImplTest.class);

	@InjectMocks
	private ReRoutingHistoryServiceImpl reRoutingHistoryServiceImpl;
	
	@Mock
	private IReRoutingHistoryRepositoryTemplate iReRoutingHistoryRepositoryTemplateMock;

	@Test
	public void testMockIsWorking() {
		assertNotNull("Rerouting History Service Injection Failed",reRoutingHistoryServiceImpl );
		assertNotNull("Rerouting History Repository Injection Failed", iReRoutingHistoryRepositoryTemplateMock);
	}

	@Test
	public void testGetReRoutingHistoryDetails() {
		ReRoutingHistory reRoutingHistory = new ReRoutingHistory();
		reRoutingHistory.setDate("07/11/2017");
		reRoutingHistory.setExplanation("Routing the claim");
		StringBuilder transferredFrom = new StringBuilder();
		transferredFrom.append("VISN:01/FAC:station2/USER:VHAIS_USER2");
		StringBuilder transferredTo = new StringBuilder();
		transferredTo.append("VISN:00/FAC:100/USER:VHAIS_USER1");
		reRoutingHistory.setTransferredFrom(transferredFrom);
		reRoutingHistory.setTransferredTo(transferredTo);
		reRoutingHistory.setTransferredBy("CCSE");
		
		List<ReRoutingHistory> reRoutingHistoryList = new ArrayList<ReRoutingHistory>();
		reRoutingHistoryList.add(reRoutingHistory);
		Mockito.when(iReRoutingHistoryRepositoryTemplateMock.findReRoutingHistory(999L)).thenReturn(reRoutingHistoryList);

		try {
			List<ReRoutingHistory> resultSet = reRoutingHistoryServiceImpl.getReRoutingHistoryDetails(claim);
			assertEquals(reRoutingHistoryList, resultSet);
			logger.info("ReRoutingHistoryServiceImplTest.testGetReRoutingHistoryDetails() passed with no exceptions");
		} catch (Exception e) {
			logger.info("ReRoutingHistoryServiceImplTest.testGetReRoutingHistoryDetails() exception is: " + e);
		}

	}
}
