/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.ClaimProcedure;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.fee.dao.IPayToAndServiceProviderRepository;
import gov.va.med.fee.exceptions.GenericException;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class PayToProviderServiceImplTest extends AbstractClaimServiceImplTest {

	@Mock
	private ProviderInfoServiceImpl payToProviderServiceImplMock;

	@Mock
	private IPayToAndServiceProviderRepository iPayToProviderRepositoryMock;

	@Before
	public void setup() throws GenericException {
		payToProviderServiceImplMock = new ProviderInfoServiceImpl();

		iPayToProviderRepositoryMock = Mockito.mock(IPayToAndServiceProviderRepository.class);
		payToProviderServiceImplMock.setPayToAndServiceProvideRepository(iPayToProviderRepositoryMock);
	}

	@Test
	public void testMockIsWorking() {
		assertNotNull("Pay To Provider Service Injection Failed", payToProviderServiceImplMock);
		assertNotNull("IPayToProviderRepository Injection Failed", iPayToProviderRepositoryMock);
	}
	
	//Refactored by Eyuel Taddese 6/19/2017
	/**
	 * @author DNS   TADDEE
	 * The test make sure that payToProviderInfo is returning the 
	 */
	@Test
	public void testGetPayToProviderInfo_Sucess() {
		// Setup
		/*Date serviceDate = new GregorianCalendar(2009, Calendar.JANUARY, 22).getTime();
		Date visinCreateDate = new GregorianCalendar(2000, Calendar.MARCH, 30).getTime();
		Date providerCreatedDate = new GregorianCalendar(2000, Calendar.MAY, 30).getTime();
		//Date bankCreatedDate = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();
		Date dateCreated = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();

		ServiceType serviceType = new ServiceType("PROF", serviceDate, "User1");
		Visn visn = new Visn(Long.valueOf(1000), "User1", visinCreateDate);
		Claim claim = new Claim(Long.valueOf(9999), serviceType, visn, "C001", 'T');*/
		
		ProviderType providerType = new ProviderType("PAY TO PROVIDER", providerCreatedDate, "VA");
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		ProviderInfo providerInfo = new ProviderInfo(Long.valueOf(1000), claim, claimProcedure, providerType,
				"VA USA", "VA USA", "VA USA", "Doe", "John", "johnny", "jr.", "Sarno Plaza", "Sarno Road", "Melbourne",
				"Florida", "32935", "John Doe", "9999999999", "912345678", "john.doe@DOMAIN", Long.valueOf(1000), dateCreated, "VA USA");
		
		/*List<ProviderInfo> payToProviders = new ArrayList<>();
		payToProviders.add(providerInfo);*/

		Mockito.when(iPayToProviderRepositoryMock.findOneByType(claim.getClaimIndex(), "PAY TO PROVIDER"))
				.thenReturn(providerInfo);
		try {
			ProviderInfo resultSet = payToProviderServiceImplMock.getPayToAndServiceInfo(claim.getClaimIndex(), "PAY TO PROVIDER");
			assertThat(providerInfo, is(resultSet));
		} catch (Exception e) {
			Assert.fail("Test case failed due to "+e.getMessage());
		}
	}
	
}
