package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.ClaimOhi;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.OhiInfoResponse;

@RunWith(MockitoJUnitRunner.class)
public class OhiServiceImplTest extends AbstractClaimServiceImplTest {
	
	@InjectMocks
	private OhiServiceImpl ohiServiceImplMock;
	
	@Test
	public void testGetOhiInfo() throws GenericException {
		Set<ClaimOhi> claimOhis = new HashSet<ClaimOhi>();
		ClaimOhi claimOhi = new ClaimOhi();
		claimOhi.setOtherPayerName("Payer1.114");
		claimOhi.setOhiGroupName("114A Insurance Corp");		
		claimOhis.add(claimOhi);
		claim.setClaimOhis(claimOhis);
		
		List<OhiInfoResponse> ohiResponse = ohiServiceImplMock.getOhiInfo(claim);
		assertEquals(ohiResponse.get(0).getPayerName(), "Payer1.114");
	}
	
	@Test
	public void testGetOhiInfo_sorted_by_SequenceIndicator() throws GenericException {
		Set<ClaimOhi> claimOhis = new HashSet<ClaimOhi>();
		ClaimOhi claimOhi1 = new ClaimOhi();
		claimOhi1.setOtherPayerName("Payer 3");
		claimOhi1.setOhiGroupName("114A Insurance Corp");
		claimOhi1.setPaymentSequenceIndicator("T");
		
		ClaimOhi claimOhi2 = new ClaimOhi();
		claimOhi2.setOtherPayerName("Payer 1");
		claimOhi2.setOhiGroupName("119A Insurance Corp");
		claimOhi2.setPaymentSequenceIndicator("P");
		
		ClaimOhi claimOhi3 = new ClaimOhi();
		claimOhi3.setOtherPayerName("Payer 2");
		claimOhi3.setOhiGroupName("117A Insurance Corp");
		claimOhi3.setPaymentSequenceIndicator("S");
		
		claimOhis.add(claimOhi1);
		claimOhis.add(claimOhi2);
		claimOhis.add(claimOhi3);
		claim.setClaimOhis(claimOhis);
		
		List<OhiInfoResponse> ohiResponse = ohiServiceImplMock.getOhiInfo(claim);
		assertEquals(ohiResponse.get(0).getPayerName(), "Payer 1");
		assertEquals(ohiResponse.get(1).getPayerName(), "Payer 2");
		assertEquals(ohiResponse.get(2).getPayerName(), "Payer 3");		
	}
	
	@Test
	public void testGetOhiInfo_retrieve_only_first_four_payers() throws GenericException {
		Set<ClaimOhi> claimOhis = new HashSet<ClaimOhi>();
		ClaimOhi claimOhi1 = new ClaimOhi();
		claimOhi1.setOtherPayerName("Payer 3");
		claimOhi1.setPaymentSequenceIndicator("T");
		
		ClaimOhi claimOhi2 = new ClaimOhi();
		claimOhi2.setOtherPayerName("Payer 1");
		claimOhi2.setPaymentSequenceIndicator("P");
		
		ClaimOhi claimOhi3 = new ClaimOhi();
		claimOhi3.setOtherPayerName("Payer 2");
		claimOhi3.setPaymentSequenceIndicator("S");
		
		ClaimOhi claimOhi4 = new ClaimOhi();
		claimOhi4.setOtherPayerName("Payer 5");
		claimOhi4.setPaymentSequenceIndicator("B");
		
		ClaimOhi claimOhi5 = new ClaimOhi();
		claimOhi5.setOtherPayerName("Payer 4");
		claimOhi5.setPaymentSequenceIndicator("A");
		
		claimOhis.add(claimOhi1);
		claimOhis.add(claimOhi2);
		claimOhis.add(claimOhi3);
		claimOhis.add(claimOhi4);
		claimOhis.add(claimOhi5);
		claim.setClaimOhis(claimOhis);
		
		List<OhiInfoResponse> ohiResponse = ohiServiceImplMock.getOhiInfo(claim);
		assertEquals(ohiResponse.size(), 4);	
		assertEquals(ohiResponse.get(0).getPayerName(), "Payer 1");
		assertEquals(ohiResponse.get(3).getPayerName(), "Payer 4");
	}
}