package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.context.ActiveProfiles;

import gov.va.med.domain.fee.ClaimProcedure;
import gov.va.med.domain.fee.PersonInfo;
import gov.va.med.domain.fee.PersonType;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.domain.fee.ServiceType;
import gov.va.med.fee.dao.IAdjustmentGroupRepository;
import gov.va.med.fee.dao.IAdjustmentReasonRepository;
import gov.va.med.fee.dao.ICalcMethodRepository;
import gov.va.med.fee.dao.IClaimPaymentRepository;
import gov.va.med.fee.dao.IClaimPaymentTypeRepository;
import gov.va.med.fee.dao.IClaimProcReconRepository;
import gov.va.med.fee.dao.IClaimProcRemitRemarkRepository;
import gov.va.med.fee.dao.IClaimProcStatusRepository;
import gov.va.med.fee.dao.IClaimProcedureRepository;
import gov.va.med.fee.dao.IClaimReconciliationRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IWsFacStatusRepository;
import gov.va.med.fee.errorhandling.ValidationMessage;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.exceptions.ValidationException;
import gov.va.med.fee.model.request.AdjustmentRequest;
import gov.va.med.fee.model.request.ManualReconRequest;
import gov.va.med.fee.model.response.ClaimLineItems;
import gov.va.med.fee.model.response.ManualReconResponse;
import gov.va.med.fee.service.IClaimService;

@RunWith(MockitoJUnitRunner.class)
@ActiveProfiles("dev")
public class ManualReconClaimServiceImplTest extends AbstractClaimServiceImplTest {
	
	private static final Logger logger = LogManager.getLogger(ManualReconClaimServiceImplTest.class);
	
	@InjectMocks
	ManualReconClaimServiceImpl manualReconClaimService;
	
	@Mock
	IClaimService claimService;
	
	@Mock
	IClaimRepository claimRepository;
	
	@Mock
	ServiceType serviceType;
	ClaimLineItems claimLineItems;

	@Mock
	IClaimProcedureRepository claimProcedureRepository;

	@Mock
	ICalcMethodRepository calcMethodRepository;

	@Mock
	IClaimReconciliationRepository claimReconciliationRepository;

	@Mock
	IClaimPaymentTypeRepository claimPaymentTypeRepository;

	@Mock
	IClaimPaymentRepository claimPaymentRepository;

	@Mock
	IClaimProcStatusRepository claimProcStatusRepository;

	@Mock
	IClaimProcReconRepository claimProcReconRepository;

	@Mock
	IAdjustmentGroupRepository adjustmentGroupRepository;

	@Mock
	IAdjustmentReasonRepository adjustmentReasonRepository;

	@Mock
	IClaimProcRemitRemarkRepository claimProcRemitRemarkRepository;

	@Mock
	IWsFacStatusRepository wsFacStatusRepository;
	
	@Before
	public void init() throws Exception {
		super.init();
		ServiceType serviceType = new ServiceType();
		serviceType.setServiceTypeCd("PROF");
		claim.setServiceType(serviceType);
		
		Set<PersonInfo> persons = new HashSet<PersonInfo>();
				
		PersonInfo personInfo1 = new PersonInfo();
		PersonType pt = new PersonType();
		pt.setPersonTypeCd("PATIENT");
		personInfo1.setPersonType(pt);
		personInfo1.setFirstName("PatientFirst");
		personInfo1.setLastName("PatientLast");
		persons.add(personInfo1);
		
		Set<ProviderInfo> providerInfos = new HashSet<ProviderInfo>();
		
		ProviderInfo providerInfo = new ProviderInfo();
		ProviderType providerType = new ProviderType();
		providerType.setProviderTypeCd("BILLING PROVIDER");
		providerInfo.setProviderType(providerType);
		providerInfo.setFirstName("BPFirst");
		providerInfo.setLastName("BPLast");
		providerInfos.add(providerInfo);
		
		providerInfo = new ProviderInfo();
		providerType = new ProviderType();
		providerType.setProviderTypeCd("SERVICE FACILITY");
		providerInfo.setProviderType(providerType);
		providerInfo.setFirstName("SFFirst");
		providerInfo.setLastName("SFLast");
		providerInfos.add(providerInfo);
		
		
		claim.setPersonInfos(persons);	
		claim.setProviderInfos(providerInfos);
		
		claimLineItems = new ClaimLineItems();
	}
	

	
	@Test
	public void test_getClaimDetails() {
		logger.info("test_getClaimDetails");
		long claimId = 999L;
		ManualReconResponse manualReconResponse = null;
		try {
			Mockito.when(claimRepository.findClaimStatusByClaimIndex(claimId)).thenReturn(claim);
			Mockito.when(claimService.getClaimLineItems(claimId)).thenReturn(claimLineItems);
			
			manualReconResponse = manualReconClaimService.getClaimDetails(claimId);
			
		} catch (GenericException e) {
			e.printStackTrace();
		}
		assertEquals(manualReconResponse.getClaimId(), claimId);
		assertEquals(manualReconResponse.getClaimType(), "PROF");
		assertEquals(manualReconResponse.getClaimStatus(), "INPROCESS");
		assertEquals(manualReconResponse.getVeteranName(), "PatientFirst PatientLast");
		assertEquals(manualReconResponse.getBillingProvName(), "BPLast");
		assertEquals(manualReconResponse.getServiceProvName(), "SFLast");
	}
	
	@Test
	public void test_submitManualRecon() {
		logger.info("test_submitManualRecon");
		long claimId = 999L;
		ManualReconResponse manualReconResponse = null;
		ManualReconRequest manualReconRequest = new ManualReconRequest();
		manualReconRequest.setClaimIndex(claimId);
		manualReconRequest.setClaimProcId(109L);
		List<AdjustmentRequest> adjustments = new ArrayList<>();
		
		AdjustmentRequest adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("10.23"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("60");
		String[] rARCs1 = {"M90"};
		adjustmentRequest.setRARCs(rARCs1);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("9.35"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("61");
		String[] rARCs2 = {"M91"};
		adjustmentRequest.setRARCs(rARCs2);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("8.42"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("62");
		String[] rARCs3 = {"M92"};
		adjustmentRequest.setRARCs(rARCs3);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("7.79"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("63");
		String[] rARCs4 = {"M93"};
		adjustmentRequest.setRARCs(rARCs4);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("59.87"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("64");
		String[] rARCs5 = {"M94"};
		adjustmentRequest.setRARCs(rARCs5);
		adjustments.add(adjustmentRequest);
		
		manualReconRequest.setAdjustments(adjustments);
		manualReconRequest.setPaymentDate(new Date());
		manualReconRequest.setVaAmount(new BigDecimal("12.34"));
		manualReconRequest.setCheckNo("1234");
		manualReconRequest.setPaymentType("CHECK");
		manualReconRequest.setUserName("SOAPUI Test User");
		
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		claimProcedure.setBilledAmount(new BigDecimal("108.00"));
		
		try {
			Mockito.when(claimRepository.findByClaimIndex(manualReconRequest.getClaimIndex())).thenReturn(claim);
			Mockito.when(claimProcedureRepository.findOne(manualReconRequest.getClaimProcId())).thenReturn(claimProcedure);
			Mockito.when(claimRepository.findClaimStatusByClaimIndex(claimId)).thenReturn(claim);
			Mockito.when(claimService.getClaimLineItems(claimId)).thenReturn(claimLineItems);
			
			manualReconResponse = manualReconClaimService.submitManualRecon(manualReconRequest);
			
		} catch (GenericException e) {
			e.printStackTrace();
		} catch (ValidationException e) {
			e.printStackTrace();
		}
		assertEquals(manualReconResponse.getClaimId(), claimId);
		assertEquals(manualReconResponse.getClaimType(), "PROF");
		assertEquals(manualReconResponse.getClaimStatus(), "INPROCESS");
		assertEquals(manualReconResponse.getVeteranName(), "PatientFirst PatientLast");
		assertEquals(manualReconResponse.getBillingProvName(), "BPLast");
		assertEquals(manualReconResponse.getServiceProvName(), "SFLast");
	}
	
	@SuppressWarnings("deprecation")
	@Test
	public void test_submitManualRecon_Fail() {
		logger.info("test_submitManualRecon_Fail");
		long claimId = 999L;
		
		ManualReconRequest manualReconRequest = new ManualReconRequest();
		manualReconRequest.setClaimIndex(claimId);
		manualReconRequest.setClaimProcId(109L);
		List<AdjustmentRequest> adjustments = new ArrayList<>();
		
		AdjustmentRequest adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("10.23"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("60");
		String[] rARCs1 = {"M90"};
		adjustmentRequest.setRARCs(rARCs1);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("9.35"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("61");
		String[] rARCs2 = {"M91"};
		adjustmentRequest.setRARCs(rARCs2);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("8.42"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("62");
		String[] rARCs3 = {"M92"};
		adjustmentRequest.setRARCs(rARCs3);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("7.79"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("63");
		String[] rARCs4 = {"M93"};
		adjustmentRequest.setRARCs(rARCs4);
		adjustments.add(adjustmentRequest);
		
		adjustmentRequest = new AdjustmentRequest();
		adjustmentRequest.setAmount(new BigDecimal("59.87"));
		adjustmentRequest.setGroupCode("CO");
		adjustmentRequest.setCARC("64");
		String[] rARCs5 = {"M94"};
		adjustmentRequest.setRARCs(rARCs5);
		adjustments.add(adjustmentRequest);
		
		manualReconRequest.setAdjustments(adjustments);
		manualReconRequest.setPaymentDate(new Date("October 13, 1899 11:13:00"));
		manualReconRequest.setVaAmount(new BigDecimal("12.34"));
		manualReconRequest.setCheckNo("1234");
		manualReconRequest.setPaymentType("CHECK");
		manualReconRequest.setUserName("SOAPUI Test User");
		
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		claimProcedure.setBilledAmount(new BigDecimal("200.00"));
		
		try {
			Mockito.when(claimRepository.findByClaimIndex(manualReconRequest.getClaimIndex())).thenReturn(claim);
			Mockito.when(claimProcedureRepository.findOne(manualReconRequest.getClaimProcId())).thenReturn(claimProcedure);
			Mockito.when(claimRepository.findClaimStatusByClaimIndex(claimId)).thenReturn(claim);
			Mockito.when(claimService.getClaimLineItems(claimId)).thenReturn(claimLineItems);
			
			manualReconClaimService.submitManualRecon(manualReconRequest);
			
		} catch (GenericException e) {
			e.printStackTrace();
		} catch (ValidationException e) {
			for(ValidationMessage validationMessage:e.getValidationMessages()) {
				assertEquals(validationMessage.getErrorCode(), "ERR");
				assertTrue((validationMessage.getEntity().equals("adjAmount1")) || (validationMessage.getEntity().equals("paymentBatchDate")));
			}
		}

	}	
}
