package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.dao.ILineItemsRepositoryTemplate;
import gov.va.med.fee.model.request.LineItemsRequest;
import gov.va.med.fee.model.request.SeqDetailRequest;
import gov.va.med.fee.model.response.LineItemResponse;

@RunWith(MockitoJUnitRunner.class)
public class LineItemsServiceImplTest extends AbstractClaimServiceImplTest {
	private static final Logger logger = LogManager.getLogger(LineItemsServiceImplTest.class);
	
	@InjectMocks
	private LineItemsServiceImpl lineItemsServiceImplMock;
	
	@Mock
	ILineItemsRepositoryTemplate iLineItemsRepositoryTemplate;
	
	@Test
	public void testGetClaimLineItems() {
		BigDecimal claimProcId = new BigDecimal(104);
		String revenueCode = null;
		String procCodeDesc = "";
		String diagPointer = null;
		BigDecimal billedUnits = new BigDecimal(0);
		String modifier1 = null;
		String modifier2 = null;
		String modifier3 = null;
		String modifier4 = null;
		
		String toothCode = null;
		String toothSurface = null;
		String toothSurfaceCd2 = null;
		String toothSurfaceCd3 = null;
		String toothSurfaceCd4 = null;
		String toothSurfaceCd5 = null;
		String oralCavityCd = null;
		
		BigDecimal claimProcedureSequence = new BigDecimal(1234567);
		String procCode = "Test103";	
		
		if("INST".equalsIgnoreCase(claim.getServiceType().getServiceTypeCd())) {
			revenueCode = "Test103";
		}
		DecimalFormat df = new DecimalFormat("$#0.00");
		Timestamp serviceFromDate = new Timestamp(new Date().getTime());
		Timestamp serviceToDate = new Timestamp(new Date().getTime());
		String billedAmount = df.format(new BigDecimal(100));
		
		if("PROF".equalsIgnoreCase(claim.getServiceType().getServiceTypeCd())) {
			procCodeDesc = "test103";
			diagPointer = "test103";
			modifier1 = "test";
			modifier2 = "test";
			modifier3 = "test";
			modifier4 = "test";
			billedUnits = new BigDecimal(100);
		}
		
		if("DENT".equalsIgnoreCase(claim.getServiceType().getServiceTypeCd())) {
			toothCode = "test103";
			toothSurface = "test103";
			toothSurfaceCd2 = "test103";
			toothSurfaceCd3 = "test103";
			toothSurfaceCd4 = "test103";
			toothSurfaceCd5 = "test103";
			oralCavityCd = "test103";
		}
		
		Timestamp paymentDate = new Timestamp(new Date().getTime());
		BigDecimal paidAmount = new BigDecimal(100);
		BigDecimal ba = new BigDecimal(100);
		String paymentTrackingnumber = "1234567";
		String lineStatus = "test103";

		LineItemsRequest req = new LineItemsRequest(claimProcedureSequence, procCode, revenueCode, serviceFromDate,
				serviceToDate, ba, procCodeDesc, diagPointer, billedUnits,
				modifier1, modifier2, modifier3, modifier4, paymentDate,
				paidAmount, paymentTrackingnumber, toothCode, toothSurface,
				toothSurfaceCd2, toothSurfaceCd3, toothSurfaceCd4, toothSurfaceCd5,
				oralCavityCd, lineStatus);
		req.setClaimProcId(claimProcId);
		System.out.println("LineItemsRequest is: " + req);
		
		List<LineItemsRequest> lineItemsRequests = new ArrayList<LineItemsRequest>();
		lineItemsRequests.add(req);
		
		Mockito.when(iClaimRepositoryMock.findClaimByClaimIndex(Long.valueOf(101))).thenReturn(claim);
		

		List<SeqDetailRequest> reqs = new ArrayList<>();
		SeqDetailRequest seqDetail = new SeqDetailRequest(Long.valueOf(1234567), "97", Long.valueOf(0), Long.valueOf(10), "0A", "E123");
		
		Mockito.when(iLineItemsRepositoryTemplate.getCARCDetail(1234567, Long.valueOf(999))).thenReturn(seqDetail);
		reqs.add(seqDetail);
		
		Mockito.when(iLineItemsRepositoryTemplate.getCAGCDetail(1234567, Long.valueOf(999))).thenReturn(reqs);//seqDetail);
		Mockito.when(iLineItemsRepositoryTemplate.getRARCDetail(1234567, Long.valueOf(999))).thenReturn(reqs);//seqDetail);
		
		//Mockito.when(iLineItemsRepositoryTemplate.findLineItemsInfo(Long.valueOf(101))).thenReturn(lineItemsRequests);
		Mockito.when(iLineItemsRepositoryTemplate.findLineItemsInfo(999L)).thenReturn(lineItemsRequests);
		
		try {
			List <LineItemResponse> resultSet = lineItemsServiceImplMock.getClaimLineItems(claim);
						
			//1234567	97	0	10
			SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
			String lineItemTreasuryPaymentDateFormatted = formatter.format(paymentDate);
			String lineItemPaidAmountFormatted = "$10.00"; 
			String lineItemCheckNumber = "1234567"; 
			String lineItemAdjAmts = "$0.00";
			String lineItemCodes = "97";
			String lineItemCagcCodes="0A";
			String lineItemRarcCodes="E123";
			
			Long bu = billedUnits == null? null : billedUnits.longValue(); 
			List<LineItemResponse> lineItemResponses = new ArrayList<>();
			LineItemResponse newReqponse = new LineItemResponse(claimProcedureSequence.longValue(), toothCode, toothSurface, toothSurfaceCd2,
					toothSurfaceCd3, toothSurfaceCd4, toothSurfaceCd5, procCode, revenueCode,
					procCodeDesc, diagPointer, formatter.format(serviceFromDate), formatter.format(serviceToDate),
					billedAmount, bu, modifier1, modifier2, modifier3,
					modifier4, lineStatus, lineItemTreasuryPaymentDateFormatted,
					lineItemPaidAmountFormatted, lineItemCheckNumber, lineItemAdjAmts,
					lineItemCodes, lineItemCagcCodes, lineItemRarcCodes);
			
			lineItemResponses.add(newReqponse);
			
			for(int i = 0; i < resultSet.size(); i++) {
				logger.info(" resultSet.get("+i+") is "+resultSet.get(i) );
				logger.info(" lineItemResponses.get("+i+") is "+lineItemResponses.get(i) );
				assertEquals(resultSet.get(i), lineItemResponses.get(i));
			}
			logger.info("Test case passed with no exceptions");

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testGetCARCDetail() {
		final String COMMA = ", ";
		DecimalFormat df = new DecimalFormat("$#0.00");
		
		SeqDetailRequest seqDetail = new SeqDetailRequest(Long.valueOf(1234567), "97", Long.valueOf(0), Long.valueOf(10), "A", "B");
		Mockito.when(iLineItemsRepositoryTemplate.getCARCDetail(1234567, 101L)).thenReturn(seqDetail);
		
		List<String> list = new ArrayList<>();
				
		list.add("97, "); // sbCodes is StringBuffer
		list.add(df.format(0) + COMMA);
		list.add(df.format(10));
		
		try {
			List <String> resultSet = lineItemsServiceImplMock.getCARCDetail(1234567, 101L);
			for(int i = 0; i < resultSet.size(); i++) {
				assertEquals(resultSet.get(i), list.get(i));
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testGetCAGCDetail() {
		final String COMMA = ", ";
		List<String> list = new ArrayList<>();
		
		List<SeqDetailRequest> reqs = new ArrayList<>();
		SeqDetailRequest seqDetail = new SeqDetailRequest(Long.valueOf(1234567), "97", Long.valueOf(0), Long.valueOf(10), "A", "B");
		reqs.add(seqDetail);
		Mockito.when(iLineItemsRepositoryTemplate.getCAGCDetail(1234567, Long.valueOf(101))).thenReturn(reqs);//seqDetail);
				
		list.add("A" + COMMA);
		
		try {
			List <String> resultSet = lineItemsServiceImplMock.getCAGCDetail(1234567, 101L);
			for(int i = 0; i < resultSet.size(); i++) {
				System.out.println("LineItemsServiceImpl.getCAGCDetail() -- " + resultSet.toString());
				assertEquals(resultSet.get(i), list.get(i));
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testGetRARCDetail() {
		final String COMMA = ", ";
		List<String> list = new ArrayList<>();
		
		List<SeqDetailRequest> reqs = new ArrayList<>();
		SeqDetailRequest seqDetail = new SeqDetailRequest(Long.valueOf(1234567), "97", Long.valueOf(0), Long.valueOf(10), "A", "B");
		reqs.add(seqDetail);
		Mockito.when(iLineItemsRepositoryTemplate.getRARCDetail(1234567, Long.valueOf(101))).thenReturn(reqs);//seqDetail);
						
		list.add("B" + COMMA);
		
		try {
			List <String> resultSet = lineItemsServiceImplMock.getRARCDetail(1234567, 101L);
			for(int i = 0; i < resultSet.size(); i++) {
				System.out.println("LineItemsServiceImpl.getRARCDetail() -- " + resultSet.toString());
				assertEquals(resultSet.get(i), list.get(i));
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
