package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.dao.IAdjustmentGroupRepository;
import gov.va.med.fee.dao.IAdjustmentReasonRepository;
import gov.va.med.fee.dao.ICalcMethodRepository;
import gov.va.med.fee.dao.IClaimByStatusCodeRepository;
import gov.va.med.fee.dao.IClaimPaymentTypeRepository;
import gov.va.med.fee.dao.IClaimProcStatusRepository;
import gov.va.med.fee.dao.IClaimProcedureRepository;
import gov.va.med.fee.dao.IClaimQueueRepository;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IDisapproveClaimRepository;
import gov.va.med.fee.dao.IRejectedClaimRepository;
import gov.va.med.fee.dao.IRemittanceRemarkRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.RejectedClaimRequest;
import gov.va.med.fee.model.response.AdjustmentReasonResponse;
import gov.va.med.fee.model.response.DisapproveClaimsPage;
import gov.va.med.fee.model.response.DisapproveClaimsReason;

@RunWith(MockitoJUnitRunner.class)
public class DisapproveServiceImplTest extends AbstractClaimServiceImplTest  {
	
	
	private static final Logger logger = LogManager.getLogger(DiagnosisCodeServiceImplTest.class);
	
	@InjectMocks
	DisapproveServiceImpl disapproveMockService;
	
	@Mock
	IDisapproveClaimRepository disapproveRepository;
	
	@Mock
	IClaimRepository iClaimRepositoryMock;
	
	@Mock
	IDisapproveClaimRepository iDisClaimRepository;

	@Mock
	IClaimRepository claimRepository;
	
	@Mock
	IClaimByStatusCodeRepository claimByStatusCodeRepository;

	@Mock
	IRejectedClaimRepository rejectedClaimRepository;
	
	@Mock
	IClaimQueueRepository claimQueueRepository;
	
	@Mock
	IClaimPaymentTypeRepository claimPaymentTypeRepository;
	
	@Mock
	ICalcMethodRepository calcMethodRepository;
	
	@Mock
	IClaimProcedureRepository claimProcedureRepository;
	
	@Mock
	IClaimProcStatusRepository claimProcStatusRepository;
	
	@Mock
	IAdjustmentGroupRepository adjustmentGroupRepository;
	
	@Mock
	IAdjustmentReasonRepository adjustmentReasonRepository;
	
	@Mock
	IRemittanceRemarkRepository remittanceRemarkRepository;
	
	@Test
	public void Test_populateAdjustmentReasonsSuccess() {
		List<DisapproveClaimsReason> mockReasonCodes = new LinkedList<DisapproveClaimsReason>();
		
		final Date dateCreated = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();
		
		DisapproveClaimsPage reasonCodesfrmServiceCall = new DisapproveClaimsPage();
		
		List<AdjustmentReasonResponse> adjustmentReasonResponse = new LinkedList<AdjustmentReasonResponse>();
		AdjustmentReasonResponse adjustmentReasonResponse2 = new AdjustmentReasonResponse("123", "Test123", 'Y', "", dateCreated, 'Y');
		adjustmentReasonResponse.add(adjustmentReasonResponse2);
		
		DisapproveClaimsReason disapproveClaimsReasonMock = new DisapproveClaimsReason("123", "Test123");
		mockReasonCodes.add(disapproveClaimsReasonMock);
		
		Mockito.when(disapproveRepository.populateAdjustmentReasons()).thenReturn(adjustmentReasonResponse);
		
		//List<String> reasonCodesfrmServiceCall = new LinkedList<String>();
		try {			
			reasonCodesfrmServiceCall = disapproveMockService.populateAdjustmentReasons();
			for(int i = 0; i<reasonCodesfrmServiceCall.getDisapproveClaimsReasons().size(); i++){
				assertEquals(mockReasonCodes.get(i).getClaimReasons(), reasonCodesfrmServiceCall.getDisapproveClaimsReasons().get(i).getClaimReasons());
			}
			assertNotNull(Arrays.asList(reasonCodesfrmServiceCall).containsAll(adjustmentReasonResponse));
			logger.info("Test case passed with no exceptions");
			
		} catch (Exception e) {			
			e.printStackTrace();
		}
	}
	
	
	//Needs to be developed
/*	
	@Test
	public void Test_populateDisapproveClaimsSuccess() {
		
		ProviderType providerType = new ProviderType("BILLING PROVIDER", providerCreatedDate, "VA");
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		ProviderInfo providerInfo = new ProviderInfo(Long.valueOf(1000), claim, claimProcedure, providerType,
				"VA USA", "VA USA", "VA USA", "Doe", "John", "johnny", "jr.", "Sarno Plaza", "Sarno Road", "Melbourne",
				"Florida", "32935", "John Doe", "9999999999", "912345678", "john.doe@DOMAIN", Long.valueOf(1000), dateCreated, "VA USA");
		
		Mockito.when(iClaimRepositoryMock.findClaimStatusByClaimIndex(claim.getClaimIndex())).thenReturn(claim);
		
		
		
	}*/
	
	/*@Test
	public void test_getClaimsToDisapprove() throws GenericException {

		DisapproveClaimsPage disapproveClaimsPage = new DisapproveClaimsPage();
		
		ClaimsToDisapprove claimsToDisapprove = new ClaimsToDisapprove();
		claimsToDisapprove.setVeteranName("DOMINIQUE RODGERS-CROMARTIE");
		
		List<ClaimsToDisapprove> claimsToDisapproveList = new ArrayList<ClaimsToDisapprove>();
		claimsToDisapproveList.add(claimsToDisapprove);
		disapproveClaimsPage.setClaimsToDisapprove(claimsToDisapproveList);
		
		Claim claimToPass = new Claim();
		claimToPass.setClaimStatusCd("ESTABLISH");
		
		ProviderInfo providerInfo = new ProviderInfo();
		
		ProviderType providerType = new ProviderType();
		providerType.setProviderTypeCd("BILLING PROVIDER");
		
		
		providerInfo.setProviderType(providerType);
		
		providerInfo.setLastName("GENERAL MEMORIAL HOSPITAL");
		
		Set<ProviderInfo> providerInfoSet = new HashSet<ProviderInfo>();
		claimToPass.setProviderInfos(providerInfoSet);
		
		PersonInfo personInfo = new PersonInfo();
		personInfo.setFirstName("DOMINIQUE");
		personInfo.setLastName("RODGERS-CROMARTIE");
		
		PersonType personType = new PersonType();
		personType.setPersonTypeCd("PATIENT");
		personInfo.setPersonType(personType);
		
		Set<PersonInfo> personInfos = new HashSet<PersonInfo>();
		personInfos.add(personInfo);
		claimToPass.setPersonInfos(personInfos);
		
		BigDecimal count = new BigDecimal(1);

		List<Long> claimIds = new ArrayList<Long>();
		claimIds.add(999999L);
		
		Mockito.when(disapproveRepository.getCount(999999L)).thenReturn(count);
		Mockito.when(iClaimRepositoryMock.findClaimStatusByClaimIndex(999999L)).thenReturn(claim);
				
		Mockito.when(disapproveMockService.getClaimsToDisapprove(claimIds)).thenReturn(disapproveClaimsPage);
		
		try {
			disapproveClaimsPage = disapproveMockService.getClaimsToDisapprove(claimIds);
			assertEquals(disapproveClaimsPage.getClaimsToDisapprove().get(0).getVeteranName(), "DOMINIQUE RODGERS-CROMARTIE");
		} catch (GenericException e) {
			logger.info("Test case passed with no exceptions");
			e.printStackTrace();
		}
	}
	*/
	@Test
	public void test_okDisapprovals() {
	
		List<RejectedClaimRequest> rejectedClaimRequestList = new ArrayList<RejectedClaimRequest>();
		RejectedClaimRequest rejectedClaimRequest = new RejectedClaimRequest();
		rejectedClaimRequest.setClaimId(999997L);
		rejectedClaimRequest.setReviewersComments("Test1 Comments");
		rejectedClaimRequestList.add(rejectedClaimRequest);
		
		String userName = "TestUser";
		
		boolean isSuccess = false;
		try {
			isSuccess = disapproveMockService.okDisapprovals(rejectedClaimRequestList, userName);
		} catch (GenericException e) {
			e.printStackTrace();
		}
		assertEquals(isSuccess, true);
	}
	
	@Test
	public void test_reverseDisapprovals() {
	
		List<RejectedClaimRequest> rejectedClaimRequestList = new ArrayList<RejectedClaimRequest>();
		RejectedClaimRequest rejectedClaimRequest = new RejectedClaimRequest();
		rejectedClaimRequest.setClaimId(999998L);
		rejectedClaimRequest.setReviewersComments("Test1 Comments");
		rejectedClaimRequestList.add(rejectedClaimRequest);
		
		String userName = "TestUser";
		
		boolean isSuccess = false;
		try {
			isSuccess = disapproveMockService.reverseDisapprovals(rejectedClaimRequestList, userName);
		} catch (GenericException e) {
			e.printStackTrace();
		}
		assertEquals(isSuccess, true);
	}
}
