/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.HealthcareInfoCode;
import gov.va.med.fee.dao.IClaimRepository;
import gov.va.med.fee.dao.IDiagnosisCodeRepository;
import gov.va.med.fee.model.response.DiagnosisCodes;

/**
 * @author Vinod P
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class DiagnosisCodeServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(DiagnosisCodeServiceImplTest.class);

	@InjectMocks
	private DiagnosisCodeServiceImpl diagnosisCodeServiceImplMock;
	
	@Mock
	private IClaimRepository iClaimRepositoryMock;
	
	@Mock
	private IDiagnosisCodeRepository iDiagnosisCodeRepositoryMock;


	@Test
	public void testMockIsWorking() {
		assertNotNull("Diagnosis Code Service Injection Failed", diagnosisCodeServiceImplMock);
		assertNotNull("Diagnosis Code Repository Injection Failed", iDiagnosisCodeRepositoryMock);
	}

	@Test
	public void testGetDiagnosisCodeInfo() {
		
		long healthInfoCdId = 50884;
	    //claim.setPoaIndicator("POA123");
	    
	    String seqNbr = "20931";
	    String hi01cdListQual = "BK";
	    String hi01procCd = "250.63";
	    String hi01procDesc = "DM1 W NEURO MANIFEST UNC";
	    String hi01dttmQual = "BK";
	    String hi01procDt = "07102001";
	    BigDecimal hi01amount = new BigDecimal(0); 
	    String hi02cdListQual = "BK";
	    String hi02procCd = "BK";
	    String hi02procDesc = "BK";
	    String hi02dttmQual = "BK";
	    String hi02procDt = "07102001";
	    BigDecimal hi02amount = new BigDecimal(0);
	    String hi03cdListQual = "BK";
	    String hi03procCd = "BK";
	    String hi03procDesc = "BK";
	    String hi03dttmQual = "BK";
	    String hi03procDt = "A07102001";
	    BigDecimal hi03amount = new BigDecimal(0);
	    String hi04cdListQual = "ZZ";
	    String hi04procCd = "ZZ";
	    String hi04procDesc = "ZZ";
	    String hi04dttmQual = "ZZ";
	    String hi04procDt = "07102001";
	    BigDecimal hi04amount = new BigDecimal(0);
	    String hi05cdListQual = "BK";
	    String hi05procCd = "BK";
	    String hi05procDesc = "BK";
	    String hi05dttmQual = "BK";
	    String hi05procDt = "07102001";
	    BigDecimal hi05amount = new BigDecimal(0);
	    String hi06cdListQual = "BK";
	    String hi06procCd = "BK";
	    String hi06procDesc = "BK";
	    String hi06dttmQual = "BK";
	    String hi06procDt = "07102001";
	    BigDecimal hi06amount = new BigDecimal(0);
	    String hi07cdListQual = "BK";
	    String hi07procCd = "BK";
	    String hi07procDesc = "BK";
	    String hi07dttmQual = "BK";
	    String hi07procDt = "07102001";
	    BigDecimal hi07amount = new BigDecimal(0);
	    String hi08cdListQual = "BK";
	    String hi08procCd = "BK";
	    String hi08procDesc = "BK";
	    String hi08dttmQual = "BK";
	    String hi08procDt = "07102001";
	    BigDecimal hi08amount = new BigDecimal(0);
	    String hi09cdListQual = "BK";
	    String hi09procCd = "BK";
	    String hi09procDesc = "BK";
	    String hi09dttmQual = "BK";
	    String hi09procDt = "07102001";
	    BigDecimal hi09amount = new BigDecimal(0);
	    String hi10cdListQual = "BK";
	    String hi10procCd = "BK";
	    String hi10procDesc = "BK";
	    String hi10dttmQual = "BK";
	    String hi10procDt = "07102001";
	    BigDecimal hi10amount = new BigDecimal(0);
	    String hi11cdListQual = "BK";
	    String hi11procCd = "BK";
	    String hi11procDesc = "BK";
	    String hi11dttmQual = "BK";
	    String hi11procDt = "07102001";
	    BigDecimal hi11amount = new BigDecimal(0);
	    String hi12cdListQual = "BK";
	    String hi12procCd = "BK";
	    String hi12procDesc = "BK";
	    String hi12dttmQual = "BK";
	    String hi12procDt = "07102001";
	    BigDecimal hi12amount = new BigDecimal(0);
	    String createdBy = "BK";
	    BigDecimal hi01qnty = new BigDecimal(0);
		String hi01versionId = "BK";
		String hi01indstryCd = "BK";
		String hi01cndtnResponseCd = "BK";
		BigDecimal hi02qnty = new BigDecimal(0);
		String hi02versionId = "BK";
		String hi02indstryCd = "BK";
		String hi02cndtnResponseCd = "BK";
		BigDecimal hi03qnty = new BigDecimal(0);
		String hi03versionId = "BK";
		String hi03indstryCd = "BK";
		String hi03cndtnResponseCd = "BK";
		BigDecimal hi04qnty = new BigDecimal(0);
		String hi04versionId = "BK";
		String hi04indstryCd = "BK";
		String hi04cndtnResponseCd = "BK";
		BigDecimal hi05qnty = new BigDecimal(0);
		String hi05versionId = "BK";
		String hi05indstryCd = "BK";
		String hi05cndtnResponseCd = "BK";
		BigDecimal hi06qnty = new BigDecimal(0);
		String hi06versionId = "BK";
		String hi06indstryCd = "BK";
		String hi06cndtnResponseCd = "BK";
		BigDecimal hi07qnty = new BigDecimal(0);
		String hi07versionId = "BK";
		String hi07indstryCd = "BK";
		String hi07cndtnResponseCd = "BK";
		BigDecimal hi08qnty = new BigDecimal(0);
		String hi08versionId = "BK";
		String hi08indstryCd = "BK";
		String hi08cndtnResponseCd = "BK";
		BigDecimal hi09qnty = new BigDecimal(0);
		String hi09versionId = "BK";
		String hi09indstryCd = "BK";
		String hi09cndtnResponseCd = "BK";
		BigDecimal hi10qnty = new BigDecimal(0);
		String hi10versionId = "BK";
		String hi10indstryCd = "BK";
		String hi10cndtnResponseCd = "BK";
		BigDecimal hi11qnty = new BigDecimal(0);
		String hi11versionId = "ZZ";
		String hi11indstryCd = "ZZ";
		String hi11cndtnResponseCd = "ZZ";
		BigDecimal hi12qnty = new BigDecimal(0);
		String hi12versionId = "ZZ";
		String hi12indstryCd = "ZZ";
		String hi12cndtnResponseCd = "ZZ";

		
		HealthcareInfoCode healthcareInfoCodeNew = new HealthcareInfoCode (healthInfoCdId, claim,
		        seqNbr, hi01cdListQual, hi01procCd,
		        hi01procDesc, hi01dttmQual, hi01procDt,
		        hi01amount, hi02cdListQual, hi02procCd,
		        hi02procDesc, hi02dttmQual, hi02procDt,
		        hi02amount, hi03cdListQual, hi03procCd,
		        hi03procDesc, hi03dttmQual, hi03procDt,
		        hi03amount, hi04cdListQual, hi04procCd,
		        hi04procDesc, hi04dttmQual, hi04procDt,
		        hi04amount, hi05cdListQual, hi05procCd,
		        hi05procDesc, hi05dttmQual, hi05procDt,
		        hi05amount, hi06cdListQual, hi06procCd,
		        hi06procDesc, hi06dttmQual, hi06procDt,
		        hi06amount, hi07cdListQual, hi07procCd,
		        hi07procDesc, hi07dttmQual, hi07procDt,
		        hi07amount, hi08cdListQual, hi08procCd,
		        hi08procDesc, hi08dttmQual, hi08procDt,
		        hi08amount, hi09cdListQual, hi09procCd,
		        hi09procDesc, hi09dttmQual, hi09procDt,
		        hi09amount, hi10cdListQual, hi10procCd,
		        hi10procDesc, hi10dttmQual, hi10procDt,
		        hi10amount, hi11cdListQual, hi11procCd,
		        hi11procDesc, hi11dttmQual, hi11procDt,
		        hi11amount, hi12cdListQual, hi12procCd,
		        hi12procDesc, hi12dttmQual, hi12procDt,
		        hi12amount, createdBy, dateCreated,
		        hi01qnty, hi01versionId, hi01indstryCd,
				hi01cndtnResponseCd, hi02qnty,
				hi02versionId, hi02indstryCd,
				hi02cndtnResponseCd, hi03qnty,
				hi03versionId, hi03indstryCd,
				hi03cndtnResponseCd, hi04qnty,
				hi04versionId, hi04indstryCd,
				hi04cndtnResponseCd, hi05qnty,
				hi05versionId, hi05indstryCd,
				hi05cndtnResponseCd, hi06qnty,
				hi06versionId, hi06indstryCd,
				hi06cndtnResponseCd, hi07qnty,
				hi07versionId, hi07indstryCd,
				hi07cndtnResponseCd, hi08qnty,
				hi08versionId, hi08indstryCd,
				hi08cndtnResponseCd, hi09qnty,
				hi09versionId, hi09indstryCd,
				hi09cndtnResponseCd, hi10qnty,
				hi10versionId, hi10indstryCd,
				hi10cndtnResponseCd, hi11qnty,
				hi11versionId, hi11indstryCd,
				hi11cndtnResponseCd, hi12qnty,
				hi12versionId, hi12indstryCd,
				hi12cndtnResponseCd); 
		
		List <HealthcareInfoCode> healthcareInfoCodes = new ArrayList <HealthcareInfoCode>();
		
		healthcareInfoCodes.add(healthcareInfoCodeNew);
		
		Mockito.when(
				iClaimRepositoryMock.findClaimByClaimIndex(claim.getClaimIndex()))
				.thenReturn(claim);
		
		Mockito.when(
				iDiagnosisCodeRepositoryMock.findAllByClaim(claim.getClaimIndex()))
				.thenReturn(healthcareInfoCodes);

		try {
			System.out.println("Claim.getPoaIndicator() = " + claim.getPoaIndicator());
			
			List <DiagnosisCodes> resultSet = new ArrayList <DiagnosisCodes>();
			resultSet = diagnosisCodeServiceImplMock.getDiagnosisCodes(claim);
			
			for( DiagnosisCodes diagCode : resultSet)
			{
				if(diagCode != null)
				{
					System.out.println("DiagCode.getSequenceNumber() = " + diagCode.getSequenceNumber());
					System.out.println("DiagCode.getDiagnosisCode() = " + diagCode.getDiagnosisCode());
					System.out.println("DiagCode.getDiagnosisCodeQualifier() = " + diagCode.getDiagnosisCodeQualifier());
					System.out.println("DiagCode.getPoaIndicator() = " + diagCode.getPoaIndicator());
					System.out.println("DiagCode.getDiagnosisDescription() = " + diagCode.getDiagnosisDescription());
				}
				//logger.debug("diagCode is : "+diagCode.toString());
			}			
			
			List<DiagnosisCodes> diagnosisCodesResponse = new ArrayList<>();

			diagnosisCodesResponse.add(new DiagnosisCodes(1,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(2,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(3,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(4,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(5,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(6,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(7,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(8,"BK","BK","BK","BK"));
			diagnosisCodesResponse.add(new DiagnosisCodes(9,"BK","BK","ZZ","BK"));

			assertEquals(diagnosisCodesResponse, resultSet);
			logger.info("Test case passed with no exceptions");

		} catch (Exception e) {
			
			e.printStackTrace();
			System.out.println("Exception is: " + e);
			logger.info("Exception is: " + e);
		}
	}
}
