package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.dao.impl.DiagnosisCodeLookupRepositoryImpl;
import gov.va.med.fee.dao.impl.MedicalCodeLookupRepositoryImpl;
import gov.va.med.fee.model.response.CodeLookupResponse;
import gov.va.med.fee.model.response.GenericResponse;

/**
 * @author Muneshwar Baiah
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class CodeLookupServiceImplTest {

	private static final Logger logger = LogManager.getLogger(CodeLookupServiceImplTest.class);

	@InjectMocks
	private CodeLookupServiceImpl codeLookupServiceImpl;

	@Mock
	MedicalCodeLookupRepositoryImpl iMedicalCodeRepositoryImpl;

	@Mock
	DiagnosisCodeLookupRepositoryImpl idiagnosisCodeLookupRepositoryImpl;
	
	@Test
	public void testMockIsWorking() {
		assertNotNull("CodeLookupServiceImpl Injection Failed",codeLookupServiceImpl );
		assertNotNull("MedicalCodeLookupRepositoryImpl Injection Failed", iMedicalCodeRepositoryImpl);
		assertNotNull("DiagnosisCodeLookupRepositoryImpl Injection Failed", idiagnosisCodeLookupRepositoryImpl);
	}
	
	@Test
	public void getMedicalCodesSuccess() {
		List<CodeLookupResponse> medicalCodeList= new ArrayList<CodeLookupResponse>();
		CodeLookupResponse medicalCodeResponse = new CodeLookupResponse();
		medicalCodeResponse.setCodeType("NDC CODES");
		medicalCodeResponse.setDrugExempt("Drug Exemption");
		medicalCodeResponse.setExpirationDate(null);
		medicalCodeResponse.setStartDate(null);
		medicalCodeResponse.setCode("0000183329");
		medicalCodeResponse.setDescription("25 MG TAB - MECLIZINE HCL TABLETS ( HJ HARKINS CO INC )");
		
		Mockito.when(iMedicalCodeRepositoryImpl.getCount("0000183329","NDC CODES",100,"MEDICAL_CD",false,1 )).thenReturn(10L);
		Mockito.when(iMedicalCodeRepositoryImpl.getCodes("0000183329","NDC CODES",100,"MEDICAL_CD",false,1 )).thenReturn(medicalCodeList);

		try {
			GenericResponse response = codeLookupServiceImpl.getMedicalCodes("0000183329","NDC CODES",100,"MEDICAL_CD",false,1);
			logger.debug("getMedicalCodesSuccess response is : "+response);
			assertEquals(response.getResponse().get(0), medicalCodeResponse);
			logger.info("getMedicalCodesSuccess() passed !!");
		} catch (Exception e) {
			logger.info("getMedicalCodesSuccess() exception occured : " + e);
		}
	}	
	
	
	@Test
	public void getMedicalCodesFailure() {
		Mockito.when(iMedicalCodeRepositoryImpl.getCount("0000183329","NDC CODES",100,"MEDICAL_CD",false,1 )).thenReturn(0L);
		try {
			GenericResponse response = codeLookupServiceImpl.getMedicalCodes("0000183329","NDC CODES",100,"MEDICAL_CD",false,1);
			logger.debug("getMedicalCodesFailure response is : "+response);
			assertEquals(response.getResponse().get(0), null);
			logger.info("getMedicalCodesFailure() passed !!");
		} catch (Exception e) {
			logger.info("getMedicalCodesFailure() exception occured : " + e);
		}
	}	
	
	@Test
	public void getDiagnosisCodesSuccess() {
		List<CodeLookupResponse> diagnosisCodeList= new ArrayList<CodeLookupResponse>();
		CodeLookupResponse diagnosisCodeResponse = new CodeLookupResponse();
		diagnosisCodeResponse.setCodeType("1");
		diagnosisCodeResponse.setDrugExempt("Drug Exemption");
		diagnosisCodeResponse.setExpirationDate(null);
		diagnosisCodeResponse.setStartDate(null);
		diagnosisCodeResponse.setCode("T40.4");
		diagnosisCodeResponse.setDescription("Poisoning by, adverse effect of and underdosing of other synthetic narcotics");
		
		Mockito.when(idiagnosisCodeLookupRepositoryImpl.getCount("T40.4","1",100,"ICD_CODE",false,1 )).thenReturn(10L);
		Mockito.when(idiagnosisCodeLookupRepositoryImpl.getCodes("T40.4","1",100,"ICD_CODE",false,1 )).thenReturn(diagnosisCodeList);

		try {
			GenericResponse response = codeLookupServiceImpl.getDiagnosisCodes("T40.4","1",100,"ICD_CODE",false,1);
			logger.debug("getDiagnosisCodesSuccess response is : "+response);
			assertEquals(response.getResponse().get(0), diagnosisCodeResponse);
			logger.info("getDiagnosisCodesSuccess() passed !!");
		} catch (Exception e) {
			logger.info("getDiagnosisCodesSuccess() exception occured : " + e);
		}
	}	
	
	
	@Test
	public void getDiagnosisCodesFailure() {
		Mockito.when(idiagnosisCodeLookupRepositoryImpl.getCount("T40.4","1",100,"ICD_CODE",false,1 )).thenReturn(0L);
		try {
			GenericResponse response = codeLookupServiceImpl.getDiagnosisCodes("T40.4","1",100,"ICD_CODE",false,1);
			logger.debug("getDiagnosisCodesFailure response is : "+response);
			assertEquals(response.getResponse().get(0), null);
			logger.info("getDiagnosisCodesFailure() passed !!");
		} catch (Exception e) {
			logger.info("getDiagnosisCodesFailure() exception occured : " + e);
		}
	}	
}
