package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ClaimProcedure;
import gov.va.med.domain.fee.WsFacStatus;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IClaimByStatusCodeRepository;
import gov.va.med.fee.dao.IClaimProcedureRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.request.ClaimRequest;
import gov.va.med.fee.model.response.ClaimLineItem;
import gov.va.med.fee.model.response.ClaimLineItems;
import gov.va.med.fee.model.response.ClaimResponse;

/**
 * @author Muneshwar Baiah
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class ClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(ClaimServiceImplTest.class);

	@InjectMocks
	private ClaimServiceImpl calimServiceImplMock;

	@Mock
	private IClaimByStatusCodeRepository iClaimByStatusCodeRepository;
	
	@Mock
	private IClaimProcedureRepository claimProcedureRepository;

	@Test
	public void testMockIsWorking() {
		assertNotNull("Claim Service Injection Failed", calimServiceImplMock);
		assertNotNull("Calim  Repository Injection Failed", iClaimByStatusCodeRepository);
	}

	
	@Test
	public void testGetAwaitingProcessingClaims() {
		testGetClaims(ClaimDetailsConstants.AWAITING_STATUS_CODE);
	}
	
	@Test
	public void testGetRejectedClaims() {
		testGetClaims(ClaimDetailsConstants.REJECTED_STATUS_CODE);
	}
	
	
	private void testGetClaims(String claimStatus) {
		// Setup
		ClaimRequest claimRequest = new ClaimRequest();
		List<String> activeStations = new ArrayList<String>();
		List<Long> visns = new ArrayList<Long>();
		List<String> privacyRestrictions = new ArrayList<String>();
		
		activeStations.add("1");
		visns.add(1L);
		privacyRestrictions.add("ADMIN");
		
		claimRequest.setActiveStations(activeStations);
		claimRequest.setVisns(visns);
		claimRequest.setPrivacyRestrictions(privacyRestrictions);
		
		Date date = new GregorianCalendar(2010, Calendar.MARCH, 30).getTime();
		BigDecimal claimAmount = new BigDecimal("1000.00");
		WsFacStatus wsFacStatus = new WsFacStatus(1L, 100L, "100",date , "INST", 'Y', date, claimStatus, claimAmount, date,
				                                  "MICHAEL", "044444444", "MEMORIAL", 100L, 20L, "MICHAEL",date);
		List<WsFacStatus> wsFacStatusList = new ArrayList<WsFacStatus>();
		wsFacStatusList.add(wsFacStatus);
		ClaimResponse awaitingProcessing = new ClaimResponse(1L, claimStatus,"INST", 'Y',
				"MICHAEL", "044444444", "03/30/2010", claimAmount, 
				"MEMORIAL", 100L, "100", 101L,"09/09/2017",100L);
		List<ClaimResponse> awaitingProcessingClaims = new ArrayList<ClaimResponse>();
		awaitingProcessingClaims.add(awaitingProcessing);
		
		List<String> activeStationList = new ArrayList<String>();
		activeStationList.add("123");
		List<String> privacyRestrictionsList = new ArrayList<String>();
		privacyRestrictionsList.add("044444444");
		List<Long> visnList = new ArrayList<Long>();
		visnList.add(1L);
		Mockito.when(iClaimByStatusCodeRepository.findAwaitingProcessingClaims(claimStatus, activeStationList,privacyRestrictionsList,visnList )).thenReturn(wsFacStatusList);

		try {
			List<ClaimResponse> resultSet = calimServiceImplMock.getClaimsByStatus(claimRequest, claimStatus);
			logger.debug("resultSet is : "+resultSet.get(0));
			assertEquals(awaitingProcessingClaims.get(0).getClaimId(), resultSet.get(0).getClaimId());
			assertEquals(awaitingProcessingClaims.get(0).getClaimStatus(), resultSet.get(0).getClaimStatus());
			assertEquals(awaitingProcessingClaims.get(0).getFacility(), resultSet.get(0).getFacility());
			logger.info("testGetClaims() passed !!");
		} catch (Exception e) {
			logger.info("testGetClaims() exception occured : " + e);
		}
	}
	
	@Test
	public void test_getClaimLineItems() {
		logger.info("test_getClaimLineItems");
		long claimId = 999L;

		List<ClaimProcedure> claimProcedureList = new ArrayList<ClaimProcedure>();
		ClaimProcedure claimProcedure = new ClaimProcedure();
		claimProcedure.setBilledAmount(new BigDecimal(123.25));
		claimProcedure.setBilledUnits(50);
		claimProcedure.setProcCodeDesc("Test Description1");
		Date currDate = new Date();
		claimProcedure.setServiceFromDate(currDate);
		claimProcedure.setServiceToDate(currDate);
		Claim claim = new Claim();
		claim.setClaimIndex(claimId);
		claimProcedure.setClaim(claim);
		claimProcedureList.add(claimProcedure);
		
		claimProcedure = new ClaimProcedure();
		claimProcedure.setBilledAmount(new BigDecimal(124.25));
		claimProcedure.setBilledUnits(100);
		claimProcedure.setProcCodeDesc("Test Description2");
		claimProcedure.setServiceFromDate(currDate);
		claimProcedure.setServiceToDate(currDate);
		claimProcedure.setClaim(claim);
		claimProcedure.setDateCreated(currDate);
		claimProcedureList.add(claimProcedure);
		ClaimLineItems claimLineItems = null;
		try {
			Mockito.when(claimProcedureRepository.findClaimProcedure(claimId)).thenReturn(claimProcedureList);
			claimLineItems = calimServiceImplMock.getClaimLineItems(claimId);
			
		} catch (GenericException e) {
			e.printStackTrace();
		}	
		
		int i = 0;
		for(ClaimLineItem claimLineItem:claimLineItems.getClaimLineItems()) {
			if(i == 0) {
				assertEquals(claimLineItem.getBilledAmount(), new BigDecimal(123.25));
				assertEquals(claimLineItem.getBilledUnits(), 50);
				assertEquals(claimLineItem.getDescription(), "Test Description1");
				/*assertEquals(claimLineItem.getServiceDateFrom(), currDate);
				assertEquals(claimLineItem.getServiceDateTo(), currDate);*/
			}
			else if(i == 1) {
				assertEquals(claimLineItem.getBilledAmount(), new BigDecimal(124.25));
				assertEquals(claimLineItem.getBilledUnits(), 100);
				assertEquals(claimLineItem.getDescription(), "Test Description2");
				/*assertEquals(claimLineItem.getServiceDateFrom(), currDate);
				assertEquals(claimLineItem.getServiceDateTo(), currDate);*/
			}
			
			i++;
		}
		
	}
}
