package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ClaimDetailsResponse;
import gov.va.med.fee.model.response.ClaimRejectionHistoryResponse;
import gov.va.med.fee.model.response.DiagnosisCodes;
import gov.va.med.fee.model.response.LineItemResponse;
import gov.va.med.fee.model.response.OhiInfoResponse;
import gov.va.med.fee.model.response.ReRoutingHistory;
import gov.va.med.fee.service.IAdditionalInfoService;
import gov.va.med.fee.service.IBillingProviderService;
import gov.va.med.fee.service.IDiagnosisCodeService;
import gov.va.med.fee.service.ILineItemsService;
import gov.va.med.fee.service.IOhiService;
import gov.va.med.fee.service.IProviderInfoService;
import gov.va.med.fee.service.IReRoutingHistoryService;
import gov.va.med.fee.service.IRejectionHistoryService;
import gov.va.med.fee.service.IVeteranInfoService;

/**
 * 
 * @author DNS   SUNH
 * @version 1.0 This Class Test the Claim Service.
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class ClaimDetailsServiceImplTest extends AbstractClaimServiceImplTest {
	
	@InjectMocks
	ClaimDetailsServiceImpl claimService;
	@Mock
	IVeteranInfoService veteranInfoService;
	@Mock
	IProviderInfoService providerInfoService;
	@Mock
	IBillingProviderService billingProviderService;
	@Mock
	IDiagnosisCodeService diagnosisCodeService;
	@Mock
	IAdditionalInfoService additionalInfoService;
	@Mock
	IReRoutingHistoryService reRoutingHistoryService;
	@Mock
	ILineItemsService lineItemsService;
	@Mock
	IRejectionHistoryService iRejectionHistoryService;
	@Mock
	IOhiService iOhiInfoService;
		
	@Test
	public void testMockIsWorking() {
		assertNotNull("Claim Service Injection Failed",claimService);
		assertNotNull("IClaimRepository Injection Failed",iClaimRepositoryMock);
	}
	
	@Test
	public void testGetClaimByIndex_success() throws GenericException {
		// Stub
		Mockito.when(iClaimRepositoryMock.findByClaimIndex(999L)).thenReturn(claim);
		ClaimDetailsResponse claimResponse = new ClaimDetailsResponse(claim.getClaimIndex(), "2.0.1.STD", "INPROCESS", "111111", null, null, null, null, 
				null, new LinkedList<DiagnosisCodes>(), new ArrayList<LineItemResponse>(), new ArrayList<ReRoutingHistory>(), new ArrayList<ClaimRejectionHistoryResponse>(),
				new ArrayList<OhiInfoResponse>());
		
		try {
			ClaimDetailsResponse resultSet = claimService.getClaimDetailsByClaimIndex(claim.getClaimIndex());
			System.out.println("claimResponse - " +claimResponse.toString());
			System.out.println("resultSet     - " +resultSet.toString());
			assertEquals(claimResponse.getClaimId(), resultSet.getClaimId());
			assertEquals(resultSet.getPatientControlNumber(), "2.0.1.STD");
			assertEquals(resultSet.getClaimStatus(), "INPROCESS");
			assertEquals(resultSet.getPreAuthorization(), "111111");
			// assertEquals(claimResponse, resultSet);

		} catch (Exception e) {
			throw e;
		}
	}

	@Test 
	public void testGetClaimByIndex_with_OHI_success() throws GenericException {
		Mockito.when(iClaimRepositoryMock.findByClaimIndex(999L)).thenReturn(claim);

		OhiInfoResponse ohiInfoResponse = new OhiInfoResponse();
		ohiInfoResponse.setPayerName("Payer1.114");
		ohiInfoResponse.setGroupName("114A Insurance Corp");
		List<OhiInfoResponse> ohiInfo = new ArrayList<OhiInfoResponse>();
		ohiInfo.add(ohiInfoResponse);
		
		Mockito.when(iOhiInfoService.getOhiInfo(claim)).thenReturn(ohiInfo);
		
		try {
			ClaimDetailsResponse resultSet = claimService.getClaimDetailsByClaimIndex(claim.getClaimIndex());
			assertEquals(resultSet.getOhiInfo().get(0).getPayerName(), "Payer1.114");
			assertEquals(resultSet.getOhiInfo().get(0).getGroupName(), "114A Insurance Corp");

		} catch (Exception e) {
			throw e;
		}
	}

	@SuppressWarnings("unchecked")
	@Test(expected = GenericException.class)
	public void test_GetClaimDetailsByIndex_fail_raise_error() throws GenericException {
		
		// Stub the Repository
		Mockito.when(claimService.getClaimDetailsByClaimIndex(Long.valueOf(999))).thenThrow(GenericException.class);
		
	}
}
