/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.ClaimProcedure;
//import gov.va.med.domain.fee.PlaceOfService;
import gov.va.med.domain.fee.ProviderInfo;
import gov.va.med.domain.fee.ProviderType;
import gov.va.med.fee.constants.ClaimDetailsConstants;
import gov.va.med.fee.dao.IBillingRepositoryTemplate;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.ProviderInfoResponse;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class BillingProviderServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(BillingProviderServiceImplTest.class);

	@Mock
	private BillingProviderServiceImpl billingProviderServiceImplMock;

	@Mock
	private IBillingRepositoryTemplate iBillingProviderRepositoryMock;

	@Before
	public void setup() throws GenericException {
		billingProviderServiceImplMock = new BillingProviderServiceImpl();
		iBillingProviderRepositoryMock = Mockito.mock(IBillingRepositoryTemplate.class);
		billingProviderServiceImplMock.setiBillingProviderRepository(iBillingProviderRepositoryMock);
	}

	@Test
	public void testMockIsWorking() {
		assertNotNull("Billing Provider Service Injection Failed", billingProviderServiceImplMock);
		assertNotNull("Billing Provider Repository Injection Failed", iBillingProviderRepositoryMock);
	}

	@Test
	public void testGetBillingProviderInfo() {	
		ProviderType providerType = new ProviderType("BILLING PROVIDER", providerCreatedDate, "VA");
		ClaimProcedure claimProcedure = new ClaimProcedure(Long.valueOf(1000), claim, serviceType, Long.valueOf(1000),
				Long.valueOf(1000), "Test", "N", "VA USA", dateCreated);
		ProviderInfo providerInfo = new ProviderInfo(Long.valueOf(1000), claim, claimProcedure, providerType,
				"VA USA", "VA USA", "VA USA", "Doe", "John", "johnny", "jr.", "Sarno Plaza", "Sarno Road", "Melbourne",
				"Florida", "32935", "John Doe", "9999999999", "912345678", "john.doe@DOMAIN", Long.valueOf(1000), dateCreated, "VA USA");
		Mockito.when(iBillingProviderRepositoryMock.findOneByProvider(claim.getClaimIndex(),
				ClaimDetailsConstants.BILLING_PROVIDER_TYPE, ClaimDetailsConstants.BILLING_PROVIDER_TYPE_OLD)).thenReturn(providerInfo);
		try {
			ProviderInfoResponse resultSet = billingProviderServiceImplMock
					.getBillingProviderResponse(claim);
			
			assertEquals(providerInfo.getAddressLine1(), resultSet.getAddressLine1());
			assertEquals(providerInfo.getAddressLine2(), resultSet.getAddressLine2());
			assertEquals(providerInfo.getCity(), resultSet.getCity());
			assertEquals(providerInfo.getProviderNpi(), resultSet.getProviderNpi());
			assertEquals(providerInfo.getContactName(), resultSet.getContactName());
			assertEquals(providerInfo.getState(), resultSet.getState());
			assertEquals(providerInfo.getFaxNumber(), resultSet.getFaxNumber());
			assertEquals(providerInfo.getPhoneNumber(), resultSet.getPhoneNumber());
			
			logger.info("Test case passed with no exceptions");

		} catch (Exception e) {
			logger.info("Exception is: " + e);
		}
	}
}
