package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.AdjustmentGroup;
import gov.va.med.domain.fee.AdjustmentReason;
import gov.va.med.fee.dao.IAdjustmentGroupRepository;
import gov.va.med.fee.dao.IAdjustmentsRepository;
import gov.va.med.fee.exceptions.GenericException;
import gov.va.med.fee.model.response.AdjustmentGroupDTO;
import gov.va.med.fee.model.response.AdjustmentReasonDTO;
import gov.va.med.fee.model.response.AdjustmentsResponses;

@RunWith(MockitoJUnitRunner.class)
public class AdjustmentsServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(AdjustmentsServiceImplTest.class);
	@InjectMocks
	private AdjustmentsServiceImpl adjustmentsServiceImplMock;

	@Mock
	private IAdjustmentsRepository iAdjustmentsRepositoryMock;
	
	@Mock
	private IAdjustmentGroupRepository iAdjustmentGroupRepository;
	
	@Mock
	private IAdjustmentsRepository iDisClaimRepository;
	
	@Before
	public void setup() throws GenericException {
		//adjustmentsServiceImplMock = new AdjustmentsServiceImpl();
		iAdjustmentsRepositoryMock = Mockito.mock(IAdjustmentsRepository.class);
	}
	
	@Test
	public void testMockIsWorking() {
		//assertNotNull("Adjustment Service Injection Failed", adjustmentsServiceImplMock);
		assertNotNull("Rejection History Service Repository Injection Failed", iAdjustmentsRepositoryMock);
	}

	@Test
	public void test_getAdjustmentGroups() {
		logger.info("test_getAdjustmentGroups:");
		List<AdjustmentGroup> adjustmentGroupList = new ArrayList<AdjustmentGroup>();
		AdjustmentGroup adjustmentGroup = new AdjustmentGroup();
		adjustmentGroup.setAdjustmentGroupCd("CO");
		adjustmentGroup.setDescription("Contractual Obligations");
		adjustmentGroupList.add(adjustmentGroup);
		
		AdjustmentGroupDTO adjustmentGroupDTO = new AdjustmentGroupDTO();
		adjustmentGroupDTO.setCode("CO");
		adjustmentGroupDTO.setDescription("Contractual Obligations");
		
		AdjustmentsResponses adjustmentsResponses  = null;
		Mockito.when(iAdjustmentGroupRepository.findAll()).thenReturn(adjustmentGroupList);
		try {
			adjustmentsResponses  = adjustmentsServiceImplMock.getAdjustmentGroups();
		} catch (GenericException e) {
			e.printStackTrace();
		}
		for(AdjustmentGroupDTO adjGroupDTO:adjustmentsResponses.getAdjustmentGroups()) {
			if(adjGroupDTO.getCode().equals(adjustmentGroupDTO.getCode())) {
				assertEquals(adjGroupDTO.getCode(), adjustmentGroupDTO.getCode());
				assertEquals(adjGroupDTO.getDescription(), adjustmentGroupDTO.getDescription());
			}
		}
		
	}
	
	
	@Test
	public void test_getAdjustmentReasonsByGroupCode() {
		logger.info("test_getAdjustmentReasonsByGroupCode:");
		List<AdjustmentReason> adjustmentReasonList = new ArrayList<AdjustmentReason>();
		AdjustmentReason adjustmentReason = new AdjustmentReason();
		adjustmentReason.setAdjustmentReasonCd("206");
		adjustmentReason.setDescription("Expenses incurred after coverage terminated.");
		adjustmentReasonList.add(adjustmentReason);
		
		AdjustmentReasonDTO adjustmentReasonDTO = new AdjustmentReasonDTO();
		adjustmentReasonDTO.setCode("206");
		adjustmentReasonDTO.setDescription("Expenses incurred after coverage terminated.");
		
		AdjustmentsResponses adjustmentsResponses  = null;
		Mockito.when(iDisClaimRepository.findAdjustmentReasonByGroupCode("CO")).thenReturn(adjustmentReasonList);
		try {
			adjustmentsResponses  = adjustmentsServiceImplMock.getAdjustmentReasonsByGroupCode("CO");
		} catch (GenericException e) {
			e.printStackTrace();
		}
		for(AdjustmentReasonDTO adjReasonDTO:adjustmentsResponses.getAdjustmentReasons()) {
			if(adjReasonDTO.getCode().equals(adjustmentReasonDTO.getCode())) {
				assertEquals(adjReasonDTO.getCode(), adjustmentReasonDTO.getCode());
				assertEquals(adjReasonDTO.getDescription(), adjustmentReasonDTO.getDescription());
			}
		}
		
	}
}
