/**
 * 
 */
package gov.va.med.fee.service.impl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import gov.va.med.domain.fee.HealthcareInfoCode;
import gov.va.med.domain.fee.PayerInfo;
import gov.va.med.domain.fee.PayerType;
import gov.va.med.fee.dao.IAdditionalInfoRepository;
import gov.va.med.fee.dao.IAdditionalInfoRepositoryTemplate;
import gov.va.med.fee.dao.IAttendingPhysicianRepository;
import gov.va.med.fee.dao.IDiagnosisCodeRepository;
import gov.va.med.fee.model.response.AdditionalInfoResponse;
import gov.va.med.fee.model.response.ClaimPaymentResponse;

/**
 * @author Vamsi Krisna Gangarapu
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class AdditionalInfoServiceImplTest extends AbstractClaimServiceImplTest {

	private static final Logger logger = LogManager.getLogger(AdditionalInfoServiceImplTest.class);

	@InjectMocks
	private AdditionalInfoServiceImpl additionalInfoServiceImplMock;

	@Mock
	private IAdditionalInfoRepository iAdditionalInfoRepositoryMock;

	@Mock
	private IAdditionalInfoRepositoryTemplate iAdditionalInfoRepositoryTemplateMock;

	@Mock
	private IAttendingPhysicianRepository iAttendingPhysicianRepositoryMock;

	@Mock
	private IDiagnosisCodeRepository iDiagnosisCodeRepositoryMock;

	@Test
	public void testMockIsWorking() {
		assertNotNull("AdditionalInfo Code Service Injection Failed", additionalInfoServiceImplMock);
		assertNotNull("AdditionalInfo Code Repository Injection Failed", iAdditionalInfoRepositoryMock);
		assertNotNull("AdditionalInfo Code Repository Injection Failed", iAdditionalInfoRepositoryTemplateMock);
		assertNotNull("Diagnosis Code Repository Injection Failed", iDiagnosisCodeRepositoryMock);
		assertNotNull("Attending Physician Code Repository Injection Failed", iAttendingPhysicianRepositoryMock);
	}

	@Test
	public void testGetAdditionalInfo_Sucess() {
		// Setup

		/*
		 * Date serviceDate = new GregorianCalendar(2009, Calendar.JANUARY,
		 * 22).getTime(); Date visinCreateDate = new GregorianCalendar(2000,
		 * Calendar.MARCH, 30).getTime();
		 * 
		 * ServiceType serviceType = new ServiceType("PROF", serviceDate,
		 * "User1"); Visn visn = new Visn(Long.valueOf(1000), "User1",
		 * visinCreateDate); Claim claim = new Claim(Long.valueOf(101),
		 * serviceType, visn, "C001", 'T');
		 */

		BigDecimal number = new BigDecimal(123);
		Date providerCreatedDate = new GregorianCalendar(2000, Calendar.MAY, 30).getTime();
		Date dateCreated = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();

		PayerType payerType = new PayerType("SECONDARY", providerCreatedDate, dateCreated.toString());
		PayerInfo payerInfo = new PayerInfo(Long.valueOf(1000), claim, payerType, "Test", "Description", "Test",
				"Test123", number, "VA gov", dateCreated);

		Timestamp timestamp = new Timestamp(System.currentTimeMillis());

		ClaimPaymentResponse claimPaymentResponse = new ClaimPaymentResponse("123ABCD", timestamp, number);

		HealthcareInfoCode healthcareInfoCode = new HealthcareInfoCode();
		healthcareInfoCode.setHi01procCd("Test");

		Mockito.when(iAdditionalInfoRepositoryMock.findPayerInfoByClaimIndex(claim.getClaimIndex(), "SECONDARY"))
				.thenReturn(payerInfo);

		Mockito.when(iAdditionalInfoRepositoryTemplateMock.getAdditionalTabInfo(claim.getClaimIndex()))
				.thenReturn(claimPaymentResponse);

		Mockito.when(iDiagnosisCodeRepositoryMock.findProviderDRGByClaim(claim.getClaimIndex()))
				.thenReturn(healthcareInfoCode);

		try {
			AdditionalInfoResponse additionalInfoResultSet = additionalInfoServiceImplMock
					.getAdditionalInfoDetails(claim);

			ClaimPaymentResponse claimPaymentResponseResultSet = iAdditionalInfoRepositoryTemplateMock
					.getAdditionalTabInfo(claim.getClaimIndex());

			HealthcareInfoCode healthcareInfoCodeResultSet = iDiagnosisCodeRepositoryMock
					.findProviderDRGByClaim(claim.getClaimIndex());

			assertEquals(claimPaymentResponseResultSet.getCheckNumber(), claimPaymentResponse.getCheckNumber());
			assertEquals(healthcareInfoCodeResultSet.getHi01procCd(), healthcareInfoCode.getHi01procCd());
			assertEquals(additionalInfoResultSet.getOtherInsurancePlan_SecondaryPayer(), payerInfo.getPlanName());
			assertEquals(additionalInfoResultSet.getAdmissionDate(), claim.getAdmissionDate());
			logger.info("Test case passed with no exceptions");
		} catch (Exception e) {
			logger.info("Exception is: " + e);
		}

	}
}
