package gov.va.med.fee.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.junit.Before;
import org.mockito.Mock;

import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ServiceType;
import gov.va.med.domain.fee.Visn;
import gov.va.med.fee.dao.IClaimRepository;

/**
 * @author FTC(CCSE)
 *
 */
public abstract class AbstractClaimServiceImplTest {
	@Mock
	IClaimRepository iClaimRepositoryMock;
	
	final Date providerCreatedDate = new GregorianCalendar(2000, Calendar.MAY, 30).getTime();
	final Date serviceDate = new GregorianCalendar(2009, Calendar.JANUARY, 22).getTime();
	final Date visinCreateDate = new GregorianCalendar(2000, Calendar.MARCH, 30).getTime();
	final Date dateCreated = new GregorianCalendar(1990, Calendar.APRIL, 30).getTime();
	Claim claim;
	ServiceType serviceType;
	Visn visn;
	
	@Before
	public void init() throws Exception {
		serviceType = new ServiceType("INST", serviceDate, "User1");
		visn = new Visn(Long.valueOf(1000), "User1", visinCreateDate);
		claim = new Claim(999L, serviceType, visn, "C001", 'T');
		
		claim.setClaimStatusCd("INPROCESS");
		claim.setPatientControlNumber("2.0.1.STD");
		claim.setPriorAuthNbr("111111");
	}
}
