package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.put;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.delete;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.ContactInfoRequest;
import gov.va.med.fee.model.request.VaFacilityRequest;
import gov.va.med.fee.model.request.VaFacilitySearchRequest;
import gov.va.med.fee.model.request.ZipCodeRequest;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class })
public class VaFacilityControllerIntegrationTest {
	private static final Logger logger = LogManager.getLogger(VaFacilityControllerIntegrationTest.class);

	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;

	@Autowired
	MockHttpServletResponse response;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}

	// I don't think it is a good idea to insert data into Database table by
	// running JUnit test.
	// This is working now. next time you want to run it, make sure you enter a
	// unique VaFacilityCd.
	// A random number can be generated and pass that to setVaFAcilityCd.
	/*
	 * @Test
	 * 
	 * @Rollback(true) public void test_addFacility() throws Exception {
	 * 
	 * VaFacilityRequest req = new VaFacilityRequest();
	 * req.setAgedDefinition(64545L); req.setAppUserName("Kawsar Jahan");
	 * req.setParentVaFacilityCd("1"); req.setReroutingAllowed(true);
	 * req.setShortName("test"); req.setVaFacilityCd("111199999");
	 * req.setVaFacilityName("test"); req.setVaTypeCd("FAC");
	 * req.setVisnIdCd(1L);
	 * 
	 * ObjectMapper mapper = new ObjectMapper();
	 * mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	 * ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter(); String
	 * requestJson = ow.writeValueAsString(req);
	 * 
	 * ResultActions ra = mockMvc.perform(post("/api/v1/VaFacility/addFacility")
	 * .contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(
	 * print()); logger.info("test_addFacility:" +
	 * ra.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.CREATED.value() !=
	 * ra.andReturn().getResponse().getStatus()); }
	 */

	@Test
	public void test_getAllVisn() throws Exception {
		ResultActions ra = mockMvc.perform(get("/api/v1/VaFacility/station/visn")).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("test_getAllVisn_success:" + ra.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != ra.andReturn().getResponse().getStatus());
	}

	@Test
	public void test_getAllFacilityType() throws Exception {
		ResultActions s = mockMvc.perform(get("/api/v1/VaFacility/station/type")).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("testGet _getAllFacilityType_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}

	@Test
	public void test_getStationInformation() throws Exception {
		String stationNumber = "121";

		ResultActions s = mockMvc.perform(
				get("/api/v1/VaFacility/stations/{stationName}", stationNumber).contentType(MediaType.APPLICATION_JSON))
				.andDo(print());

		if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());

		} else {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());

		}
	}

	@Test
	public void test_postStationInformation() throws Exception {
		//String stationNumber = "1210";

		VaFacilityRequest request = new VaFacilityRequest();

		request.setAgedDefinition(new Long(1234));
		request.setAppUserName("DNS   MABCDEFG");
		request.setParentVaFacilityCd("parent cd");
		request.setReroutingAllowed(true);
		request.setShortName("test short name");
		request.setVaFacilityCd("TestCase1");
		request.setVaFacilityName("test va facility name");
		request.setVaTypeCd("CEM");
		request.setVisnIdCd(1L);

		ResultActions s = null;
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson;
		requestJson = ow.writeValueAsString(request);
		s = mockMvc
				.perform(post("/api/v1/VaFacility/station").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print());


		if (s.andReturn().getResponse().getStatus() != HttpStatus.CREATED.value()) {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());

		} else {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.CREATED.value() != s.andReturn().getResponse().getStatus());

		}
	}
	
	@Test
	public void test_putStationInformation() throws Exception {
		//String stationNumber = "1210";

		VaFacilityRequest request = new VaFacilityRequest();

		request.setAgedDefinition(new Long(1234));
		request.setAppUserName("DNS   MABCDEFG");
		request.setParentVaFacilityCd("parent cd");
		request.setReroutingAllowed(true);
		request.setShortName("test short name");
		request.setVaFacilityCd("TestCase1");
		request.setVaFacilityName("test va facility name");
		request.setVaTypeCd("CEM");
		request.setVisnIdCd(1L);

		ResultActions s = null;
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson;
		requestJson = ow.writeValueAsString(request);
		s = mockMvc
				.perform(put("/api/v1/VaFacility/station").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print());
		
		if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.INTERNAL_SERVER_ERROR.value() != s.andReturn().getResponse().getStatus());

		} else {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());

		}
	}
	
	@Test
	public void test_deleteStationInformation() throws Exception {
		String stationName = "TestCase1";
		 
		ResultActions s = mockMvc.perform(delete("/api/v1/VaFacility/station/{stationName}", stationName).contentType(MediaType.APPLICATION_JSON))
				.andDo(print()).andExpect(status().isOk());
		
		if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());

		} else {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());

		}
	}

	@Test
	public void test_GetSearchStationSuccess() {
		VaFacilitySearchRequest vaFacilityRequest = new VaFacilitySearchRequest(100, null, false, 1, null, "", "ST%W",
				"ADMIN", null);
		// ClaimSearchProcessingRequest claimSearchProcessingRequest = new
		// ClaimSearchProcessingRequest(100, null, false, 1, null, null, null,
		// null, null, null, null, null, null, null, null, null, false, false);
		ResultActions s = null;
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson;
		try {
			requestJson = ow.writeValueAsString(vaFacilityRequest);
			s = mockMvc
					.perform(post("/api/v1/VaFacility/station/search").contentType(MediaType.APPLICATION_JSON)
							.content(requestJson))
					.andDo(print()).andExpect(status().isOk())
					.andExpect(content().contentType("application/json;charset=UTF-8"));
		} catch (Exception e) {
			e.printStackTrace();
		}

		logger.info("test_GetSearchStationSuccess:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}

	@Test
	public void test_getZipCodeList() throws Exception {
		String stationNumber = "563";

		ResultActions s = mockMvc.perform(get("/api/v1/VaFacility/station/zipcode/{stationNumber}", stationNumber)
				.contentType(MediaType.APPLICATION_JSON)).andDo(print());

		logger.debug("test_getZipCodeList:" + s.andReturn().getResponse().getStatus());
		if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
		} else {
			logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
			assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
		}
	}

	@Test
	public void test_addContactInfo_error() {
		try {
			String appUserName = "DNS   MTESTER";
			String vaFacilityCd = "563";

			ContactInfoRequest request = new ContactInfoRequest();
			request.setAppUserName(appUserName);
			request.setVaFacilityCd(vaFacilityCd);
			request.setAddress1("1 Oracle Dr.");
			request.setCity("Palo Alto");
			request.setContactName("Mr. ABC");
			request.setContactType("Admin");
			request.setEmail("PII       ");
			request.setZip("99988-8889");
			request.setPhone("1234567890");
			request.setFax("1234567890");

			ResultActions s = mockMvc.perform(post("/api/v1/VaFacility/station/contactInfo")
					.contentType(MediaType.APPLICATION_JSON).content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_addContactInfo:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_addContactInfo:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_addContactInfo -- ");
			e.printStackTrace();
		}
	}

	@Test
	public void test_addZipCode_error() {
		try {
			String appUserName = "DNS   MTESTER";
			String selectedFacilityId = "999";

			ZipCodeRequest request = new ZipCodeRequest();
			request.setAppUserName(appUserName);
			request.setVaFacilityCd(selectedFacilityId);
			request.setActive(Boolean.TRUE);
			request.setFips_county_code("MC");
			request.setFips_state_code("MD");
			request.setUrban_indicator("11");
			request.setZip_code("99999-8");

			ResultActions s = mockMvc.perform(post("/api/v1/VaFacility/station/zipcode/")
					.contentType(MediaType.APPLICATION_JSON).content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_addZipCode:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_addZipCode:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_addZipCode -- ");
			e.printStackTrace();
		}
	}

	@Test
	public void test_editZipCode_error() {
		try {

			ZipCodeRequest request = new ZipCodeRequest();
			request.setZip_code("88888");
			request.setActive(Boolean.TRUE);
			request.setFips_county_code("PG");
			request.setFips_state_code("MD");
			request.setUrban_indicator("12345678990");

			ResultActions s = mockMvc.perform(put("/api/v1/VaFacility/station/zipcode/")
					.contentType(MediaType.APPLICATION_JSON).content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_processReroutes -- ");
			e.printStackTrace();
		}
	}

	/*
	 * @Test public void test_addContactInfo() { try { String appUserName =
	 * "DNS   MTESTER"; String vaFacilityCd = "563";
	 * 
	 * ContactInfoRequest request = new ContactInfoRequest();
	 * request.setAppUserName(appUserName);
	 * request.setVaFacilityCd(vaFacilityCd);
	 * request.setAddress1("1 Oracle Dr."); request.setCity("Palo Alto");
	 * request.setContactName("Mr. ABC"); request.setContactType("Admin");
	 * request.setEmail("PII       "); request.setZip("99988");
	 * request.setPhone("1234567890");
	 * 
	 * ResultActions s =
	 * mockMvc.perform(post("/api/v1/VaFacility/contactInfo/addContactInfo/").
	 * contentType(MediaType.APPLICATION_JSON)
	 * .content(getRequestJson(request))).andDo(print());
	 * 
	 * if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
	 * logger.info("test_addContactInfo:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.BAD_REQUEST.value() !=
	 * s.andReturn().getResponse().getStatus()); } else {
	 * logger.info("test_addContactInfo:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.OK.value() !=
	 * s.andReturn().getResponse().getStatus()); } } catch (Exception e) {
	 * logger.error("test_addContactInfo -- "); e.printStackTrace(); } }
	 * 
	 * @Test public void test_modifyContactInfo() { try { String appUserName =
	 * "DNS   MTESTER"; String vaFacilityCd = "563";
	 * 
	 * ContactInfoRequest request = new ContactInfoRequest();
	 * request.setAppUserName(appUserName); request.setContactInfoId(313752L);
	 * request.setVaFacilityCd(vaFacilityCd);
	 * request.setAddress1("1 Oracle Dr."); //request.setCity("Palo Alto");
	 * request.setContactName("Mrs. ABC"); request.setContactType("Admin");
	 * //request.setEmail("PII       "); request.setZip("88899");
	 * request.setPhone("9876543210");
	 * 
	 * ResultActions s =
	 * mockMvc.perform(post("/api/v1/VaFacility/modifyContactInfo/").contentType
	 * (MediaType.APPLICATION_JSON)
	 * .content(getRequestJson(request))).andDo(print());
	 * 
	 * if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
	 * logger.info("test_addContactInfo:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.BAD_REQUEST.value() !=
	 * s.andReturn().getResponse().getStatus()); } else {
	 * logger.info("test_addContactInfo:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.OK.value() !=
	 * s.andReturn().getResponse().getStatus()); } } catch (Exception e) {
	 * logger.error("test_addContactInfo -- "); e.printStackTrace(); } }
	 * 
	 * 
	 * 
	 * @Test public void test_addZipCode() { try { String appUserName =
	 * "DNS   MTESTER"; String selectedFacilityId = "563";
	 * 
	 * ZipCodeRequest request = new ZipCodeRequest();
	 * request.setAppUserName(appUserName);
	 * request.setVaFacilityCd(selectedFacilityId);
	 * request.setActive(Boolean.TRUE); request.setFips_county_code("MC");
	 * request.setFips_state_code("MD"); request.setUrban_indicator("1");
	 * request.setZip_code("20855");
	 * 
	 * ResultActions s =
	 * mockMvc.perform(post("/api/v1/VaFacility/zipcode/").contentType(MediaType
	 * .APPLICATION_JSON) .content(getRequestJson(request))).andDo(print());
	 * 
	 * if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.BAD_REQUEST.value() !=
	 * s.andReturn().getResponse().getStatus()); } else {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.OK.value() !=
	 * s.andReturn().getResponse().getStatus()); } } catch (Exception e) {
	 * logger.error("test_processReroutes -- "); e.printStackTrace(); } }
	 * 
	 * @Test public void test_editZipCode() { try {
	 * 
	 * String appUserName = "DNS   MTESTER"; String selectedFacilityId = "563";
	 * 
	 * ZipCodeRequest request = new ZipCodeRequest();
	 * request.setAppUserName(appUserName);
	 * request.setVaFacilityCd(selectedFacilityId);
	 * request.setActive(Boolean.TRUE); request.setFips_county_code("PG");
	 * request.setFips_state_code("MD"); request.setUrban_indicator("12");
	 * request.setZip_code("20855");
	 * 
	 * ResultActions s =
	 * mockMvc.perform(put("/api/v1/VaFacility/zipcode/").contentType(MediaType.
	 * APPLICATION_JSON) .content(getRequestJson(request))).andDo(print());
	 * 
	 * if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.BAD_REQUEST.value() !=
	 * s.andReturn().getResponse().getStatus()); } else {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.OK.value() !=
	 * s.andReturn().getResponse().getStatus()); } } catch (Exception e) {
	 * logger.error("test_processReroutes -- "); e.printStackTrace(); } }
	 * 
	 * @Test public void test_removeZipCode() throws Exception { try {
	 * 
	 * ZipCodeRequest request = new ZipCodeRequest();
	 * request.setZip_code("23sdfG$%&^");
	 * 
	 * ResultActions s =
	 * mockMvc.perform(delete("/api/v1/VaFacility/zipcode/").contentType(
	 * MediaType.APPLICATION_JSON)
	 * .content(getRequestJson(request))).andDo(print());
	 * 
	 * if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.BAD_REQUEST.value() !=
	 * s.andReturn().getResponse().getStatus()); } else {
	 * logger.info("test_processReroutes:" +
	 * s.andReturn().getResponse().getStatus());
	 * assertFalse(HttpStatus.OK.value() !=
	 * s.andReturn().getResponse().getStatus()); } } catch (Exception e) {
	 * logger.error("test_processReroutes -- "); e.printStackTrace(); } }
	 */
	private String getRequestJson(Object request) {
		String requestJson = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
			mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
			ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
			requestJson = ow.writeValueAsString(request);
			System.out.println("requestJson - " + requestJson);
		} catch (JsonProcessingException e) {
			logger.error("getRequestJson JsonProcessingException -- ");
			e.printStackTrace();
		}
		return requestJson;
	}
}