package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.UserSearchRequest;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class })
public class UserSearchControllerIntegrationTest {
	private static final Logger logger = LogManager.getLogger(UserSearchControllerIntegrationTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;
	
	@Autowired 
	MockHttpServletResponse response;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	@Test
	public void test_searchUser() throws Exception {
		UserSearchRequest userSearchRequest = new UserSearchRequest();
		
		userSearchRequest.setEmail("PII       ");
		userSearchRequest.setUserName("DNS   ABC");
		
		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(userSearchRequest);
		
		ResultActions s = mockMvc.perform(post("/api/v1/user/search").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
		
		logger.info("test_userSearch:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}	
}