package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.put;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.domain.fee.AppUser;
import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.StationRequest;
import gov.va.med.fee.model.request.UserReqRequest;



@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class})
public class UserRequestControllerIntegrationTest {
	private static final Logger logger = LogManager.getLogger(UserRequestControllerIntegrationTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;
	
	@Autowired 
	MockHttpServletResponse response;
	
	long randomPhoneNumber;
	UserReqRequest req;
	
	@Before
	public void setup() {
		mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
		long x = 1111111111L;
		long y = 9999999999L;
		
		Random r = new Random();
		randomPhoneNumber = x+((long)(r.nextDouble()*(y-x)));
		
		String current_user_name = "DNS   MTESTER";
		String window_nt_name = "DNS   ABCD";
		String last_name = "Jackson";
		String first_name = "Jacky";
		String email = "PII                ";
		boolean enabled = Boolean.TRUE;
		String [] request_roles = new String[] {"FPPS_HELP_DESK"};
		
		List<String> request_facilities = new ArrayList<>();
		request_facilities.add(new StationRequest("520", 16,"BILOXI MS").getDisplayFacility());
		request_facilities.add(new StationRequest("564", 16,"Fayetteville NC VAMC").getDisplayFacility());
		
		req = new UserReqRequest(current_user_name, window_nt_name, last_name, first_name, null,
				String.valueOf(randomPhoneNumber), email, enabled, Arrays.asList(request_roles), request_facilities);
	}
	
	@Test
	public void testLoadModifyUserRequestForm() throws Exception {
		AppUser appUser = new AppUser();
		appUser.setAppUserId(Long.valueOf(100));
		appUser.setUserName("DNS   PPSADMIN");
		appUser.setFirstName("Test");
		appUser.setLastName("Test");
		
		ResultActions s = mockMvc.perform(get("/api/v1/userRequest/form/{userName}", appUser.getUserName())).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("testGetClaimByIndex_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}
	
	@Test
	public void testLoadRequestUser() throws Exception {
		ResultActions s = mockMvc.perform(get("/api/v1/userRequest/form")).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("testGetClaimByIndex_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}
	
	/*@Test
	public void testRequestAddUser() {
		try {
			ResultActions s = mockMvc.perform(post("/api/v1/userRequest/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson())).andDo(print());
			
			if(s.andReturn().getResponse().getStatus() != HttpStatus.CREATED.value()) {
				logger.info("testRequestAddUser:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("testRequestAddUser:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.CREATED.value() != s.andReturn().getResponse().getStatus());
			}

		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		} catch (Exception e) {
			e.printStackTrace();
		}   
	}*/
	
	@Test
	public void testRequestAddUser_validationError() {
		try {
			req.setFirst_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567910");
			req.setLast_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234");
			req.setMiddle_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234");
			req.setPhone("1234567890098765432112345");
			
			
			ResultActions s = mockMvc.perform(post("/api/v1/userRequest/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson())).andDo(print());
			
			assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());

		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		} catch (Exception e) {
			e.printStackTrace();
		}   
	}
	
	/*@Test
	public void testRequestModifyUser() {
		try {
			//set up
			String [] request_roles = new String[] {"FPPS_HELP_DESK", "FEE_VISN_PGM_MANAGER"};
			req.setWindow_nt_name("DNS   MABCDEFG");			
			req.setRequest_roles(Arrays.asList(request_roles));
			
			ResultActions s = mockMvc.perform(put("/api/v1/userRequest/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson())).andDo(print());
			
			if(s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.debug("testRequestModifyUser:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.debug("testRequestModifyUser:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
			
		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		} catch (Exception e) {
			e.printStackTrace();
		}   
	}
	*/
	@Test
	public void testRequestModifyUser_validationError() {
		try {
			req.setFirst_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567910");
			req.setLast_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234");
			req.setMiddle_name("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234");
			req.setPhone("1234567890098765432112345");
			
			ResultActions s = mockMvc.perform(post("/api/v1/userRequest/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson())).andDo(print());
			
			assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			
		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		} catch (Exception e) {
			e.printStackTrace();
		}   
	}
	
	private String getRequestJson() {
		String requestJson = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
		    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
			requestJson = ow.writeValueAsString(req);
			System.out.println("requestJson - " + requestJson);
		
		} catch (JsonProcessingException e) {
			logger.error("testRequestAddUser JsonProcessingException -- ");
			e.printStackTrace();
		
		}
		
		/*requestJson = "{\"current_user_name\": \"VHAISMBAIAHBBB\",\"window_nt_name\":\"bbbb\",\"last_name\":\"dd\",\"first_name\":\"ddd\","
		+ "\"phone\":\"\","
		+ "\"email\":\"\",\"enabled\":\"true\",\"request_roles\":[\"FPPS_HELP_DESK\"],\"request_facilities\":[\"\"],"
		+ "\"disable_comments\":\"\"}";
		*/
		return requestJson;
	}
	
}