package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.UnmatchedClaimPaymentRequest;
import gov.va.med.fee.model.request.UnmatchedReconciliationRequest;
import gov.va.med.fee.model.response.PaymentLineItemsResponse;
import gov.va.med.fee.model.response.UnmatchedClaimReconciliationResponse;


@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class})
public class UnmatchedClaimReconciliationControllerIntegrationTest {
	private static final Logger logger = LogManager.getLogger(UnmatchedClaimReconciliationControllerIntegrationTest.class);
	
	private MockMvc mockMvc;
	@Autowired
	private WebApplicationContext wac;
	@Autowired 
	MockHttpServletResponse response;
	
	@Before
	public void setup() {
		mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}

	@Test
	public void test_getClaimsToReconcile() throws Exception {
		ResultActions s = mockMvc.perform(get("/api/v1/reconciliation/unmatchedClaim/{claimIndex}", 103L)).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("test_getClaimsToReconcile:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}

	@Test
	public void test_getclaimPaymentsInformation() {
		try {
			UnmatchedReconciliationRequest request = new UnmatchedReconciliationRequest("C", "88", null,
					"ERROR", "424828", null, null, null);
			
			ResultActions s = mockMvc.perform(post("/api/v1/reconciliation/unmatchedClaim/claimPayments").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_getclaimPaymentsInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_getclaimPaymentsInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_getclaimPaymentsInformation -- ");
			e.printStackTrace();
		}
	}
	
	@Test
	public void test_GetClaimPaymentLinesInformation() throws Exception {
		SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
		UnmatchedClaimReconciliationResponse response = new UnmatchedClaimReconciliationResponse();
		Date date = new Date();
		BigDecimal amount = new BigDecimal("1234");
		try {
			Set<PaymentLineItemsResponse> paymentLineItemsResponseList = new HashSet<PaymentLineItemsResponse>();
			PaymentLineItemsResponse paymentResponse = new PaymentLineItemsResponse("test123", "test1234", "test1234",
					amount, amount, 1234, dateFormat.format(date));
			paymentLineItemsResponseList.add(paymentResponse);
			response.setPaymentLineItemsResponse(paymentLineItemsResponseList);

			ResultActions s = mockMvc
					.perform(get("/api/v1/reconciliation/unmatchedClaim/paymentLines/{feeClaimPaymentId}",
							"25403F0D-B34A-2204-E040-BF0A070C5552"))
					.andDo(print()).andExpect(status().isOk())
					.andExpect(content().contentType("application/json;charset=UTF-8"));

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_getclaimPaymentsLineInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_getclaimPaymentsLineInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_getclaimPaymentsLineInformation -- ");
			e.printStackTrace();
		}
	}

	@Test
	public void test_SetEditPaymentInformation() throws Exception {
		UnmatchedClaimReconciliationResponse unmatchedClaimReconciliationResponse = new UnmatchedClaimReconciliationResponse();
		unmatchedClaimReconciliationResponse.setResponse("Claim Reconciled successfully ");

		BigDecimal number = new BigDecimal(10);
		try {
			UnmatchedClaimPaymentRequest unmatchedClaimPaymentRequest = new UnmatchedClaimPaymentRequest();
			unmatchedClaimPaymentRequest.setFeeClaimPaymentLineId("3EDAF282-95A2-5095-E053-4A10BF0AD9A5");
			unmatchedClaimPaymentRequest.setClaimId(101L);
			unmatchedClaimPaymentRequest.setLineNumber("1");
			unmatchedClaimPaymentRequest.setAdjustment1(number);
			unmatchedClaimPaymentRequest.setGroup1("CO");
			unmatchedClaimPaymentRequest.setReason1("100");

			ResultActions s = mockMvc.perform(post("/api/v1/reconciliation/unmatchedClaim/editpaymentInformation")
					.contentType(MediaType.APPLICATION_JSON).content(getRequestJson(unmatchedClaimPaymentRequest)))
					.andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_setEditPaymentInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_setEditPaymentInformation:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_setEditPaymentInformation -- ");
			e.printStackTrace();
		}
	}
			
	private String getRequestJson(Object request) {
		String requestJson = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
		    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
			requestJson = ow.writeValueAsString(request);
			logger.debug("requestJson - " + requestJson);
		
		} catch (JsonProcessingException e) {
			logger.error("getRequestJson JsonProcessingException -- ");
			e.printStackTrace();
		
		}
		
		return requestJson;
	}
}
