package gov.va.med.fee.integration;

import static org.junit.Assert.*;

import javax.sql.DataSource;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.view.InternalResourceViewResolver;



/**
 * @author Eyuel Taddese
 *
 */

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {gov.va.med.fee.configuration.AppConfig.class, gov.va.med.fee.configuration.hibernate.PersistenceConfig.class, gov.va.med.fee.configuration.spring.SpringMvcConfig.class})
@ActiveProfiles("dev")
@WebAppConfiguration
public class SpringTest {
	@Autowired
	private CacheManager cacheManager;
	
	@Autowired
	private LocalContainerEntityManagerFactoryBean entityManagerFactoryBean;
	
	@Autowired
	private DataSource dataSource;
	
	@Autowired
	private HibernateExceptionTranslator hibernateExceptionTranslator;
	
	@Autowired
	private PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer;
	
	@Autowired
	private RestTemplate restTemplate;
	
	@Autowired
	private InternalResourceViewResolver viewResolver;
	
	@Autowired
	private AnnotationAwareAspectJAutoProxyCreator annotationAwareAspectJAutoProxy;
	
	@Rule
	public TestName testName = new TestName();
	
	/**
	 * 
	 */
	@Rule
	public TestWatcher testWatcher = new TestWatcher() {
		/* (non-Javadoc)
		 * @see org.junit.rules.TestWatcher#starting(org.junit.runner.Description)
		 */
		@Override
		protected void starting(final Description description) {
			String methodName = description.getMethodName();
			String className = description.getClassName();
			System.out.println(className + " " +methodName);
		}
	};
	
	
	@Test
	public void whenDataSourceIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull("Spring Data failed",dataSource);
	}
	
	@Test
	public void whenCacheManagerIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull("Spring Data failed",cacheManager);
	}
	
	@Test
	public void whenPersistanceConfigBeanIsInstantiated_thenNoExceptions() {
		Assert.assertNotNull(entityManagerFactoryBean);
	}
	
	@Test
	public void whenHibernateExceptionTranslatorIsInstantiated_thenNoException() {
		Assert.assertNotNull(hibernateExceptionTranslator);
	}
	
	@Test
	public void whenPropertySourcePlaceholderConfigurerIsInstantiated_thenNoException() {
		Assert.assertNotNull(propertySourcesPlaceholderConfigurer);
	}
	
	@Test
	public void when_RestTemplate_IsInstantiated_thenNoException() {
		Assert.assertNotNull(restTemplate);
	}
	
	@Test
	public void when_viewResolver_isInstantiated_thenNoException() {
		Assert.assertNotNull(viewResolver);
	}
	
	@Test
	public void when_aspectJProxyCreator_thenNoException() {
		Assert.assertNotNull("", annotationAwareAspectJAutoProxy);
	}
}