package gov.va.med.fee.integration;

//import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.put;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;


import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.RerouteClaimRequest;
import gov.va.med.fee.model.response.RerouteClaimInfo;


@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class})
public class RerouteClaimsIntegrationTest {
	private static final Logger logger = LogManager.getLogger(RerouteClaimsIntegrationTest.class);
	
	private MockMvc mockMvc;
	@Autowired
	private WebApplicationContext wac;
	@Autowired 
	MockHttpServletResponse response;
	
	private final String DEFAULT_SELECT_VALUE = "-select-";
	
	@Before
	public void setup() {
		mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	@Test
	public void test_getReroute_error() {
		try {
			List<Long> claimsToReroute = new ArrayList<>();
			ResultActions s = mockMvc.perform(post("/api/v1/rerouteClaims/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(claimsToReroute))).andDo(print());

			logger.info("test_getReroute_error:" + s.andReturn().getResponse().getStatus());
			assertTrue(HttpStatus.BAD_REQUEST.value() == s.andReturn().getResponse().getStatus());
			
		} catch (Exception e) {
			logger.error("test_getReroutes -- ");
			e.printStackTrace();
		}
	}
	
	@Test
	public void test_getReroutes() {
		try {
			List<Long> claimsToReroute = new ArrayList<>();
			claimsToReroute.add(527L); //isPrinted
			claimsToReroute.add(539L); //can be rerouted
			/*claimsToReroute.add(535L);
			claimsToReroute.add(536L);
			claimsToReroute.add(537L);
			claimsToReroute.add(538L);
			claimsToReroute.add(539L);
			claimsToReroute.add(540L);
			claimsToReroute.add(101L);*/			
			
			ResultActions s = mockMvc.perform(post("/api/v1/rerouteClaims/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(claimsToReroute))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_getReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_getReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_getReroutes -- ");
			e.printStackTrace();
		}
	}
	
	@Test
	public void test_getNoReroutes() {
		try {
			List<Long> claimsToReroute = new ArrayList<>();
			claimsToReroute.add(2000L);
			
			ResultActions s = mockMvc.perform(post("/api/v1/rerouteClaims/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(claimsToReroute))).andDo(print());

			//response body is {"nonRouted":"The following claim cannot be rerouted because it is completed, partially reconciled, rejected, or not FPPS: 2000"}

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_getReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_getReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_getReroutes -- ");
			e.printStackTrace();
		}
	}
	
	@Test
	public void testGetFacilities_default() throws Exception {
		
		try {
			String selectedVisnId = DEFAULT_SELECT_VALUE;
			RerouteClaimRequest request= new RerouteClaimRequest();
			request.setSelectedVisn(selectedVisnId);			
			
			ResultActions s = mockMvc.perform(post("/api/v1/rerouteClaims/facilities/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("testGetFacilities_default:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("testGetFacilities_default:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("testGetFacilities_default -- ");
			e.printStackTrace();
		}
		
	}
	
	@Test
	public void testGetFacilities() throws Exception {
				
		try {
			String selectedVisnId = "16";
					
			RerouteClaimRequest request= new RerouteClaimRequest();
			request.setSelectedVisn(selectedVisnId);
			
			ResultActions s = mockMvc.perform(post("/api/v1/rerouteClaims/facilities/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("testGetFacilities:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("testGetFacilities:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("testGetFacilities -- ");
			e.printStackTrace();
		}
		
	}	
	
	/*@Test
	public void test_processReroutes() {
		try {
			String current_user_name = "DNS   MTESTER";
			String selectedVisnId = "16";
			String selectedFacilityId = "564";
			String selectedReason = "2";
			
			List<RerouteClaimInfo> claims_to_be_rerouted = new ArrayList<>();
			
			RerouteClaimInfo info = new RerouteClaimInfo(535, "Emma Benny", "ROMETTY");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(536, "Olivia Brittany", "JACOBS");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(537, "Ava George", "NOYI");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(538, "Sophia Henry", "ALBUS");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(539, "Charlotte Hugo", "DRACO");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(540, "Harper James", "ARTHUR");
			claims_to_be_rerouted.add(info);
			
			RerouteClaimRequest request= new RerouteClaimRequest();
			request.setClaims_to_be_rerouted(claims_to_be_rerouted);
			request.setSelectedFacility(selectedFacilityId);
			request.setSelectedVisn(selectedVisnId);
			request.setSelectedReason(selectedReason);
			request.setCurrent_user_name(current_user_name);
			request.setComment("YOUR COMMENT FOR REROUTE IS HERE");
			
			ResultActions s = mockMvc.perform(put("/api/v1/rerouteClaims/reroutes/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_processReroutes:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_processReroutes -- ");
			e.printStackTrace();
		}
	}*/
	
	@Test
	public void test_processReroutes_error() {
		try {
			String current_user_name = "DNS   MTESTER";
			String selectedVisnId = "23";
			String selectedFacilityId  = "564";
			//String selectedReason = "1";
			List<RerouteClaimInfo> claims_to_be_rerouted = new ArrayList<>();
			
			RerouteClaimInfo info = new RerouteClaimInfo(2001, "Benjamin Lewis", "CREW");
			claims_to_be_rerouted.add(info);
			info = new RerouteClaimInfo(535, "Emma Benny", "ROMETTY");
			claims_to_be_rerouted.add(info);
			
			RerouteClaimRequest request= new RerouteClaimRequest();
			request.setClaims_to_be_rerouted(claims_to_be_rerouted);
			request.setSelectedFacility(selectedFacilityId);
			request.setSelectedVisn(selectedVisnId);
			//request.setSelectedReason(selectedReason);
			request.setCurrent_user_name(current_user_name);
			
			ResultActions s = mockMvc.perform(put("/api/v1/rerouteClaims/reroutes/").contentType(MediaType.APPLICATION_JSON)
					.content(getRequestJson(request))).andDo(print());

			if (s.andReturn().getResponse().getStatus() != HttpStatus.OK.value()) {
				logger.info("test_processReroutes_error:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.BAD_REQUEST.value() != s.andReturn().getResponse().getStatus());
			} else {
				logger.info("test_processReroutes_error:" + s.andReturn().getResponse().getStatus());
				assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
			}
		} catch (Exception e) {
			logger.error("test_processReroutes_error -- ");
			e.printStackTrace();
		}
	}
	
	private String getRequestJson(Object request) {
		String requestJson = null;
		try {
			ObjectMapper mapper = new ObjectMapper();
		    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
			requestJson = ow.writeValueAsString(request);
			System.out.println("requestJson - " + requestJson);
		
		} catch (JsonProcessingException e) {
			logger.error("getRequestJson JsonProcessingException -- ");
			e.printStackTrace();
		
		}
		
		return requestJson;
	}
	
	
}