package gov.va.med.fee.integration;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
//import java.util.Calendar;
//import java.util.Date;
import java.util.List;
//import java.util.GregorianCalendar;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.PrintClaimsRequest;
import gov.va.med.fee.model.request.SearchCriteriaRequest;
import gov.va.med.fee.report.DateValue;


@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = {AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class})
public class PrintReportControllerIntegrationTest {

	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;
	
	@Autowired MockHttpServletResponse response;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	@Test
	public void testPrintReport() throws Exception {
		SearchCriteriaRequest criteria = new SearchCriteriaRequest();
		criteria.setFormat("P");
		criteria.setReport("1");
		criteria.setReportName("Claims Completed");
		criteria.setNumResults(1);			
		criteria.setFacilities(new String[]{"1"});
		criteria.setReportTypes(new String[]{"PROF"});
		criteria.setReportName("Establish");
		criteria.setProject(0);
		
		Date fromDate = new GregorianCalendar(2000, Calendar.JANUARY, 22).getTime();
		Date toDate = new GregorianCalendar(2020, Calendar.APRIL, 30).getTime();
				
		DateValue dateValue = new DateValue();
		dateValue.setFromDate(fromDate);
		dateValue.setToDate(toDate);
		criteria.setDateValue(dateValue);
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
	    
	    String requestJson=ow.writeValueAsString(criteria);   
		ResultActions s = mockMvc.perform(post("/api/v1/reports/pdf").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
		
		 
		
		System.out.println("Done!");
	}
	
	@Test
	public void testPrintClaims() throws Exception {
		PrintClaimsRequest printClaimsRequest = new PrintClaimsRequest();
		List<Long> list = new ArrayList<>();
		list.add(102L);
		printClaimsRequest.setIds(list);
		printClaimsRequest.setGuid("VHAISMB");
		
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
	    
	    String requestJson=ow.writeValueAsString(printClaimsRequest);   
	    ResultActions s = mockMvc.perform(post("/api/v1/reports/claims").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
				
		System.out.println("Done!");
	}
	
	@Test
	public void testPrintClaimsPdf() throws Exception {
		PrintClaimsRequest printClaimsRequest = new PrintClaimsRequest();
		List<Long> list = new ArrayList<>();
		list.add(102L);
		list.add(103L);
		list.add(104L);
		printClaimsRequest.setIds(list);
		printClaimsRequest.setGuid("VHAISMB");
		
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
	    
	    String requestJson=ow.writeValueAsString(printClaimsRequest);   
	    ResultActions s = mockMvc.perform(post("/api/v1/reports/claims/pdf").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
				
		System.out.println("Done!");
	}
}
