/**
 * 
 */
package gov.va.med.fee.integration;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Vamsi Gangarapu
 *
 */
//Test case to test OAuth 2.0 configuration
//Test case will decode JWT token and test accordingly
@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { gov.va.med.fee.configuration.AppConfig.class,
		gov.va.med.fee.configuration.hibernate.PersistenceConfig.class,
		gov.va.med.fee.configuration.spring.SpringMvcConfig.class })
@ActiveProfiles("dev")
public class OAuthIntegrationTest {
	private static final Logger logger = LogManager.getLogger(OAuthIntegrationTest.class);

	@Autowired
	Environment env;

	static final String PROJECT_ID = "/fpps/oauth/token";
	static final String OAUTH_SERVICE_URI = "http://";
	//static final String OAUTH_PASSWORD_GRANT = "?grant_type=password&username=fpps&password=fpps";
	static final String OAUTH_PASSWORD_GRANT = "?grant_type=password&username=fpps&password=mHqwnM}yT~={k2";
	static final String OAUTH_ACCESS_TOKEN = "?access_token=";
	static final String CLIENT_USERNAME = "FPPS_FRONTEND_APP:fpps123456";

	/**
	 * @throws JsonParseException
	 * @throws JsonMappingException
	 * @throws IOException
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	@Test
	public void getJwtToken() throws JsonParseException, JsonMappingException, IOException {

		String port = env.getProperty("oauth2.port");

		String hostAddress = InetAddress.getLocalHost().getHostAddress();
		//hostAddress = hostAddress + ":";
		hostAddress = "IP            :";
				

		logger.info(hostAddress);

		logger.info("Testing OAuth 2.0");

		HttpHeaders headers = new HttpHeaders();
		headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));

		String base64ClientCredentials = new String(Base64.encodeBase64(CLIENT_USERNAME.getBytes()));
		headers.add("Authorization", "Basic " + base64ClientCredentials);
		HttpEntity<String> request = new HttpEntity<String>(headers);
		try {
			RestTemplate restTemplate = new RestTemplate();
			ResponseEntity<Object> response = restTemplate.exchange(
					OAUTH_SERVICE_URI + hostAddress + port + PROJECT_ID + OAUTH_PASSWORD_GRANT, HttpMethod.POST,
					request, Object.class);
			assertEquals(HttpStatus.OK, response.getStatusCode());
			LinkedHashMap<String, Object> map = (LinkedHashMap<String, Object>) response.getBody();

			if (map != null) {
				assertTrue(map.containsKey("access_token"));
				assertTrue(map.containsKey("token_type"));
				assertEquals("bearer", map.get("token_type"));
				assertTrue(map.containsKey("refresh_token"));
				assertTrue(map.containsKey("expires_in"));
				assertTrue(map.containsKey("scope"));
				assertTrue(map.containsKey("jti"));

				String accessToken = (String) map.get("access_token");

				Jwt jwtToken = JwtHelper.decode(accessToken);

				String claims = jwtToken.getClaims();

				HashMap claimsMap = new ObjectMapper().readValue(claims, HashMap.class);
				assertEquals("FPPS_FRONTEND_APP", claimsMap.get("client_id"));
				assertEquals("fpps", claimsMap.get("user_name"));
				assertEquals("read", (((List<String>) claimsMap.get("scope")).get(0)));
				assertEquals("write", (((List<String>) claimsMap.get("scope")).get(1)));
				assertEquals("trust", (((List<String>) claimsMap.get("scope")).get(2)));
				assertEquals("ROLE_ADMIN", (((List<String>) claimsMap.get("authorities")).get(0)));
				logger.info("OAuth 2.0 TestCase Successful");
			}
		} catch (RestClientException ex) {
			logger.info("Exception is " + ex);
		}
	}
}
