package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.response.DisapproveClaims;

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class })
public class DisapproveClaimControllerIntegrationTest {
	
	private static final Logger logger = LogManager.getLogger(DisapproveClaimControllerIntegrationTest.class);
	
	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}
	
	
	@Test
	public void test_getClaimsToDisapprove() throws Exception {
		List<Long> claimIdReq = new ArrayList<>();
		claimIdReq.add(102L);
		claimIdReq.add(120L);
		
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(claimIdReq);
		
		ResultActions s = mockMvc.perform(post("/api/v1/disapproveClaim/claims").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
		
		logger.info("test_getClaimsToDisapprove:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}	
	
	/**
	 * @throws Exception
	 */
	
	
	@Test
	public void test_populateAdjustmentReasons_success() throws Exception {
		ResultActions s = mockMvc.perform(get("/api/v1/disapproveClaim/reasons")).andDo(print())
				.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));

		logger.info("test_populateAdjustmentReasons_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}	
	
	@Test
	public void test_disapproveClaims() throws Exception {
		List<Long> claimIdReq = new ArrayList<>();
		claimIdReq.add(120L);
		DisapproveClaims claims = new DisapproveClaims("VHAISMBAIAHBBB", "123","Rejection Rejection",claimIdReq);
		
		
		ObjectMapper mapper = new ObjectMapper();
	    mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
	    ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(claims);		
		
		ResultActions s = mockMvc.perform(post("/api/v1/disapproveClaim").contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print());
		
		logger.info("test_disapproveClaims:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}	
}