package gov.va.med.fee.integration;

import static org.junit.Assert.assertFalse;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;

import gov.va.med.fee.configuration.AppConfig;
import gov.va.med.fee.configuration.hibernate.PersistenceConfig;
import gov.va.med.fee.configuration.spring.SpringMvcConfig;
import gov.va.med.fee.model.request.ClaimRequest;

/**
 * 
 * @author Muneshwar Baiah
 *
 */

@WebAppConfiguration
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes = { AppConfig.class, PersistenceConfig.class, SpringMvcConfig.class })
public class ClaimControllerIntegrationTest {
	private static final Logger logger = LogManager.getLogger(ClaimControllerIntegrationTest.class);

	@Autowired
	private WebApplicationContext wac;
	private MockMvc mockMvc;

	@Before
	public void setup() {
		this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
	}

	/**
	 * @throws Exception
	 */
	/*@Test
	public void test_getAwaitingProcessingClaims_success() throws Exception {
		// Setup
		AwaitingProcessingRequest awaitingProcessingRequest = new AwaitingProcessingRequest();

		List<String> activeStations = new ArrayList<String>();
		List<Long> visns = new ArrayList<Long>();
		List<String> privacyRestrictions = new ArrayList<String>();

		activeStations.add("402");
		activeStations.add("509");
		activeStations.add("123");
		activeStations.add("405");
		
		visns.add(19L);
		visns.add(6L);
		visns.add(22L);
		visns.add(17L);
		
		privacyRestrictions.add("ADMIN");

		awaitingProcessingRequest.setActiveStations(activeStations);
		awaitingProcessingRequest.setVisns(visns);
		awaitingProcessingRequest.setPrivacyRestrictions(privacyRestrictions);

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson = ow.writeValueAsString(awaitingProcessingRequest);
		ResultActions s = mockMvc
				.perform(
						post("/api/v1/awaitingProcessing").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().isOk())
				.andExpect(content().contentType("application/json;charset=UTF-8"));
		logger.info("testGetClaimByIndex_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}*/

	/**
	 * @throws Exception
	 */
	@Test
	public void test_getAwaitingProcessingClaims_Error() throws Exception {
		// Setup
		ClaimRequest claimRequest = new ClaimRequest();

		List<String> activeStations = new ArrayList<String>();
		List<Long> visns = new ArrayList<Long>();
		List<String> privacyRestrictions = new ArrayList<String>();

		activeStations.add("2");
		visns.add(1L);
		privacyRestrictions.add("ADMIN");

		claimRequest.setActiveStations(activeStations);
		claimRequest.setVisns(visns);
		claimRequest.setPrivacyRestrictions(privacyRestrictions);

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson = ow.writeValueAsString(claimRequest);

		ResultActions s = mockMvc
				.perform(
						post("/api/v1/awaitingProcessing").contentType(MediaType.APPLICATION_JSON).content(requestJson))
				.andDo(print()).andExpect(status().is4xxClientError());

		logger.info("test_getAwaitingProcessingClaims_Error:" + s.andReturn().getResponse().getStatus());
		assertFalse((HttpStatus.NOT_FOUND.value() != s.andReturn().getResponse().getStatus()));
	}

	/**
	 * @throws Exception
	 */
	/*@Test
	public void test_updateAwaitingProcessingClaimsStatus_success() throws Exception {
		// Setup
		AwaitingProcessingRequest awaitingProcessingRequest = new AwaitingProcessingRequest();

		List<String> activeStations = new ArrayList<String>();
		List<Long> visns = new ArrayList<Long>();
		List<String> privacyRestrictions = new ArrayList<String>();
		List<Long> ids = new ArrayList<Long>();
		ids.add(111L);
		activeStations.add("402");
		activeStations.add("509");
		activeStations.add("123");
		activeStations.add("405");
		
		visns.add(19L);
		visns.add(6L);
		visns.add(22L);
		visns.add(17L);
		
		privacyRestrictions.add("ADMIN");

		awaitingProcessingRequest.setUserName("IntegrationTestUser");
		awaitingProcessingRequest.setIds(ids);
		awaitingProcessingRequest.setActiveStations(activeStations);
		awaitingProcessingRequest.setVisns(visns);
		awaitingProcessingRequest.setPrivacyRestrictions(privacyRestrictions);

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();

		String requestJson = ow.writeValueAsString(awaitingProcessingRequest);
		ResultActions s = mockMvc
				.perform(post("/api/v1/awaitingProcessing/processClaims").contentType(MediaType.APPLICATION_JSON)
						.content(requestJson))
				.andDo(print()).andExpect(status().isOk())
				.andExpect(content().contentType("application/json;charset=UTF-8"));
		logger.info("testGetClaimByIndex_success:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.OK.value() != s.andReturn().getResponse().getStatus());
	}
*/
	/**
	 * @throws Exception
	 */
	@Test
	public void test_updateAwaitingProcessingClaimsStatus_Error() throws Exception {
		// Setup
		ClaimRequest claimRequest = new ClaimRequest();

		List<String> activeStations = new ArrayList<String>();
		List<Long> visns = new ArrayList<Long>();
		List<String> privacyRestrictions = new ArrayList<String>();
		List<Long> ids = new ArrayList<Long>();
		ids.add(10400L);
		activeStations.add("2");
		visns.add(1L);
		privacyRestrictions.add("ADMIN");

		claimRequest.setIds(ids);
		claimRequest.setActiveStations(activeStations);
		claimRequest.setVisns(visns);
		claimRequest.setPrivacyRestrictions(privacyRestrictions);

		ObjectMapper mapper = new ObjectMapper();
		mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
		ObjectWriter ow = mapper.writer().withDefaultPrettyPrinter();
		String requestJson = ow.writeValueAsString(claimRequest);

		ResultActions s = mockMvc.perform(post("/api/v1/awaitingProcessing/processClaims")
				.contentType(MediaType.APPLICATION_JSON).content(requestJson)).andDo(print())
				.andExpect(status().is4xxClientError());

		logger.info("test_getAwaitingProcessingClaims_Error:" + s.andReturn().getResponse().getStatus());
		assertFalse(HttpStatus.NOT_FOUND.value() != s.andReturn().getResponse().getStatus());
	}

	@Test
	public void test_getClaimLineItems() throws Exception {
		/*/api/v1/claim/lineItems/{claimId}*/
		
		ResultActions s = mockMvc.perform(get("/api/v1/claim/lineItems/{claimId}", 103L)).andDo(print())
			.andExpect(status().isOk()).andExpect(content().contentType("application/json;charset=UTF-8"));
		
		logger.info("test_getClaimsToReconcile:" + s.andReturn().getResponse().getStatus());
	}
}